/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.client;

import java.net.URL;
import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.client.ActiveObject;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.jsnative.Location;

public class ALocation
extends ActiveObject
implements Location {
    private static final long serialVersionUID = 1L;
    private AWindow m_window;
    private String m_hash = null;
    private String m_host = null;
    private String m_hostname = null;
    private String m_href = null;
    private String m_pathname = null;
    private String m_port = null;
    private String m_protocol = null;
    private String m_search = null;

    public ALocation(AWindow window) {
        this.m_window = window;
        this.populateScriptable(ALocation.class, window == null ? null : window.getBrowserType());
    }

    public String getHash() {
        if (this.m_hash != null) {
            return this.m_hash;
        }
        if (this.m_window == null || this.m_window.getURL() == null) {
            return "";
        }
        String r = this.m_window.getURL().getRef();
        r = r == null ? "" : "#" + r;
        return r;
    }

    public String getHost() {
        if (this.m_host != null) {
            return this.m_host;
        }
        if (this.m_window == null || this.m_window.getURL() == null) {
            return "";
        }
        URL url = this.m_window.getURL();
        int portNumber = url.getPort();
        String portStr = "";
        if (portNumber > 0) {
            portStr = ":" + portNumber;
        }
        return String.valueOf(url.getHost()) + portStr;
    }

    public String getHostname() {
        if (this.m_hostname != null) {
            return this.m_hostname;
        }
        if (this.m_window == null || this.m_window.getURL() == null) {
            return "";
        }
        String h = this.m_window.getURL().getHost();
        if (h == null) {
            h = "";
        }
        return h;
    }

    public String getHref() {
        if (this.m_href != null) {
            return this.m_href;
        }
        if (this.m_window == null || this.m_window.getURL() == null) {
            return "";
        }
        String href = this.m_window.getURL().toString();
        if (href == null) {
            href = "";
        }
        return href;
    }

    public String getPathname() {
        if (this.m_pathname != null) {
            return this.m_pathname;
        }
        if (this.m_window == null || this.m_window.getURL() == null) {
            return "";
        }
        String p = this.getURLPath(this.m_window.getURL().toString());
        if (p == null) {
            p = "";
        }
        return p;
    }

    public String getPort() {
        if (this.m_port != null) {
            return this.m_port;
        }
        if (this.m_window == null || this.m_window.getURL() == null) {
            return "";
        }
        int portNumber = this.m_window.getURL().getPort();
        if (portNumber > 0) {
            return String.valueOf(portNumber);
        }
        return "";
    }

    public String getProtocol() {
        if (this.m_protocol != null) {
            return this.m_protocol;
        }
        if (this.m_window == null || this.m_window.getURL() == null) {
            return "";
        }
        String p = this.m_window.getURL().getProtocol();
        p = p == null ? "" : String.valueOf(p) + ":";
        return p;
    }

    public String getSearch() {
        if (this.m_search != null) {
            return this.m_search;
        }
        if (this.m_window == null || this.m_window.getURL() == null) {
            return "";
        }
        String q = this.getURLQuery(this.m_window.getURL().toString());
        if (q == null) {
            q = "";
        }
        return q;
    }

    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string") || type.equals("undefined")) {
            return this.getHref();
        }
        return null;
    }

    public void setHash(String hash) {
        this.m_hash = hash;
        if (this.getBrowserBinding() != null) {
            this.getBrowserBinding().setDocumentProperty("location.hash", "\"" + hash + "\"");
        }
    }

    public void setHost(String host) {
        this.m_host = host;
        if (this.getBrowserBinding() != null) {
            this.getBrowserBinding().setDocumentProperty("location.host", "\"" + host + "\"");
        }
    }

    public void setHostname(String hostname) {
        this.m_hostname = hostname;
        if (this.getBrowserBinding() != null) {
            this.getBrowserBinding().setDocumentProperty("location.hostname", "\"" + hostname + "\"");
        }
    }

    public void setHref(String href) {
        this.m_href = href;
        if (this.getBrowserBinding() != null) {
            this.getBrowserBinding().setDocumentProperty("location.href", "\"" + href + "\"");
        }
    }

    public void setPathname(String pathname) {
        this.m_pathname = pathname;
        if (this.getBrowserBinding() != null) {
            this.getBrowserBinding().setDocumentProperty("location.pathname", "\"" + pathname + "\"");
        }
    }

    public void setPort(String port) {
        this.m_port = port;
        if (this.getBrowserBinding() != null) {
            this.getBrowserBinding().setDocumentProperty("location.port", "\"" + port + "\"");
        }
    }

    public void setProtocol(String protocol) {
        this.m_protocol = protocol;
        if (this.getBrowserBinding() != null) {
            this.getBrowserBinding().setDocumentProperty("location.protocol", "\"" + protocol + "\"");
        }
    }

    public void setSearch(String search) {
        this.m_search = search;
        if (this.getBrowserBinding() != null) {
            this.getBrowserBinding().setDocumentProperty("location.search", "\"" + search + "\"");
        }
    }

    public void assign(String url) {
        if (this.getBrowserBinding() != null) {
            this.getBrowserBinding().locationAssign(url);
        }
    }

    public void reload() {
        if (this.getBrowserBinding() != null) {
            this.getBrowserBinding().locationReload(false);
        }
    }

    public void reload(boolean forceGet) {
        if (this.getBrowserBinding() != null) {
            this.getBrowserBinding().locationReload(forceGet);
        }
    }

    public void replace(String url) {
        if (this.getBrowserBinding() != null) {
            this.getBrowserBinding().locationReplace(url);
        }
    }

    public AWindow getWindow() {
        return this.m_window;
    }

    @Override
    public String toString() {
        return this.getHref();
    }

    private String getURLPath(String u) {
        if (u == null || u.trim().length() <= 0) {
            return "";
        }
        String s = u;
        int i = s.lastIndexOf(59);
        if (i > -1) {
            s = s.substring(0, i);
        }
        if ((i = s.lastIndexOf(35)) > -1) {
            s = s.substring(0, i);
        }
        if ((i = s.indexOf("://")) > -1) {
            s = s.substring(i + 3);
        }
        if ((i = (s = (i = s.indexOf(47)) > -1 ? s.substring(i) : "/").indexOf(63)) > -1) {
            s = s.substring(0, i);
        }
        return s;
    }

    private IBrowserBinding getBrowserBinding() {
        if (this.m_window == null || this.m_window.getBrowserBinding() == null) {
            return null;
        }
        return this.m_window.getBrowserBinding();
    }

    private String getURLQuery(String u) {
        if (u == null || u.trim().length() <= 0) {
            return "";
        }
        String s = u;
        int i = s.indexOf(63);
        if (i < 0) {
            return "";
        }
        if ((i = (s = s.substring(i)).lastIndexOf(35)) > -1) {
            s = s.substring(0, i);
        }
        return s;
    }
}

