/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import org.eclipse.vjet.dsf.active.dom.html.AElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlCollection;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlTableCell;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DTd;
import org.eclipse.vjet.dsf.html.dom.DTr;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.jsnative.HtmlCollection;
import org.eclipse.vjet.dsf.jsnative.HtmlTableCell;
import org.eclipse.vjet.dsf.jsnative.HtmlTableRow;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;

public class AHtmlTableRow
extends AHtmlElement
implements HtmlTableRow {
    private static final long serialVersionUID = 1L;
    private AHtmlCollection m_cells;

    protected AHtmlTableRow(AHtmlDocument doc, DTr node) {
        super(doc, (BaseHtmlElement)node);
        this.populateScriptable(AHtmlTableRow.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    @Override
    public ANode cloneNode(boolean deep) {
        AHtmlTableRow clonedNode = (AHtmlTableRow)super.cloneNode(deep);
        clonedNode.m_cells = null;
        return clonedNode;
    }

    public void deleteCell(int index) {
        ANode child = (AElement)this.getFirstChild();
        while (child != null) {
            if (child instanceof AHtmlTableCell) {
                if (index == 0) {
                    this.removeChild(child);
                    return;
                }
                --index;
            }
            child = (ANode)child.getNextSibling();
        }
    }

    public String getAlign() {
        return this.getDTr().getHtmlAlign();
    }

    public String getBgColor() {
        return this.getDTr().getHtmlBgColor();
    }

    public HtmlCollection getCells() {
        if (this.m_cells == null) {
            this.m_cells = new AHtmlCollection(this, -3);
        }
        return this.m_cells;
    }

    public String getCh() {
        return this.getDTr().getHtmlCh();
    }

    public String getChOff() {
        return this.getDTr().getHtmlChOff();
    }

    public int getRowIndex() {
        return this.getDTr().getHtmlRowIndex();
    }

    public int getSectionRowIndex() {
        return this.getDTr().getHtmlSectionRowIndex();
    }

    public String getVAlign() {
        return this.getDTr().getHtmlValign();
    }

    public HtmlTableCell insertCell(int index) {
        DTd td = this.getDTr().htmlInsertCell(index);
        AHtmlTableCell newCell = new AHtmlTableCell(this.getOwnerDocument(), td);
        ANode child = (ANode)this.getFirstChild();
        while (child != null) {
            if (child instanceof AHtmlTableCell) {
                if (index == 0) {
                    this.insertBefore(newCell, child, false);
                    return newCell;
                }
                --index;
            }
            child = (ANode)child.getNextSibling();
        }
        this.appendChild(newCell, false);
        return newCell;
    }

    public void setAlign(String align) {
        this.getDTr().setHtmlAlign(align);
        this.onAttrChange(EHtmlAttr.align, align);
    }

    public void setBgColor(String bgColor) {
        this.getDTr().setHtmlBgColor(bgColor);
        this.onAttrChange(EHtmlAttr.bgcolor, bgColor);
    }

    public void setCh(String _char) {
        this.getDTr().setHtmlCh(_char);
        this.onAttrChange(EHtmlAttr._char, _char);
    }

    public void setChOff(String charoff) {
        this.getDTr().setHtmlChOff(charoff);
        this.onAttrChange(EHtmlAttr.charoff, charoff);
    }

    public void setRowIndex(int rowIndex) {
        this.getDTr().setHtmlRowIndex(rowIndex);
    }

    public void setSectionRowIndex(int sectionRowIndex) {
        this.getDTr().setHtmlSectionRowIndex(sectionRowIndex);
    }

    public void setVAlign(String valign) {
        this.getDTr().setHtmlValign(valign);
        this.onAttrChange(EHtmlAttr.valign, valign);
    }

    public Object getOnblur() {
        return this.getOnBlur();
    }

    public Object getOnfocus() {
        return this.getOnFocus();
    }

    public void setOnblur(Object functionRef) {
        this.setOnBlur(functionRef);
    }

    public void setOnfocus(Object functionRef) {
        this.setOnFocus(functionRef);
    }

    public Object getOnkeydown() {
        return this.getOnKeyDown();
    }

    public void setOnkeydown(Object functionRef) {
        this.setOnKeyDown(functionRef);
    }

    public Object getOnkeypress() {
        return this.getOnKeyPress();
    }

    public void setOnkeypress(Object functionRef) {
        this.setOnKeyPress(functionRef);
    }

    public Object getOnkeyup() {
        return this.getOnKeyUp();
    }

    public void setOnkeyup(Object functionRef) {
        this.setOnKeyUp(functionRef);
    }

    public Object getOnclick() {
        return this.getOnClick();
    }

    public void setOnclick(Object functionRef) {
        this.setOnClick(functionRef);
    }

    public Object getOndblclick() {
        return this.getOnDblClick();
    }

    public void setOndblclick(Object functionRef) {
        this.setOnDblClick(functionRef);
    }

    public Object getOnmousedown() {
        return this.getOnMouseDown();
    }

    public void setOnmousedown(Object functionRef) {
        this.setOnMouseDown(functionRef);
    }

    public Object getOnmousemove() {
        return this.getOnMouseMove();
    }

    public void setOnmousemove(Object functionRef) {
        this.setOnMouseMove(functionRef);
    }

    public Object getOnmouseout() {
        return this.getOnMouseOut();
    }

    public void setOnmouseout(Object functionRef) {
        this.setOnMouseOut(functionRef);
    }

    public Object getOnmouseover() {
        return this.getOnMouseOver();
    }

    public void setOnmouseover(Object functionRef) {
        this.setOnMouseOver(functionRef);
    }

    public Object getOnmouseup() {
        return this.getOnMouseUp();
    }

    public void setOnmouseup(Object functionRef) {
        this.setOnMouseUp(functionRef);
    }

    private DTr getDTr() {
        return (DTr)this.getDNode();
    }
}

