/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import java.util.HashMap;
import java.util.Map;

public class Encoding {
    public static final int SOURCE_UNKNOWN = 0;
    public static final int SOURCE_DEFAULT = 1;
    public static final int SOURCE_EUROPE = 2;
    public static final int SOURCE_JP_AUTO = 3;
    public static final int SOURCE_SJIS = 4;
    public static final int SOURCE_SJIS2 = 5;
    public static final int SOURCE_NEW_JIS = 6;
    public static final int SOURCE_EUC_JP = 7;
    public static final int SOURCE_EUC_JP2 = 8;
    public static final int SOURCE_BIG5 = 9;
    public static final int SOURCE_EUC_CN = 10;
    public static final int SOURCE_EUC_KR = 11;
    public static final int SOURCE_EUC_TW = 12;
    public static final int SOURCE_CYRILLIC = 13;
    public static final int SOURCE_ARABIC = 14;
    public static final int SOURCE_GREEK = 15;
    public static final int SOURCE_HEBREW = 16;
    public static final int SOURCE_WIN_EEUR = 17;
    public static final int SOURCE_WIN_CY = 18;
    public static final int SOURCE_WIN_GR = 19;
    public static final int SOURCE_WIN_TK = 20;
    public static final int SOURCE_WIN_IL = 21;
    public static final int SOURCE_WIN_AR = 22;
    public static final int SOURCE_WIN_BL = 23;
    public static final int SOURCE_WIN_VN = 24;
    public static final String[] JAVA_ENCODING = new String[]{"ISO8859_1", "UTF8", "ISO8859_1", "JISAutoDetect", "SJIS", "SJIS", "ISO2022JN", "EUC_JP", "EUC_JP", "Big5", "GBK", "EUC_KR", "", "ISO8859_5", "ISO8859_6", "ISO8859_7", "ISO8859_8", "Cp1250", "Cp1251", "Cp1253", "Cp1254", "Cp1255", "Cp1256", "Cp1257", "Cp1258"};
    public static final String[] HDML;
    public static final String[] WML;
    public static final String[] HTML;
    public static final String[] FILE_ENCODING_SUFFIX;
    public static final String[][] COUNTRY_DEFAULT;
    public static Map s_defaultCharsetPerLanguage;

    static {
        String[] stringArray = new String[21];
        stringArray[1] = "US-ASCII";
        stringArray[2] = "ISO-8859-1";
        stringArray[3] = "SHIFT_JIS";
        stringArray[4] = "EUC-JP";
        stringArray[5] = "Big5";
        stringArray[6] = "GB2312";
        stringArray[7] = "korean";
        stringArray[8] = "";
        stringArray[9] = "ISO-8859-5";
        stringArray[10] = "ISO-8859-6";
        stringArray[11] = "ISO-8859-7";
        stringArray[12] = "ISO-8859-8";
        stringArray[13] = "windows-1250";
        stringArray[14] = "windows-1251";
        stringArray[15] = "windows-1253";
        stringArray[16] = "windows-1254";
        stringArray[17] = "windows-1255";
        stringArray[18] = "windows-1256";
        stringArray[19] = "windows-1257";
        stringArray[20] = "windows-1258";
        HDML = stringArray;
        String[] stringArray2 = new String[25];
        stringArray2[1] = "UTF-8";
        stringArray2[2] = "ISO-8859-1";
        stringArray2[3] = "SHIFT_JIS";
        stringArray2[4] = "SHIFT_JIS";
        stringArray2[5] = "SHIFT_JIS";
        stringArray2[6] = "SHIFT_JIS";
        stringArray2[7] = "EUC-JP";
        stringArray2[8] = "EUC-JP";
        stringArray2[9] = "Big5";
        stringArray2[10] = "GB2312";
        stringArray2[11] = "KS_C_5601_1987";
        stringArray2[12] = "Big5";
        stringArray2[13] = "ISO-8859-5";
        stringArray2[14] = "ISO-8859-6";
        stringArray2[15] = "ISO-8859-7";
        stringArray2[16] = "ISO-8859-8";
        stringArray2[17] = "windows-1250";
        stringArray2[18] = "windows-1251";
        stringArray2[19] = "windows-1253";
        stringArray2[20] = "windows-1254";
        stringArray2[21] = "windows-1255";
        stringArray2[22] = "windows-1256";
        stringArray2[23] = "windows-1257";
        stringArray2[24] = "windows-1258";
        WML = stringArray2;
        String[] stringArray3 = new String[25];
        stringArray3[1] = "UTF-8";
        stringArray3[2] = "iso-8859-1";
        stringArray3[3] = "japan-auto-detect";
        stringArray3[4] = "x-sjis";
        stringArray3[5] = "shift_jis";
        stringArray3[6] = "iso-2022-jp";
        stringArray3[7] = "x-euc-jp";
        stringArray3[8] = "euc-jp";
        stringArray3[9] = "big5";
        stringArray3[10] = "gb2312";
        stringArray3[11] = "euc-kr";
        stringArray3[12] = "x-euc-tw";
        stringArray3[13] = "iso-8859-5";
        stringArray3[14] = "iso-8859-6";
        stringArray3[15] = "iso-8859-7";
        stringArray3[16] = "iso-8859-8";
        stringArray3[17] = "windows-1250";
        stringArray3[18] = "windows-1251";
        stringArray3[19] = "windows-1253";
        stringArray3[20] = "windows-1254";
        stringArray3[21] = "windows-1255";
        stringArray3[22] = "windows-1256";
        stringArray3[23] = "windows-1257";
        stringArray3[24] = "windows-1258";
        HTML = stringArray3;
        FILE_ENCODING_SUFFIX = new String[]{"", ".utf8", ".iso1", ".sjis", ".sjis", ".sjis", ".eucj", ".eucj", ".big5", ".gb2312", ".euck", ".euct", ".iso5", ".iso6", ".iso7", ".iso8", ".w50", ".w51", ".w53", ".w54", ".w55", ".w56", ".w57", ".w58"};
        COUNTRY_DEFAULT = new String[][]{{"jp", "japan-auto-detect"}, {"fr", "iso-8859-1"}, {"de", "iso-8859-1"}, {"it", "iso-8859-1"}, {"es", "iso-8859-1"}, {"gr", "windows-1253"}, {"ch", "iso-8859-1"}, {"kr", "euc-kr"}};
        s_defaultCharsetPerLanguage = new HashMap();
        s_defaultCharsetPerLanguage.put("en", "iso-8859-1");
        s_defaultCharsetPerLanguage.put("es", "iso-8859-1");
        s_defaultCharsetPerLanguage.put("fr", "iso-8859-1");
        s_defaultCharsetPerLanguage.put("fi", "iso-8859-1");
        s_defaultCharsetPerLanguage.put("de", "iso-8859-1");
        s_defaultCharsetPerLanguage.put("it", "iso-8859-1");
        s_defaultCharsetPerLanguage.put("da", "iso-8859-1");
        s_defaultCharsetPerLanguage.put("nl", "iso-8859-1");
        s_defaultCharsetPerLanguage.put("ja", "shift_jis");
        s_defaultCharsetPerLanguage.put("ru", "windows-1251");
        s_defaultCharsetPerLanguage.put("sr", "windows-1251");
        s_defaultCharsetPerLanguage.put("sk", "windows-1251");
        s_defaultCharsetPerLanguage.put("sl", "windows-1251");
        s_defaultCharsetPerLanguage.put("uz", "windows-1251");
        s_defaultCharsetPerLanguage.put("gr", "windows-1253");
        s_defaultCharsetPerLanguage.put("he", "windows-1255");
        s_defaultCharsetPerLanguage.put("kr", "euc-kr");
        s_defaultCharsetPerLanguage.put("zh-cn", "gb2312");
        s_defaultCharsetPerLanguage.put("zh-tw", "big5");
        s_defaultCharsetPerLanguage.put("zh", "big5");
    }

    public static String getDefaultCharset(String language) {
        String charset = (String)s_defaultCharsetPerLanguage.get(language);
        if (charset == null) {
            charset = (String)s_defaultCharsetPerLanguage.get(language.substring(0, 2));
        }
        return charset;
    }

    public static String getCharset(int index, int clientML) {
        String charset;
        switch (clientML) {
            case 0: 
            case 1: {
                charset = WML[index];
                break;
            }
            case 3: {
                charset = HDML[index];
                break;
            }
            default: {
                charset = HTML[index];
            }
        }
        return charset;
    }

    public static int detectSourceEncoding(String sourceCharset) {
        return Encoding.detectSourceEncoding(sourceCharset, true);
    }

    public static int detectSourceEncoding(String sourceCharset, boolean forSource) {
        if (sourceCharset == null || sourceCharset.length() == 0) {
            return 0;
        }
        int sourceEncoding = 0;
        int i = 0;
        while (i < HTML.length) {
            if (HTML[i] != null && HTML[i].equalsIgnoreCase(sourceCharset)) break;
            ++i;
        }
        if (i < HTML.length) {
            sourceEncoding = i;
            if (forSource && (sourceEncoding == 4 || sourceEncoding == 5 || sourceEncoding == 6 || sourceEncoding == 7 || sourceEncoding == 8)) {
                sourceEncoding = 3;
            }
        }
        return sourceEncoding;
    }

    public static String countryDefaultCharset(String urlBase) {
        String localUrlBase = urlBase;
        String charset = null;
        int i = localUrlBase.length() - 1;
        if (i >= 0 && localUrlBase.charAt(i) == '/') {
            localUrlBase = urlBase.substring(0, i);
        }
        if ((i = localUrlBase.lastIndexOf(".")) >= 0) {
            localUrlBase = urlBase.substring(i + 1);
        }
        i = 0;
        while (i < COUNTRY_DEFAULT.length) {
            if (COUNTRY_DEFAULT[i][0].equalsIgnoreCase(localUrlBase)) {
                charset = COUNTRY_DEFAULT[i][1];
                break;
            }
            ++i;
        }
        return charset;
    }
}

