/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import java.util.ArrayList;
import org.eclipse.vjet.dsf.html.js.JSWindow;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;

public class JSElementArray
extends ScriptableObject {
    private JSWindow window = null;
    private Context cx = null;
    private Scriptable scope = null;
    private ArrayList elements = new ArrayList();

    private JSElementArray() {
    }

    public JSElementArray(JSWindow window) {
        this.window = window;
        this.cx = window.getContext();
        this.scope = window.getScope();
        String[] functions = new String[]{"tags", "valueOf"};
        this.defineFunctionProperties(functions, JSElementArray.class, 2);
        this.defineProperty("length", JSElementArray.class, 2);
    }

    public String getClassName() {
        return "JSElementWraperArray";
    }

    public boolean has(String name, Scriptable start) {
        return name.equals("length");
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.elements.size();
    }

    public Object get(int index, Scriptable start) {
        if (index >= 0 && index < this.elements.size()) {
            return this.elements.get(index);
        }
        return Scriptable.NOT_FOUND;
    }

    public int getLength() {
        return this.elements.size();
    }

    public void add(Object element) {
        this.elements.add(element);
    }

    public void insertAfter(Object element, Object ref) {
        int i = 0;
        while (i < this.elements.size()) {
            if (this.elements.get(i) == ref) {
                this.elements.add(i + 1, element);
                return;
            }
            ++i;
        }
    }

    public void remove(Object element) {
        this.elements.remove(element);
    }

    public JSElementArray jsFunction_tags(String name) {
        return this.tags(name);
    }

    public JSElementArray tags(String name) {
        JSElementArray list = new JSElementArray(this.window);
        return list;
    }

    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            return type;
        }
        if (type.equals("object")) {
            return this;
        }
        if (type.equals("number")) {
            return "0";
        }
        return null;
    }
}

