/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.net.Socket;
import org.eclipse.vjet.dsf.html.js.ActiveJsExecutionControlCtx;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugger;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.ContextFactory;
import org.mozilla.mod.javascript.debug.Debugger;

public class JsDebuggerEnabler {
    public static synchronized void enable() {
        if (!ActiveJsExecutionControlCtx.ctx().needDebug()) {
            return;
        }
        ContextFactory.getGlobal().addListener((ContextFactory.Listener)new ContextListener());
    }

    private static class ContextListener
    implements ContextFactory.Listener {
        private DBGPDebugger debugger;

        private ContextListener() {
        }

        public void contextCreated(Context cx) {
            if (this.debugger != null) {
                return;
            }
            String debuggerServiceIp = System.getProperty("VJETDebugHost");
            String debuggerServicePort = System.getProperty("VJETDebugPort");
            String debuggerServiceSessionID = System.getProperty("VJETDebugSessionID");
            if (debuggerServiceIp == null || debuggerServicePort == null || debuggerServiceSessionID == null) {
                return;
            }
            try {
                Socket socket = new Socket(debuggerServiceIp, Integer.parseInt(debuggerServicePort));
                this.debugger = new DBGPDebugger(socket, "filegoeshere", debuggerServiceSessionID, cx);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            cx.setDebugger((Debugger)this.debugger, null);
            cx.setGeneratingDebug(true);
            cx.setOptimizationLevel(-1);
            this.debugger.start();
        }

        public void contextReleased(Context cx) {
            if (this.debugger != null && cx.getDebugger().equals(this.debugger)) {
                this.debugger.notifyEnd();
            }
        }
    }
}

