/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdebugger;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.vjet.dsf.html.js.ActiveJsExecutionControlCtx;
import org.eclipse.vjet.dsf.jsdebugger.DebuggerAdapter;
import org.eclipse.vjet.dsf.jsdebugger.gui.SwingGui;
import org.eclipse.vjet.dsf.jsdi.IDebuggerControl;
import org.eclipse.vjet.dsf.jsdi.IGuiCallback;
import org.eclipse.vjet.dsf.jsdi.agent.host.DebuggerConnector;
import org.eclipse.vjet.dsf.jsdi.agent.remote.DebuggerClient;
import org.mozilla.mod.javascript.ContextFactory;

public class JsDebuggerEnabler {
    private static ThreadGroup s_debuggerGroup = null;
    private static MonitorTask s_monitor = null;
    private static boolean s_useRemoteClient = false;
    private static boolean s_useEmbededClient = false;
    private static DebuggerClient s_inProcessDebuggerClient = null;

    static {
        try {
            LocateRegistry.getRegistry(null).list();
            s_useRemoteClient = true;
        }
        catch (RemoteException remoteException) {}
        if (!s_useRemoteClient) {
            RuntimeMXBean rtMxBean = ManagementFactory.getRuntimeMXBean();
            for (String arg : rtMxBean.getInputArguments()) {
                if (!arg.startsWith("-agentlib:jdwp")) continue;
                s_debuggerGroup = new ThreadGroup("JSDebugger");
                s_debuggerGroup.setDaemon(true);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableDebuggerFileChooser() {
        if (s_debuggerGroup == null) {
            return;
        }
        final DebuggerReady dr = new DebuggerReady();
        Thread t = new Thread(s_debuggerGroup, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SwingGui.initFileChooser();
                DebuggerReady debuggerReady = dr;
                synchronized (debuggerReady) {
                    dr.ready();
                    dr.notifyAll();
                }
            }
        });
        t.setDaemon(true);
        t.start();
        DebuggerReady debuggerReady = dr;
        synchronized (debuggerReady) {
            if (!dr.isReady()) {
                try {
                    dr.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DebuggerAdapter enable() {
        if (!ActiveJsExecutionControlCtx.ctx().needDebug()) {
            return null;
        }
        final DebuggerAdapter dbg = new DebuggerAdapter();
        if (!s_useRemoteClient && s_inProcessDebuggerClient == null) {
            final DebuggerReady dr = new DebuggerReady();
            Thread t = new Thread(s_debuggerGroup, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SwingGui gui;
                    if (!s_useEmbededClient) {
                        gui = new SwingGui("DSF JS Debugger");
                        gui.pack();
                        gui.setSize(600, 460);
                        gui.setDefaultCloseOperation(2);
                        gui.setVisible(true);
                        s_inProcessDebuggerClient = new DebuggerClient((IGuiCallback)gui, ActiveJsExecutionControlCtx.ctx().useSharedDebugClient());
                    } else {
                        gui = new SwingGui("DSF JS Debugger");
                        gui.pack();
                        gui.setSize(600, 460);
                        gui.setDefaultCloseOperation(2);
                        dbg.attachTo(ContextFactory.getGlobal());
                        gui.setVisible(true);
                        gui.connect(dbg);
                    }
                    DebuggerReady debuggerReady = dr;
                    synchronized (debuggerReady) {
                        dr.ready();
                        dr.notifyAll();
                    }
                }
            });
            t.setDaemon(true);
            t.start();
            DebuggerReady debuggerReady = dr;
            synchronized (debuggerReady) {
                if (!dr.isReady()) {
                    try {
                        dr.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (!s_useEmbededClient) {
            new DebuggerConnector((IDebuggerControl)dbg, null);
        }
        dbg.attachTo(ContextFactory.getGlobal());
        if (!s_useRemoteClient && s_monitor == null) {
            s_monitor = new MonitorTask();
            Timer timer = new Timer(true);
            timer.schedule((TimerTask)s_monitor, 1000L, 5000L);
        }
        return dbg;
    }

    public static boolean useRemoteClient() {
        return s_useRemoteClient;
    }

    private static int getNondaemonThreadCount(ThreadGroup tg) {
        Thread[] threads = new Thread[tg.activeCount()];
        tg.enumerate(threads);
        int count = 0;
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread tt = threadArray[n2];
            if (!tt.isDaemon()) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    private static class DebuggerReady {
        private boolean m_ready = false;

        private DebuggerReady() {
        }

        boolean isReady() {
            return this.m_ready;
        }

        void ready() {
            this.m_ready = true;
        }
    }

    private static class MonitorTask
    extends TimerTask {
        private MonitorTask() {
        }

        @Override
        public void run() {
            int nondaemonAwtThreadCount = JsDebuggerEnabler.getNondaemonThreadCount(s_debuggerGroup);
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            while (tg.getParent() != null) {
                tg = tg.getParent();
            }
            int totalNondaemonThreadCount = JsDebuggerEnabler.getNondaemonThreadCount(tg);
            if (totalNondaemonThreadCount == nondaemonAwtThreadCount) {
                System.exit(0);
            }
        }
    }
}

