/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsruntime.compregistry;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.html.js.IJsContentGenerator;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.eclipse.vjet.dsf.html.js.IJsObjectRef;
import org.eclipse.vjet.vsf.jsruntime.context.JsRuntimeCtx;
import org.eclipse.vjet.vsf.jsruntime.optimizer.JsCodeGenOptimizer;
import org.eclipse.vjet.vsf.jsruntime.optimizer.JsObjCodeGenOptimizer;

public class JsComponentRegistry {
    public static final String JSVAR_OREGISTRY = "vjo.Registry";
    public static final String JSVAR_OREGISTRY_SHORT = "_r";
    public static final String JSVAR_OREGISTRY_GET = "vjo.Registry.get";
    public static final String JSVAR_OREGISTRY_SHORT_GET = "_r.get";
    private boolean m_emitDef = false;
    private String m_regVar = "vjo.Registry";
    private List<IJsObjectRef> m_compRefs;

    public JsComponentRegistry() {
        this.reset();
    }

    public void moveOrder(String id, int order) {
        for (IJsObjectRef ref : this.m_compRefs) {
            if (!id.equals(ref.getInstanceId())) continue;
            this.m_compRefs.remove(ref);
            this.m_compRefs.add(order, ref);
            break;
        }
    }

    public IJsObjectRef getJsObject(String id) {
        if (id == null) {
            return null;
        }
        for (IJsObjectRef ref : this.m_compRefs) {
            if (!id.equals(ref.getInstanceId())) continue;
            return ref;
        }
        return null;
    }

    public IJsObjectRef getLastRef() {
        if (this.m_compRefs.size() == 0) {
            return null;
        }
        return this.m_compRefs.get(this.m_compRefs.size() - 1);
    }

    public String add(IJsObjectRef ref) {
        this.assertNotNull(ref, "JS function ref must not be null");
        String sId = ref.getInstanceId();
        if (sId != null && this.getJsObject(sId) != null) {
            this.chuck("Existing component was already added for compId: " + sId);
        } else {
            if (sId == null || sId.equals("")) {
                sId = DsfCtx.ctx().ids().nextJsCompId();
            }
            ref.setInstanceId(sId);
            this.m_compRefs.add(ref);
            this.m_emitDef = true;
        }
        return sId;
    }

    public String remove(IJsObjectRef ref) {
        this.assertNotNull(ref, "JS function ref must not be null");
        String sId = ref.getInstanceId();
        if (sId != null && this.getJsObject(sId) != null) {
            this.m_compRefs.remove(ref);
        }
        return sId;
    }

    public static String getJsInstance(String compId, boolean optimize) {
        return String.valueOf(optimize ? JSVAR_OREGISTRY_SHORT_GET : JSVAR_OREGISTRY_GET) + "('" + compId + "')";
    }

    public void reset() {
        this.m_emitDef = false;
        this.m_compRefs = new ArrayList<IJsObjectRef>(30);
    }

    public String getHandlerInit() {
        return this.getHandlerInit(new JsObjCodeGenOptimizer());
    }

    public String getHandlerInit(JsObjCodeGenOptimizer optimizer) {
        JsRuntimeCtx ctx = JsRuntimeCtx.ctx();
        StringBuilder s = new StringBuilder();
        this.setRegistryVar(JSVAR_OREGISTRY_SHORT);
        String createMethods = optimizer.createDefs();
        s.append("var ").append(JSVAR_OREGISTRY_SHORT).append("=").append(JSVAR_OREGISTRY).append(";").append("\n");
        if (!"".equals(createMethods.trim())) {
            s.append(createMethods);
        }
        int i = 0;
        Map<IJsObjectRef, List<IJsContentGenerator>> map = ctx.getContentGenerators();
        for (IJsObjectRef ref : this.m_compRefs) {
            if (!ref.isHandler() || !optimizer.contains(ref)) continue;
            String opt = optimizer.createCall(ref);
            if (opt != null) {
                s.append(this.getRegistryVar()).append(".put('").append(ref.getInstanceId()).append("', ").append(opt).append(");");
            } else {
                s.append(ref.generate(true));
            }
            this.addContentGenerators(map.get(ref), s);
            if (++i % 10 != 0) continue;
            s.append("\n");
        }
        return s.toString();
    }

    public String getInitBlock() {
        return this.getInitBlock(new JsObjCodeGenOptimizer());
    }

    public String getInitBlock(JsCodeGenOptimizer optimizer) {
        JsRuntimeCtx ctx = JsRuntimeCtx.ctx();
        StringBuilder s = new StringBuilder();
        this.setRegistryVar(JSVAR_OREGISTRY_SHORT);
        for (IJsObjectRef ref : this.m_compRefs) {
            if (ref.isHandler()) continue;
            optimizer.add(ref);
        }
        String createMethods = optimizer.createDefs();
        if (!"".equals(createMethods.trim())) {
            s.append(createMethods);
        }
        Map<IJsObjectRef, List<IJsContentGenerator>> map = ctx.getContentGenerators();
        this.addContentGenerators(map.get(JsRuntimeCtx.DEFAULT_REF), s);
        int i = 0;
        for (IJsObjectRef ref : this.m_compRefs) {
            if (ref.isHandler()) continue;
            String opt = optimizer.createCall(ref);
            if (opt != null) {
                s.append(this.getRegistryVar()).append(".put('").append(ref.getInstanceId()).append("',").append(opt).append(");").append(" ");
            } else {
                s.append(ref.generate(true)).append(" ");
            }
            this.addContentGenerators(map.get(ref), s);
            if (++i % 10 != 0) continue;
            s.append("\n");
        }
        this.resetRegistryVar();
        StringBuilder buf = new StringBuilder();
        if (i > 0) {
            buf.append("(function () {\n");
            buf.append("var ").append(JSVAR_OREGISTRY_SHORT).append(" = ").append(JSVAR_OREGISTRY).append(";").append("\n");
            buf.append((CharSequence)s);
            buf.append("})();");
            return buf.toString();
        }
        return s.toString();
    }

    private void addContentGenerators(List<IJsContentGenerator> generators, StringBuilder buf) {
        if (generators != null && generators.size() > 0) {
            for (IJsContentGenerator ref : generators) {
                if (ref instanceof IJsFunc) {
                    buf.append(((IJsFunc)ref).genInvocationJs(false)).append(" ");
                    continue;
                }
                buf.append(ref.generate()).append(" ");
            }
            buf.append("\n");
        }
    }

    public String toString() {
        Z z = new Z();
        z.format("JS client global variable name", (Object)JSVAR_OREGISTRY);
        for (IJsObjectRef ref : this.m_compRefs) {
            z.format(ref.getInstanceId(), (Object)ref);
        }
        return z.toString();
    }

    private void assertNotNull(Object o, String msg) {
        if (o == null) {
            throw new DsfRuntimeException(msg);
        }
    }

    private void chuck(String msg) {
        throw new DsfRuntimeException(msg);
    }

    public void setRegistryVar(String var) {
        if (var == null || "".equals(var)) {
            this.resetRegistryVar();
        }
        this.m_regVar = var;
    }

    public String getRegistryVar() {
        return this.m_regVar;
    }

    public void resetRegistryVar() {
        this.m_regVar = JSVAR_OREGISTRY;
    }

    public boolean isEmitDef() {
        return this.m_emitDef;
    }

    public void setEmitDef(boolean emitDef) {
        this.m_emitDef = emitDef;
    }

    public static boolean isValidKey(String key) {
        Pattern p = Pattern.compile("([a-zA-Z0-9_$]+)");
        Matcher m = p.matcher(key);
        return m.matches();
    }
}

