/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsruntime.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.context.BaseSubCtx;
import org.eclipse.vjet.dsf.common.context.ContextHelper;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.context.ISubCtx;
import org.eclipse.vjet.dsf.html.js.IJsContentGenerator;
import org.eclipse.vjet.dsf.html.js.IJsObjectRef;
import org.eclipse.vjet.dsf.html.js.IParams;
import org.eclipse.vjet.vsf.jsruntime.compregistry.JsComponentRegistry;
import org.eclipse.vjet.vsf.jsruntime.error.IErrorHandler;
import org.eclipse.vjet.vsf.jsruntime.jsconverters.registry.Java2JsTypeConverterRegistration;

public class JsRuntimeCtx
extends BaseSubCtx {
    private JsComponentRegistry m_componentRegistry;
    private Java2JsTypeConverterRegistration m_converterRegistry;
    private boolean m_useInlineEventBinding;
    private boolean m_addErrorHandling;
    private boolean m_captureJsErrorStackTrace;
    private boolean m_hideJsErrors;
    private Map<IJsObjectRef, List<IJsContentGenerator>> m_contentGenerators;
    private List<IErrorHandler> m_errorHandlers;
    private boolean m_runTimeTypeCheck;
    public static final IJsObjectRef DEFAULT_REF = new DefaultJSObj();

    public static JsRuntimeCtx ctx() {
        JsRuntimeCtx context = CtxAssociator.getCtx();
        if (context == null) {
            context = new JsRuntimeCtx();
            JsRuntimeCtx.setCtx(context);
        }
        return context;
    }

    public static void setCtx(JsRuntimeCtx context) {
        CtxAssociator.setCtx(context);
    }

    public JsComponentRegistry getCompRegistry() {
        if (this.m_componentRegistry == null) {
            this.m_componentRegistry = new JsComponentRegistry();
        }
        return this.m_componentRegistry;
    }

    public String registerComponent(IJsObjectRef ref) {
        return this.getCompRegistry().add(ref);
    }

    public Java2JsTypeConverterRegistration getConverterRegistry() {
        if (this.m_converterRegistry == null) {
            this.m_converterRegistry = new Java2JsTypeConverterRegistration(true, false);
        }
        return this.m_converterRegistry;
    }

    public void setConverterRegistry(Java2JsTypeConverterRegistration converter) {
        this.m_converterRegistry = converter;
    }

    public boolean useInlineEventBinding() {
        return this.m_useInlineEventBinding;
    }

    public void setUseInlineEventBinding(boolean useInlineEventBinding) {
        this.m_useInlineEventBinding = useInlineEventBinding;
    }

    public boolean addErrorHandling() {
        return this.m_addErrorHandling;
    }

    public void setAddErrorHandling(boolean addErrorHandling) {
        this.m_addErrorHandling = addErrorHandling;
    }

    IJsContentGenerator addContentGenerator(IJsContentGenerator generator) {
        List<IJsContentGenerator> list;
        JsComponentRegistry reg = JsRuntimeCtx.ctx().getCompRegistry();
        IJsObjectRef ref = reg.getLastRef();
        if (ref == null) {
            ref = DEFAULT_REF;
        }
        if ((list = this.getContentGenerators().get(ref)) == null) {
            list = new ArrayList<IJsContentGenerator>();
            this.getContentGenerators().put(ref, list);
        }
        list.add(generator);
        return generator;
    }

    public Map<IJsObjectRef, List<IJsContentGenerator>> getContentGenerators() {
        if (this.m_contentGenerators == null) {
            this.m_contentGenerators = new HashMap<IJsObjectRef, List<IJsContentGenerator>>(30);
        }
        return this.m_contentGenerators;
    }

    public void addErrorHandler(IErrorHandler errorHandler) {
        if (this.m_errorHandlers == null) {
            this.m_errorHandlers = new ArrayList<IErrorHandler>();
        }
        this.m_errorHandlers.add(errorHandler);
    }

    public void addErrorHandler(IErrorHandler errorHandler, int index) {
        if (this.m_errorHandlers == null) {
            this.m_errorHandlers = new ArrayList<IErrorHandler>();
        }
        this.m_errorHandlers.add(index, errorHandler);
    }

    public List<IErrorHandler> getErrorHandlers() {
        return this.m_errorHandlers;
    }

    public boolean hideJsErrors() {
        return this.m_hideJsErrors;
    }

    public void setHideJsErrors(boolean jsErrors) {
        this.m_hideJsErrors = jsErrors;
    }

    public void setRunTimeTypeCheck(boolean b) {
        this.m_runTimeTypeCheck = b;
    }

    public boolean runTimeTypeCheck() {
        return this.m_runTimeTypeCheck;
    }

    public boolean isCaptureJsErrorStackTrace() {
        return this.m_captureJsErrorStackTrace;
    }

    public void setCaptureJsErrorStackTrace(boolean mCaptureJsErrorStackTrace) {
        this.m_captureJsErrorStackTrace = mCaptureJsErrorStackTrace;
    }

    private static class CtxAssociator
    extends ContextHelper {
        private static final String CTX_NAME = JsRuntimeCtx.class.getSimpleName();

        private CtxAssociator() {
        }

        protected static JsRuntimeCtx getCtx() {
            return (JsRuntimeCtx)((Object)CtxAssociator.getSubCtx((DsfCtx)DsfCtx.ctx(), (String)CTX_NAME));
        }

        protected static void setCtx(JsRuntimeCtx ctx) {
            CtxAssociator.setSubCtx((DsfCtx)DsfCtx.ctx(), (String)CTX_NAME, (ISubCtx)ctx);
        }
    }

    private static class DefaultJSObj
    implements IJsObjectRef {
        private DefaultJSObj() {
        }

        public String getInstanceId() {
            return null;
        }

        public String getInstancePropertySetters() {
            return null;
        }

        public String getInstantiationJs() {
            return null;
        }

        public String setInstanceId(String compId) {
            return null;
        }

        public String generate() {
            return null;
        }

        public boolean isHandler() {
            return false;
        }

        public void setIsHandler(boolean value) {
        }

        public boolean isGenned() {
            return false;
        }

        public IParams getParams() {
            return null;
        }

        public String getClassName() {
            return null;
        }

        public String getVariableRef() {
            return null;
        }

        public boolean addErrorHandling() {
            return false;
        }

        public boolean isCaptureJsErrorStackTrace() {
            return false;
        }

        public String generate(boolean withRegistry) {
            return null;
        }
    }
}

