/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsruntime.jsconverters;

import java.util.List;
import org.eclipse.vjet.dsf.common.converter.BaseConverter;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;

public class StringArrayJsConverter
extends BaseConverter<String> {
    private static final List<Class> VALID_CONVERSION_TYPES;

    static {
        Class[] types = new Class[]{String[].class};
        VALID_CONVERSION_TYPES = StringArrayJsConverter.immutableTypeList((Class[])types);
    }

    public IConversionResult<String> convert(Object toBeConverted) {
        String[] preValue = (String[])toBeConverted;
        StringBuilder sb = new StringBuilder();
        sb.append("new Array(");
        int counter = 0;
        while (counter < preValue.length) {
            String avalue = preValue[counter];
            sb.append(String.valueOf('\'') + avalue.replace("'", "\\'") + '\'');
            if (counter < preValue.length - 1) {
                sb.append(",");
            }
            ++counter;
        }
        sb.append(")");
        return this.setResult(toBeConverted, sb.toString());
    }

    public Class<String> getTargetType() {
        return String.class;
    }

    public List<Class> getValidConversionTypes() {
        return VALID_CONVERSION_TYPES;
    }
}

