/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.resource.html.event.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.html.events.ISimpleJsEventHandler;
import org.eclipse.vjet.dsf.html.js.IJsContentGenerator;
import org.eclipse.vjet.dsf.html.js.IJsObjectRef;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsObjHandler;

public abstract class BaseJsHandler
implements ISimpleJsEventHandler,
IJsObjHandler {
    protected static List<String> UNMODIFIABLE_EMPTY_LIST_OF_STRING = Collections.unmodifiableList(new ArrayList(0));
    protected static final String NEW_LINE = System.getProperty("line.separator");
    private String m_handlerJsName;
    private IJsObjectRef m_jsObject;
    private String m_requestContent;
    protected List<IJsContentGenerator> m_jsContentGeners = new ArrayList<IJsContentGenerator>();

    public BaseJsHandler() {
    }

    protected BaseJsHandler(String handlerJsName) {
        if (handlerJsName == null) {
            this.chuck("Handler function name must not be null");
        }
        this.m_handlerJsName = handlerJsName;
    }

    protected BaseJsHandler(IJsObjectRef object) {
        object.setIsHandler(true);
        this.m_jsObject = object;
    }

    public String getHandlerJsName() {
        return this.m_handlerJsName;
    }

    public BaseJsHandler setJsRequestContent(String content) {
        this.m_requestContent = content;
        return this;
    }

    public String toString() {
        Z z = new Z();
        z.format("handlerJsName", (Object)this.m_handlerJsName);
        return z.toString();
    }

    protected void chuck(String message) {
        throw new DsfRuntimeException(message);
    }

    public void setJsContent(List<IJsContentGenerator> jsContent) {
        this.m_jsContentGeners = jsContent;
    }

    public BaseJsHandler addJsContent(IJsContentGenerator content) {
        this.getJsContentInternal().add(content);
        return this;
    }

    public String getJsBodyContent() {
        StringBuffer code = new StringBuffer(100);
        if (this.m_requestContent != null && !"".equals(this.m_requestContent)) {
            code.append(this.m_requestContent);
        }
        if (this.m_jsContentGeners == null || this.m_jsContentGeners.isEmpty()) {
            return code.toString();
        }
        for (IJsContentGenerator content : this.m_jsContentGeners) {
            code.append(content.generate()).append(" ");
        }
        return code.toString();
    }

    protected List<IJsContentGenerator> getJsContentInternal() {
        if (this.m_jsContentGeners == null) {
            this.m_jsContentGeners = new ArrayList<IJsContentGenerator>();
        }
        return this.m_jsContentGeners;
    }

    public IJsObjectRef getJsObject() {
        return this.m_jsObject;
    }
}

