/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.resource.html.event.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.resource.ResourceUtil;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;

public class JsImporter
extends ScriptableObject {
    private static String EVENT_HANDLER = "handle_event_";
    private static String REQUEST_HANDLER = "handle_request_";
    private static String RESPONSE_HANDLER = "handle_response_";
    private static String SERVICE_HANDLER = "handle_service_";
    private Context m_ctx = null;
    List<String> m_companionJsBlocks = new ArrayList<String>();
    Map<String, String> m_eventHandlersJs = new HashMap<String, String>();
    Map<String, String> m_requestHandlersJs = new HashMap<String, String>();
    Map<String, String> m_responseHandlersJs = new HashMap<String, String>();
    Map<String, String> m_serviceHandlersJs = new HashMap<String, String>();

    public JsImporter(Class clzForLocateResource, String jsFileName) {
        InputStream is;
        try {
            is = ResourceUtil.getResourceAsStream((Class)clzForLocateResource, (String)jsFileName);
        }
        catch (IOException e) {
            throw new DsfRuntimeException(e.getMessage());
        }
        InputStreamReader sr = new InputStreamReader(is);
        this.parse(sr);
    }

    public JsImporter(Reader jsReader) {
        this.parse(jsReader);
    }

    public JsImporter(String jsString) {
        this.parse(jsString);
    }

    public String getEventHandlerJs(String name) {
        return this.m_eventHandlersJs.get(name);
    }

    public Iterator<String> getAllEventHandlerNames() {
        return this.m_eventHandlersJs.keySet().iterator();
    }

    public String getRequestHandlerJs(String name) {
        return this.m_requestHandlersJs.get(name);
    }

    public Iterator<String> getAllRequestHandlerNames() {
        return this.m_requestHandlersJs.keySet().iterator();
    }

    public String getResponseHandlerJs(String name) {
        return this.m_responseHandlersJs.get(name);
    }

    public Iterator<String> getAllResponseHandlerNames() {
        return this.m_responseHandlersJs.keySet().iterator();
    }

    public String getServiceHandlerJs(String name) {
        return this.m_serviceHandlersJs.get(name);
    }

    public Iterator<String> getAllServiceHandlerNames() {
        return this.m_serviceHandlersJs.keySet().iterator();
    }

    public List<String> getCompanionJsBlocks() {
        return this.m_companionJsBlocks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.out(sb, this.m_eventHandlersJs, "EventHandlers");
        this.out(sb, this.m_requestHandlersJs, "RequestHandlers");
        this.out(sb, this.m_responseHandlersJs, "ResponseHandlers");
        this.out(sb, this.m_serviceHandlersJs, "ServiceHandlers");
        if (this.m_companionJsBlocks.size() > 0) {
            sb.append("Other Function Blocks:\n");
        }
        int i = 0;
        while (i < this.m_companionJsBlocks.size()) {
            sb.append(this.m_companionJsBlocks.get(i)).append("\n");
            ++i;
        }
        return sb.toString();
    }

    private void out(StringBuilder sb, Map<String, String> handlers, String title) {
        if (handlers.size() == 0) {
            return;
        }
        sb.append(title).append(":\n");
        for (Map.Entry<String, String> entry : handlers.entrySet()) {
            sb.append(entry.getKey()).append("{\n").append(entry.getValue()).append("\n").append("}\n");
        }
    }

    private void parse(String jsString) {
        this.m_ctx = Context.enter();
        this.setParentScope(this.m_ctx.initStandardObjects(null));
        this.m_ctx.evaluateString((Scriptable)this, jsString, "JsSource", 1, null);
        Context.exit();
    }

    private void parse(Reader jsReader) {
        this.m_ctx = Context.enter();
        this.m_ctx.setOptimizationLevel(0);
        this.m_ctx.setGeneratingDebug(true);
        this.setParentScope(this.m_ctx.initStandardObjects(null));
        try {
            this.m_ctx.evaluateReader((Scriptable)this, jsReader, "JsSource", 1, null);
        }
        catch (IOException e) {
            throw new DsfRuntimeException(e.getMessage(), (Throwable)e);
        }
        Context.exit();
    }

    public Object get(String name, Scriptable start) {
        Object o = super.get(name, start);
        if (o instanceof Scriptable) {
            return new ScriptableWrapper((Scriptable)o, name);
        }
        return o;
    }

    public void put(String name, Scriptable start, Object value) {
        if (value instanceof Function) {
            String functionDecl = this.m_ctx.decompileFunction((Function)value, 0);
            this.process(name, functionDecl.trim());
            value = new FunctionWrapper((Function)value, name);
        }
        super.put(name, start, value);
    }

    public String getClassName() {
        return null;
    }

    private void process(String name, String functionDecl) {
        if (name.startsWith(EVENT_HANDLER)) {
            this.getHandler(name, EVENT_HANDLER, functionDecl, this.m_eventHandlersJs);
        } else if (name.startsWith(REQUEST_HANDLER)) {
            this.getHandler(name, REQUEST_HANDLER, functionDecl, this.m_requestHandlersJs);
        } else if (name.startsWith(RESPONSE_HANDLER)) {
            this.getHandler(name, RESPONSE_HANDLER, functionDecl, this.m_responseHandlersJs);
        } else if (name.startsWith(SERVICE_HANDLER)) {
            this.getHandler(name, SERVICE_HANDLER, functionDecl, this.m_serviceHandlersJs);
        } else {
            this.m_companionJsBlocks.add(String.valueOf(functionDecl) + "\n");
        }
    }

    private void getHandler(String name, String prefix, String functionDecl, Map<String, String> handlers) {
        String handlerName = name.substring(prefix.length());
        String handlerMethod = functionDecl.substring(functionDecl.indexOf("{") + 1, functionDecl.lastIndexOf("}")).trim();
        handlers.put(handlerName, "    " + handlerMethod);
    }

    class FunctionWrapper
    implements Function {
        private final Function m_function;
        private final String m_name;

        FunctionWrapper(Function function, String name) {
            this.m_function = function;
            this.m_name = name;
        }

        public Object get(String name, Scriptable start) {
            if ("prototype".equalsIgnoreCase(name)) {
                return new ScriptableWrapper((Scriptable)this.m_function.get(name, start), String.valueOf(this.m_name) + "." + name);
            }
            return this.m_function.get(name, start);
        }

        public Scriptable getParentScope() {
            return this.m_function.getParentScope();
        }

        public void delete(int arg0) {
            this.m_function.delete(arg0);
        }

        public Object[] getIds() {
            return this.m_function.getIds();
        }

        public Object get(int arg0, Scriptable arg1) {
            return this.m_function.get(arg0, arg1);
        }

        public boolean equals(Object obj) {
            return this.m_function.equals(obj);
        }

        public boolean has(int arg0, Scriptable arg1) {
            return this.m_function.has(arg0, arg1);
        }

        public Object getDefaultValue(Class arg0) {
            return this.m_function.getDefaultValue(arg0);
        }

        public String getClassName() {
            return this.m_function.getClassName();
        }

        public void setPrototype(Scriptable arg0) {
            this.m_function.setPrototype(arg0);
        }

        public boolean has(String arg0, Scriptable arg1) {
            return this.m_function.has(arg0, arg1);
        }

        public Scriptable construct(Context arg0, Scriptable arg1, Object[] arg2) {
            return this.m_function.construct(arg0, arg1, arg2);
        }

        public Object call(Context arg0, Scriptable arg1, Scriptable arg2, Object[] arg3) {
            return this.m_function.call(arg0, arg1, arg2, arg3);
        }

        public String toString() {
            return this.m_function.toString();
        }

        public int hashCode() {
            return this.m_function.hashCode();
        }

        public void put(int arg0, Scriptable arg1, Object arg2) {
            this.m_function.put(arg0, arg1, arg2);
        }

        public void delete(String arg0) {
            this.m_function.delete(arg0);
        }

        public void put(String arg0, Scriptable arg1, Object arg2) {
            this.m_function.put(arg0, arg1, arg2);
        }

        public Scriptable getPrototype() {
            return this.m_function.getPrototype();
        }

        public boolean hasInstance(Scriptable arg0) {
            return this.m_function.hasInstance(arg0);
        }

        public void setParentScope(Scriptable arg0) {
            this.m_function.setParentScope(arg0);
        }
    }

    class ScriptableWrapper
    implements Scriptable {
        private final Scriptable m_scriptable;
        private final String m_name;

        ScriptableWrapper(Scriptable scriptable, String name) {
            this.m_scriptable = scriptable;
            this.m_name = name;
        }

        public Object get(String name, Scriptable start) {
            Object o = this.m_scriptable.get(name, start);
            if (o instanceof Scriptable) {
                name = String.valueOf(this.m_name) + "." + name;
                return new ScriptableWrapper((Scriptable)o, name);
            }
            return o;
        }

        public Scriptable getParentScope() {
            return this.m_scriptable.getParentScope();
        }

        public void delete(int arg0) {
            this.m_scriptable.delete(arg0);
        }

        public Object[] getIds() {
            return this.m_scriptable.getIds();
        }

        public Object get(int arg0, Scriptable arg1) {
            return this.m_scriptable.get(arg0, arg1);
        }

        public boolean equals(Object obj) {
            return this.m_scriptable.equals(obj);
        }

        public boolean has(int arg0, Scriptable arg1) {
            return this.m_scriptable.has(arg0, arg1);
        }

        public Object getDefaultValue(Class arg0) {
            return this.m_scriptable.getDefaultValue(arg0);
        }

        public String getClassName() {
            return this.m_scriptable.getClassName();
        }

        public void setPrototype(Scriptable arg0) {
            this.m_scriptable.setPrototype(arg0);
        }

        public boolean has(String arg0, Scriptable arg1) {
            return this.m_scriptable.has(arg0, arg1);
        }

        public String toString() {
            return this.m_scriptable.toString();
        }

        public int hashCode() {
            return this.m_scriptable.hashCode();
        }

        public void put(int arg0, Scriptable arg1, Object arg2) {
            this.m_scriptable.put(arg0, arg1, arg2);
        }

        public void delete(String arg0) {
            this.m_scriptable.delete(arg0);
        }

        public void put(String name, Scriptable start, Object value) {
            if (value instanceof Function) {
                String functionDecl = String.valueOf(this.m_name) + "." + name + " = " + JsImporter.this.m_ctx.decompileFunction((Function)value, 0).trim();
                JsImporter.this.m_companionJsBlocks.add(String.valueOf(functionDecl) + "\n");
            } else {
                this.m_scriptable.put(name, start, value);
            }
        }

        public Scriptable getPrototype() {
            return this.m_scriptable.getPrototype();
        }

        public boolean hasInstance(Scriptable arg0) {
            return this.m_scriptable.hasInstance(arg0);
        }

        public void setParentScope(Scriptable arg0) {
            this.m_scriptable.setParentScope(arg0);
        }
    }
}

