/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.resource.js.trace;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.resource.pattern.IResourceRef;
import org.eclipse.vjet.dsf.resource.trace.IResourceUsageTracer;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceDispenser;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResource;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResourceRef;

public class SimpleResourceUsageTracer
implements IResourceUsageTracer {
    Map<JsResource, Set<Class<? extends IJsResourceDispenser>>> m_jsMap = new LinkedHashMap<JsResource, Set<Class<? extends IJsResourceDispenser>>>();

    public void accessed(IResourceRef resource) {
        if (resource instanceof JsResourceRef) {
            JsResourceRef ref = (JsResourceRef)resource;
            this.getDispensers(ref.getResource(), true).add(ref.getDispenser());
        }
    }

    public Collection<JsResource> getJsList() {
        return this.m_jsMap.keySet();
    }

    public Set<Class<? extends IJsResourceDispenser>> getDispensers(JsResource resource) {
        return this.getDispensers(resource, false);
    }

    private Set<Class<? extends IJsResourceDispenser>> getDispensers(JsResource resource, boolean create) {
        Set<Class<? extends IJsResourceDispenser>> set = this.m_jsMap.get((Object)resource);
        if (set == null && create) {
            set = new HashSet<Class<? extends IJsResourceDispenser>>();
            this.m_jsMap.put(resource, set);
        }
        return set;
    }
}

