/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.resource.pattern.js;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.resource.x.IResourceAggregationModeResolver;
import org.eclipse.vjet.vsf.resource.pattern.js.CommonJsResourceAggregationModeResolver;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResourceRef;
import org.eclipse.vjet.vsf.resource.pattern.js.resolution.DefaultJsJavaResourceResolver;
import org.eclipse.vjet.vsf.resource.pattern.js.resolution.IJsResourceResolver;

public class JsResRtCfg {
    private static JsResRtCfg s_instance = new JsResRtCfg();
    private Map<String, IJsResourceResolver> m_resolvers = new HashMap<String, IJsResourceResolver>();
    private IJsResourceResolver m_defaultJsResourceResolver = DefaultJsJavaResourceResolver.getInstance();
    private JsResourceRef.IJsInstrumentResourceHandle m_jsInstrumentResourceHandle;
    private IResourceAggregationModeResolver m_aggregationModeResolver;
    private boolean m_buildRepoAggregation = true;
    private boolean m_disableAssetExtraction = false;
    private Set<String> m_jsSystemLibCachedResourceUrns;

    private JsResRtCfg() {
    }

    public static JsResRtCfg getInstance() {
        return s_instance;
    }

    public IJsResourceResolver getJsResourceResolver(String resourceGroupId) {
        IJsResourceResolver resolver = this.m_resolvers.get(resourceGroupId);
        if (resolver != null) {
            return resolver;
        }
        return this.m_defaultJsResourceResolver;
    }

    public void setJsSystemLibCachedResourceUrns(Set<String> jsSystemLibCachedResourceUrns) {
        this.m_jsSystemLibCachedResourceUrns = jsSystemLibCachedResourceUrns;
    }

    public Set<String> getJsSystemLibCachedResourceUrns() {
        return this.m_jsSystemLibCachedResourceUrns;
    }

    public void setJsResourceResolver(String resourceGroupId, IJsResourceResolver resolver) {
        this.m_resolvers.put(resourceGroupId, resolver);
    }

    public void setDefaultJsResourceResolver(IJsResourceResolver resolver) {
        this.m_defaultJsResourceResolver = resolver;
    }

    public JsResourceRef.IJsInstrumentResourceHandle getJsInstrumentResourceHandle() {
        return this.m_jsInstrumentResourceHandle;
    }

    public void setJsInstrumentResourceHandle(JsResourceRef.IJsInstrumentResourceHandle jsInstrumentResourceHandle) {
        this.m_jsInstrumentResourceHandle = jsInstrumentResourceHandle;
    }

    public void setAggregationModeResolver(IResourceAggregationModeResolver resolver) {
        this.m_aggregationModeResolver = resolver;
    }

    public IResourceAggregationModeResolver getAggregationModeResolver() {
        if (this.m_aggregationModeResolver != null) {
            return this.m_aggregationModeResolver;
        }
        return CommonJsResourceAggregationModeResolver.getInstance();
    }

    public IResourceAggregationModeResolver.AggregationMode getAggregationMode() {
        return JsResRtCfg.getInstance().getAggregationModeResolver().getAggregationMode();
    }

    public void setEnableBuildRepoAggregation(boolean enable) {
        this.m_buildRepoAggregation = enable;
    }

    public boolean isBuildRepoAggregationEnabled() {
        return this.m_buildRepoAggregation;
    }

    public void setDisableAssetExtraction(boolean disable) {
        this.m_disableAssetExtraction = disable;
    }

    public boolean isAssetExtranctionDisabled() {
        return this.m_disableAssetExtraction;
    }
}

