/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.serializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.vjet.dsf.serializer.VjoSerializedResult;

public class VjoListSerializedResult
extends VjoSerializedResult {
    private List<Object> m_vjoList;
    private String m_vjoListUtil = "org.eclipse.vjet.vjo.java.util.ArrayListUtil.create";

    public List<Object> getVjoList() {
        if (this.m_vjoList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_vjoList);
    }

    public VjoListSerializedResult addVjoObject(Object vjoObject) {
        if (this.m_vjoList == null) {
            this.m_vjoList = new ArrayList<Object>();
        }
        this.m_vjoList.add(vjoObject);
        return this;
    }

    public String getVjoListUtil() {
        return this.m_vjoListUtil;
    }

    public VjoListSerializedResult setVjoListUtil(String listUtil) {
        this.m_vjoListUtil = listUtil;
        return this;
    }

    @Override
    protected StringBuilder toBeginJson(StringBuilder sb) {
        sb.append(this.getVjoListUtil());
        sb.append('(');
        return sb;
    }

    @Override
    protected StringBuilder toJsonData(StringBuilder sb) {
        sb.append('[');
        Iterator<Object> it = this.getVjoList().iterator();
        while (it.hasNext()) {
            VjoListSerializedResult.appendValue((Object)it.next(), (StringBuilder)sb);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb;
    }
}

