/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.serializer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.vjet.dsf.serializer.VjoSerializedResult;

public class VjoMapSerializedResult
extends VjoSerializedResult {
    private Map<Object, Object> m_vjoMap;
    private String m_vjoMapUtil = "org.eclipse.vjet.vjo.java.util.HashMapUtil.create";

    public Map<Object, Object> getVjoMap() {
        if (this.m_vjoMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.m_vjoMap);
    }

    public VjoMapSerializedResult putVjoObject(Object key, Object value) {
        if (this.m_vjoMap == null) {
            this.m_vjoMap = new HashMap<Object, Object>();
        }
        this.m_vjoMap.put(key, value);
        return this;
    }

    public String getVjoMapUtil() {
        return this.m_vjoMapUtil;
    }

    public VjoMapSerializedResult setVjoMapUtil(String mapUtil) {
        this.m_vjoMapUtil = mapUtil;
        return this;
    }

    @Override
    protected StringBuilder toBeginJson(StringBuilder sb) {
        sb.append(this.getVjoMapUtil());
        sb.append('(');
        return sb;
    }

    @Override
    protected StringBuilder toJsonData(StringBuilder sb) {
        sb.append('[');
        Iterator<Map.Entry<Object, Object>> it = this.getVjoMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            sb.append("{'K':");
            VjoMapSerializedResult.appendValue((Object)entry.getKey(), (StringBuilder)sb);
            sb.append(",'V':");
            VjoMapSerializedResult.appendValue((Object)entry.getValue(), (StringBuilder)sb);
            sb.append('}');
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb;
    }
}

