/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.BaseTableSection;
import org.eclipse.vjet.dsf.html.dom.CollectionIndex;
import org.eclipse.vjet.dsf.html.dom.DA;
import org.eclipse.vjet.dsf.html.dom.DArea;
import org.eclipse.vjet.dsf.html.dom.DForm;
import org.eclipse.vjet.dsf.html.dom.DImg;
import org.eclipse.vjet.dsf.html.dom.DOption;
import org.eclipse.vjet.dsf.html.dom.DTBody;
import org.eclipse.vjet.dsf.html.dom.DTr;
import org.eclipse.vjet.dsf.html.dom.IDFormControl;
import org.w3c.dom.Node;

public class DHtmlCollection {
    static final short ANCHOR = 1;
    static final short FORM = 2;
    static final short IMAGE = 3;
    static final short APPLET = 4;
    static final short LINK = 5;
    static final short OPTION = 6;
    static final short ROW = 7;
    static final short ELEMENT = 8;
    static final short AREA = -1;
    static final short TBODY = -2;
    static final short CELL = -3;
    private short _lookingFor;
    private DElement _topLevel;

    DHtmlCollection(BaseHtmlElement topLevel, short lookingFor) {
        if (topLevel == null) {
            throw new NullPointerException("HTM011 Argument 'topLevel' is null.");
        }
        this._topLevel = topLevel;
        this._lookingFor = lookingFor;
    }

    public final int getLength() {
        return this.getLength(this._topLevel);
    }

    public final Node item(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("HTM012 Argument 'index' is negative.");
        }
        return this.item(this._topLevel, new CollectionIndex(index));
    }

    public final Node namedItem(String name) {
        if (name == null) {
            throw new NullPointerException("HTM013 Argument 'name' is null.");
        }
        return this.namedItem(this._topLevel, name);
    }

    private int getLength(DElement topLevel) {
        int length = 0;
        Node node = topLevel.getFirstChild();
        while (node != null) {
            if (node instanceof DElement) {
                if (this.collectionMatch((DElement)node, null)) {
                    ++length;
                } else if (this.recurse()) {
                    length += this.getLength((DElement)node);
                }
            }
            node = node.getNextSibling();
        }
        return length;
    }

    private Node item(DElement topLevel, CollectionIndex index) {
        Node node = topLevel.getFirstChild();
        while (node != null) {
            if (node instanceof DElement) {
                Node result;
                if (this.collectionMatch((DElement)node, null)) {
                    if (index.isZero()) {
                        return node;
                    }
                    index.decrement();
                } else if (this.recurse() && (result = this.item((DElement)node, index)) != null) {
                    return result;
                }
            }
            node = node.getNextSibling();
        }
        return null;
    }

    private Node namedItem(DElement topLevel, String name) {
        Node node = topLevel.getFirstChild();
        while (node != null) {
            if (node instanceof DElement) {
                Node result;
                if (this.collectionMatch((DElement)node, name)) {
                    return node;
                }
                if (this.recurse() && (result = this.namedItem((DElement)node, name)) != null) {
                    return result;
                }
            }
            node = node.getNextSibling();
        }
        return node;
    }

    protected boolean recurse() {
        return this._lookingFor > 0;
    }

    protected boolean collectionMatch(DElement elem, String name) {
        boolean match = false;
        switch (this._lookingFor) {
            case 1: {
                match = elem instanceof DA && elem.getAttribute("name").length() > 0;
                break;
            }
            case 2: {
                match = elem instanceof DForm;
                break;
            }
            case 3: {
                match = elem instanceof DImg;
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                match = elem instanceof IDFormControl;
                break;
            }
            case 5: {
                match = (elem instanceof DA || elem instanceof DArea) && elem.getAttribute("href").length() > 0;
                break;
            }
            case -1: {
                match = elem instanceof DArea;
                break;
            }
            case 6: {
                match = elem instanceof DOption;
                break;
            }
            case 7: {
                match = elem instanceof DTr;
                break;
            }
            case -2: {
                match = elem instanceof DTBody;
                break;
            }
            case -3: {
                match = elem instanceof BaseTableSection;
            }
        }
        if (match && name != null) {
            if (elem instanceof DA && name.equals(elem.getAttribute("name"))) {
                return true;
            }
            match = name.equals(elem.getAttribute("id"));
        }
        return match;
    }
}

