/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.common.naming.DsfInvalidNameException;
import org.eclipse.vjet.dsf.common.node.IDNodeRelationshipVerifier;
import org.eclipse.vjet.dsf.common.node.IFacetsMap;
import org.eclipse.vjet.dsf.common.node.IllegalDNodeRelationshipException;
import org.eclipse.vjet.dsf.dom.DNode;

class FacetsMap
extends LinkedHashMap<String, DNode>
implements IFacetsMap {
    private static final long serialVersionUID = -3003881245238347508L;
    final DNode m_owner;

    public FacetsMap(DNode owner, int initialSize) {
        super(initialSize);
        this.m_owner = owner;
    }

    @Override
    public void clear() {
        Iterator<String> keys = this.keySet().iterator();
        while (keys.hasNext()) {
            keys.next();
            keys.remove();
        }
        super.clear();
    }

    @Override
    public Set<Map.Entry<String, DNode>> entrySet() {
        return new FacetsMapEntrySet(this);
    }

    @Override
    public Set<String> keySet() {
        return new FacetsMapKeySet(this);
    }

    protected static void assertParentFacetRelationship(DNode parent, String facetName, DNode facet) {
        IDNodeRelationshipVerifier.Status status = parent.getDsfRelationshipVerifier().acceptableAsFacet(parent, facetName, facet);
        FacetsMap.assertRelationship(status);
        status = facet.getDsfRelationshipVerifier().acceptableAsParent(facet, parent);
        FacetsMap.assertRelationship(status);
    }

    protected static void assertRelationship(IDNodeRelationshipVerifier.Status status) {
        if (!status.isOk()) {
            throw new IllegalDNodeRelationshipException(status.getErrorMessage());
        }
    }

    @Override
    public DNode put(String key, DNode value) {
        boolean sameParent;
        if (key == null) {
            throw new NullPointerException("Facet key must be a non-null String value");
        }
        if (value == null) {
            throw new NullPointerException("Facet value must be a non-null DNode type");
        }
        if (this.m_owner.hasDsfChildWithLocalName(key)) {
            throw new DsfInvalidNameException("there is a child node with name '" + key + "'");
        }
        FacetsMap.assertParentFacetRelationship(this.m_owner, key, value);
        DNode oldParent = value.getDsfParentNode();
        boolean bl = sameParent = oldParent == this.m_owner;
        if (!sameParent) {
            value.setParent(this.m_owner);
        }
        try {
            if (!super.containsKey(key)) {
                value.getDsfName().setLocalName(key);
            }
        }
        catch (DsfInvalidNameException e) {
            if (!sameParent) {
                value.setParent(oldParent);
            }
            throw e;
        }
        DNode previous = (DNode)this.get(key);
        if (previous != null && previous != value) {
            previous.setParent(null);
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends DNode> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        for (String string : map.keySet()) {
            this.put(string, map.get(string));
        }
    }

    @Override
    public DNode remove(Object key) {
        DNode previous = (DNode)this.get(key);
        if (previous != null) {
            previous.setParent(null);
        }
        super.remove(key);
        return previous;
    }

    @Override
    public Collection<DNode> values() {
        return new FacetsMapValues(this);
    }

    @Override
    public Iterator<DNode> iterator() {
        return this.values().iterator();
    }

    Iterator<String> keySetIterator() {
        return new ArrayList(super.keySet()).iterator();
    }

    private class FacetsMapEntrySet
    extends AbstractSet<Map.Entry<String, DNode>> {
        private FacetsMap m_map = null;

        public FacetsMapEntrySet(FacetsMap map) {
            this.m_map = map;
        }

        @Override
        public boolean add(Map.Entry<String, DNode> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.m_map.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if (!this.m_map.containsKey(k)) {
                return false;
            }
            if (v == null) {
                return this.m_map.get(k) == null;
            }
            return v.equals(this.m_map.get(k));
        }

        @Override
        public boolean isEmpty() {
            return this.m_map.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, DNode>> iterator() {
            return new FacetsMapEntrySetIterator(this.m_map);
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)o).getKey();
            if (this.m_map.containsKey(k)) {
                this.m_map.remove(k);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            boolean result = false;
            Iterator v = c.iterator();
            while (v.hasNext()) {
                if (!this.remove(v.next())) continue;
                result = true;
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator<Map.Entry<String, DNode>> v = this.iterator();
            while (v.hasNext()) {
                if (c.contains(v.next())) continue;
                v.remove();
                result = true;
            }
            return result;
        }

        @Override
        public int size() {
            return this.m_map.size();
        }
    }

    private class FacetsMapEntrySetEntry
    implements Map.Entry<String, DNode> {
        private FacetsMap m_map;
        private String m_key;

        public FacetsMapEntrySetEntry(FacetsMap map, String key) {
            this.m_map = map;
            this.m_key = key;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (this.m_key == null ? e.getKey() != null : !this.m_key.equals(e.getKey())) {
                return false;
            }
            Object v = this.m_map.get(this.m_key);
            return !(v == null ? e.getValue() != null : !v.equals(e.getValue()));
        }

        @Override
        public String getKey() {
            return this.m_key;
        }

        @Override
        public DNode getValue() {
            return (DNode)this.m_map.get(this.m_key);
        }

        @Override
        public int hashCode() {
            Object value = this.m_map.get(this.m_key);
            return (this.m_key == null ? 0 : this.m_key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        @Override
        public DNode setValue(DNode value) {
            DNode previous = (DNode)this.m_map.get(this.m_key);
            this.m_map.put(this.m_key, value);
            return previous;
        }
    }

    private class FacetsMapEntrySetIterator
    implements Iterator<Map.Entry<String, DNode>> {
        private FacetsMap m_map = null;
        private Iterator<String> m_iterator = null;
        private Map.Entry<String, DNode> m_last = null;

        public FacetsMapEntrySetIterator(FacetsMap map) {
            this.m_map = map;
            this.m_iterator = map.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        @Override
        public Map.Entry<String, DNode> next() {
            this.m_last = new FacetsMapEntrySetEntry(this.m_map, this.m_iterator.next());
            return this.m_last;
        }

        @Override
        public void remove() {
            if (this.m_last == null) {
                throw new IllegalStateException();
            }
            this.m_map.remove(this.m_last.getKey());
            this.m_last = null;
        }
    }

    private class FacetsMapKeySet
    extends AbstractSet<String> {
        private FacetsMap m_map = null;

        public FacetsMapKeySet(FacetsMap map) {
            this.m_map = map;
        }

        @Override
        public boolean add(String o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.m_map.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.m_map.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            Iterator v = c.iterator();
            while (v.hasNext()) {
                if (this.m_map.containsKey(v.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.m_map.size() == 0;
        }

        @Override
        public Iterator<String> iterator() {
            return new FacetsMapKeySetIterator(this.m_map);
        }

        @Override
        public boolean remove(Object o) {
            if (this.m_map.containsKey(o)) {
                this.m_map.remove(o);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            boolean result = false;
            for (Object o : c) {
                if (!this.m_map.containsKey(o)) continue;
                this.m_map.remove(o);
                result = true;
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator<String> v = this.iterator();
            while (v.hasNext()) {
                if (c.contains(v.next())) continue;
                v.remove();
                result = true;
            }
            return result;
        }

        @Override
        public int size() {
            return this.m_map.size();
        }
    }

    private class FacetsMapKeySetIterator
    implements Iterator<String> {
        private FacetsMap m_map = null;
        private Iterator<String> m_iterator = null;
        private String m_last = null;

        public FacetsMapKeySetIterator(FacetsMap map) {
            this.m_map = map;
            this.m_iterator = map.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        @Override
        public String next() {
            this.m_last = this.m_iterator.next();
            return this.m_last;
        }

        @Override
        public void remove() {
            if (this.m_last == null) {
                throw new IllegalStateException();
            }
            this.m_map.remove(this.m_last);
            this.m_last = null;
        }
    }

    private class FacetsMapValues
    extends AbstractCollection<DNode> {
        private FacetsMap m_map;

        public FacetsMapValues(FacetsMap map) {
            this.m_map = map;
        }

        @Override
        public boolean add(DNode o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.m_map.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.m_map.size() == 0;
        }

        @Override
        public Iterator<DNode> iterator() {
            return new FacetsMapValuesIterator(this.m_map);
        }

        @Override
        public int size() {
            return this.m_map.size();
        }
    }

    private class FacetsMapValuesIterator
    implements Iterator<DNode> {
        private FacetsMap m_map = null;
        private Iterator m_iterator = null;
        private Object m_last = null;

        public FacetsMapValuesIterator(FacetsMap map) {
            this.m_map = map;
            this.m_iterator = map.keySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        @Override
        public DNode next() {
            this.m_last = this.m_iterator.next();
            return (DNode)this.m_map.get(this.m_last);
        }

        @Override
        public void remove() {
            if (this.m_last == null) {
                throw new IllegalStateException();
            }
            this.m_map.remove(this.m_last);
            this.m_last = null;
        }
    }
}

