/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.adapters.java;

import java.util.List;
import java.util.ListIterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.SimpleTestProject;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.BasicMapping;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.FetchTypeDefaultEager;
import org.eclipse.dali.orm.NullTypeMapping;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.java.Attribute;
import org.eclipse.dali.orm.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.JavaBasicMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentTypeModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;

public class JavaBasicMappingModelAdapterTests
extends TestCase {
    private SimpleTestProject project;
    private PersistentType testClassType;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.adapters.java.JavaBasicMappingModelAdapterTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JavaBasicMappingModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new SimpleTestProject();
        this.project.setPersistenceNature();
        PersistenceFile persistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)this.project.getTestClassType().getCompilationUnit().getResource()));
        this.testClassType = (PersistentType)persistenceFile.getPersistentTypes().get(0);
        this.testClassType.setTypeMappingKey((TypeMapping.Key)Entity.Key.INSTANCE);
    }

    protected void tearDown() throws Exception {
        this.testClassType.setTypeMappingKey((TypeMapping.Key)NullTypeMapping.Key.INSTANCE);
        this.testClassType = null;
        this.project.dispose();
        super.tearDown();
    }

    public void testFetchTypeSourceUpdateFromPersistenceModelChanges() throws JavaModelException {
        PersistentAttribute persAttribute = (PersistentAttribute)this.testClassType.getPersistentAttributes().get(1);
        Attribute attribute = (Attribute)ClassTools.getFieldValue((Object)persAttribute.getModelAdapter(), (String)"attribute");
        BasicMapping basicMapping = (BasicMapping)persAttribute.getAttributeMapping();
        basicMapping.setFetchType(FetchTypeDefaultEager.EAGER_LITERAL);
        JavaPersistentAttributeModelAdapter mappingModelAdapter = (JavaPersistentAttributeModelAdapter)persAttribute.getModelAdapter();
        CompilationUnit astRoot = attribute.createASTRoot();
        JavaBasicMappingModelAdapterTests.assertTrue((boolean)attribute.containsAnnotationElement("Basic", "fetch", astRoot));
        NormalAnnotation annotation = (NormalAnnotation)mappingModelAdapter.getAnnotation("Basic", astRoot);
        MemberValuePair valuePair = (MemberValuePair)annotation.values().get(0);
        QualifiedName qualifiedName = (QualifiedName)valuePair.getValue();
        JavaBasicMappingModelAdapterTests.assertTrue((boolean)qualifiedName.getFullyQualifiedName().equals("FetchType.EAGER"));
        JavaBasicMappingModelAdapterTests.assertTrue((String)"javax.persistence.FetchType import was not added", (boolean)attribute.getJDTMember().getCompilationUnit().getImport("javax.persistence.FetchType").exists());
        basicMapping.setFetchType(FetchTypeDefaultEager.LAZY_LITERAL);
        astRoot = attribute.createASTRoot();
        JavaBasicMappingModelAdapterTests.assertTrue((boolean)attribute.containsAnnotationElement("Basic", "fetch", astRoot));
        annotation = (NormalAnnotation)mappingModelAdapter.getAnnotation("Basic", astRoot);
        valuePair = (MemberValuePair)annotation.values().get(0);
        qualifiedName = (QualifiedName)valuePair.getValue();
        JavaBasicMappingModelAdapterTests.assertTrue((boolean)qualifiedName.getFullyQualifiedName().equals("FetchType.LAZY"));
        basicMapping.setFetchType(FetchTypeDefaultEager.DEFAULT_LITERAL);
        astRoot = attribute.createASTRoot();
        JavaBasicMappingModelAdapterTests.assertFalse((boolean)attribute.containsAnnotationElement("Basic", "fetch", astRoot));
    }

    public void testFetchTypePersistenceModelUpdatesSourceChanges() {
        PersistentAttribute persAttribute = (PersistentAttribute)this.testClassType.getPersistentAttributes().get(1);
        Attribute attribute = (Attribute)ClassTools.getFieldValue((Object)persAttribute.getModelAdapter(), (String)"attribute");
        BasicMapping basicMapping = (BasicMapping)persAttribute.getAttributeMapping();
        JavaBasicMappingModelAdapter mappingModelAdapter = (JavaBasicMappingModelAdapter)basicMapping.getModelAdapter();
        EnumAnnotationElementAdapter enumAdapter = (EnumAnnotationElementAdapter)ClassTools.getFieldValue((Object)mappingModelAdapter, (String)"fetchTypeAdapter");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)enumAdapter, (String)"setJavaValue", (Class)clazz, (Object)"EAGER");
        basicMapping = (BasicMapping)persAttribute.getAttributeMapping();
        JavaBasicMappingModelAdapterTests.assertEquals((Object)FetchTypeDefaultEager.EAGER_LITERAL, (Object)basicMapping.getFetchType());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)enumAdapter, (String)"setJavaValue", (Class)clazz2, (Object)"LAZY");
        JavaBasicMappingModelAdapterTests.assertEquals((Object)FetchTypeDefaultEager.LAZY_LITERAL, (Object)basicMapping.getFetchType());
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)enumAdapter, (String)"setJavaValue", (Class)clazz3, (Object)"LAZ");
        JavaBasicMappingModelAdapterTests.assertEquals((Object)FetchTypeDefaultEager.LAZY_LITERAL, (Object)basicMapping.getFetchType());
        this.setFetchTypeInvalid("Basic", attribute.getJDTMember());
        JavaBasicMappingModelAdapterTests.assertEquals((Object)FetchTypeDefaultEager.LAZY_LITERAL, (Object)basicMapping.getFetchType());
        attribute.removeAnnotationElement("Basic", "fetch");
        JavaBasicMappingModelAdapterTests.assertEquals((Object)FetchTypeDefaultEager.DEFAULT_LITERAL, (Object)basicMapping.getFetchType());
    }

    private void setFetchTypeInvalid(final String mappingAnnotation, IMember member) {
        PersistentAttribute mapping = JavaPersistentTypeModelAdapter.persistentAttributeFor((PersistentType)this.testClassType, (IMember)member);
        JavaPersistentAttributeModelAdapter mappingModelAdapter = (JavaPersistentAttributeModelAdapter)mapping.getModelAdapter();
        Attribute attribute = mappingModelAdapter.getAttribute();
        attribute.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation annotation = ASTTools.annotation((BodyDeclaration)bodyDeclaration, (String)mappingAnnotation);
                AST ast = bodyDeclaration.getAST();
                List values = ((NormalAnnotation)annotation).values();
                ListIterator i = values.listIterator();
                while (i.hasNext()) {
                    MemberValuePair valuePair = (MemberValuePair)i.next();
                    if (!valuePair.getName().getFullyQualifiedName().equals("fetch")) continue;
                    valuePair.setValue((Expression)ast.newName("FetchType"));
                }
            }
        });
    }
}

