/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.projects;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dali.core.tests.projects.TestDaliProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class MappedSuperclassTestProject
extends TestDaliProject {
    public static String PROJECT_NAME = "MappedSuperclassTestProject";
    public static String PACKAGE_NAME = "test";
    public static String EMPLOYEE_TYPE_NAME = "Employee";
    public static String EMPLOYEE_FILE_NAME = "Employee.java";
    public static String ABSTRACT_EMPLOYEE_TYPE_NAME = "AbstractEmployee";
    public static String ABSTRACT_EMPLOYEE_FILE_NAME = "AbstractEmployee.java";

    public MappedSuperclassTestProject() throws CoreException {
        super(PROJECT_NAME, false);
        IPackageFragment packageFragment = this.createPackage(PACKAGE_NAME);
        this.createType(packageFragment, EMPLOYEE_FILE_NAME, this.createEmployeeTypeSource());
        this.createType(packageFragment, ABSTRACT_EMPLOYEE_FILE_NAME, this.createAbstractEmployeeTypeSource());
    }

    public String getFullyQualifiedEmployeeClassName() {
        return String.valueOf(PACKAGE_NAME) + "." + EMPLOYEE_TYPE_NAME;
    }

    public IType getEmployeeType() throws JavaModelException {
        return this.getJavaProject().findType(this.getFullyQualifiedEmployeeClassName());
    }

    private String createEmployeeTypeSource() {
        StringBuffer sb = new StringBuffer();
        sb.append("import javax.persistence.Id;\n");
        sb.append("import javax.persistence.Entity;\n");
        sb.append("\n");
        sb.append("@Entity\n");
        sb.append("public class " + EMPLOYEE_TYPE_NAME + " extends " + ABSTRACT_EMPLOYEE_TYPE_NAME + "{\n");
        sb.append("}");
        return sb.toString();
    }

    private String createAbstractEmployeeTypeSource() {
        StringBuffer sb = new StringBuffer();
        sb.append("import javax.persistence.Id;\n");
        sb.append("import javax.persistence.MappedSuperclass;\n");
        sb.append("\n");
        sb.append("@MappedSuperclass \n");
        sb.append("public abstract class " + ABSTRACT_EMPLOYEE_TYPE_NAME + "{\n");
        sb.append("    @Id\n");
        sb.append("    private int id;\n");
        sb.append("    \n");
        sb.append("    private String name;\n");
        sb.append("    \n");
        sb.append("    @OneToOne\n");
        sb.append("    private Employee manager;\n");
        sb.append("    \n");
        sb.append("    public int getId() {\n");
        sb.append("        return this.id;\n");
        sb.append("    }\n");
        sb.append("    \n");
        sb.append("    public void setId(int id) {\n");
        sb.append("        this.id = id;\n");
        sb.append("    }\n");
        sb.append("    \n");
        sb.append("    public String getName() {\n");
        sb.append("        return this.name;\n");
        sb.append("    }\n");
        sb.append("    \n");
        sb.append("    public void setName(String name) {\n");
        sb.append("        this.name = name;\n");
        sb.append("    }\n");
        sb.append("}");
        return sb.toString();
    }
}

