/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.Bag;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.HashBag;
import org.eclipse.dali.utility.tests.TestTools;

public class HashBagTests
extends TestCase {
    private HashBag bag;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.HashBagTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.HashBagTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public HashBagTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.bag = this.buildBag();
    }

    private HashBag buildBag() {
        HashBag b = new HashBag();
        b.add(null);
        b.add((Object)new String("one"));
        b.add((Object)new String("two"));
        b.add((Object)new String("two"));
        b.add((Object)new String("three"));
        b.add((Object)new String("three"));
        b.add((Object)new String("three"));
        b.add((Object)new String("four"));
        b.add((Object)new String("four"));
        b.add((Object)new String("four"));
        b.add((Object)new String("four"));
        return b;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    private Collection buildCollection() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(new String("foo"));
        c.add(new String("foo"));
        c.add(new String("bar"));
        c.add(new String("bar"));
        c.add(new String("bar"));
        return c;
    }

    public void testCtorCollection() {
        Collection c = this.buildCollection();
        HashBag b = new HashBag(c);
        Iterator stream = c.iterator();
        while (stream.hasNext()) {
            HashBagTests.assertTrue((String)"missing element", (boolean)b.contains(stream.next()));
        }
    }

    public void testCtorIntFloat() {
        boolean exCaught = false;
        try {
            this.bag = new HashBag(-20, 0.66f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((String)"IllegalArgumentException not thrown", (boolean)exCaught);
        exCaught = false;
        try {
            this.bag = new HashBag(20, -0.66f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((String)"IllegalArgumentException not thrown", (boolean)exCaught);
    }

    public void testAdd() {
        HashBagTests.assertTrue((String)"incorrect return value", (boolean)this.bag.add((Object)"five"));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)"two"));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)"three"));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)"four"));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)"five"));
    }

    public void testAddAll() {
        Collection c = this.buildCollection();
        HashBagTests.assertTrue((String)"incorrect return value", (boolean)this.bag.addAll(c));
        Iterator stream = c.iterator();
        while (stream.hasNext()) {
            HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains(stream.next()));
        }
    }

    public void testClear() {
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)"two"));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)"three"));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)"four"));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains(null));
        HashBagTests.assertEquals((String)"invalid size", (int)11, (int)this.bag.size());
        this.bag.clear();
        HashBagTests.assertFalse((String)"malingering element", (boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertFalse((String)"malingering element", (boolean)this.bag.contains((Object)"two"));
        HashBagTests.assertFalse((String)"malingering element", (boolean)this.bag.contains((Object)"three"));
        HashBagTests.assertFalse((String)"malingering element", (boolean)this.bag.contains((Object)"four"));
        HashBagTests.assertFalse((String)"malingering element", (boolean)this.bag.contains(null));
        HashBagTests.assertEquals((String)"invalid size", (int)0, (int)this.bag.size());
    }

    public void testClone() {
        Bag bag2 = (Bag)this.bag.clone();
        HashBagTests.assertTrue((String)"bad clone", (this.bag != bag2 ? 1 : 0) != 0);
        HashBagTests.assertEquals((String)"bad clone", (Object)this.bag, (Object)bag2);
        HashBagTests.assertTrue((String)"bad clone", (this.bag.hashCode() == bag2.hashCode() ? 1 : 0) != 0);
    }

    public void testContains() {
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains(null));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)"two"));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)"three"));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)"four"));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)new String("four")));
        HashBagTests.assertTrue((String)"missing element", (boolean)this.bag.contains((Object)"four"));
        HashBagTests.assertFalse((String)"element found", (boolean)this.bag.contains((Object)"five"));
    }

    public void testContainsAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(null);
        c.add(new String("one"));
        c.add(new String("two"));
        c.add(new String("three"));
        c.add(new String("four"));
        HashBagTests.assertTrue((String)"missing element(s)", (boolean)this.bag.containsAll(c));
    }

    public void testCount() {
        HashBagTests.assertEquals((String)"bad count", (int)0, (int)this.bag.count((Object)"zero"));
        HashBagTests.assertEquals((String)"bad count", (int)1, (int)this.bag.count((Object)"one"));
        HashBagTests.assertEquals((String)"bad count", (int)2, (int)this.bag.count((Object)"two"));
        HashBagTests.assertEquals((String)"bad count", (int)3, (int)this.bag.count((Object)"three"));
        HashBagTests.assertEquals((String)"bad count", (int)4, (int)this.bag.count((Object)"four"));
        HashBagTests.assertEquals((String)"bad count", (int)0, (int)this.bag.count((Object)"five"));
    }

    public void testEquals() {
        HashBag bag2 = this.buildBag();
        HashBagTests.assertEquals((String)"bags are not equal", (Object)this.bag, (Object)bag2);
        bag2.add((Object)"five");
        HashBagTests.assertFalse((String)"bags are equal", (boolean)this.bag.equals((Object)bag2));
        ArrayList c = new ArrayList(this.bag);
        HashBagTests.assertFalse((String)"bags are not equal to collections", (boolean)this.bag.equals(c));
    }

    public void testHashCode() {
        HashBag bag2 = this.buildBag();
        HashBagTests.assertEquals((String)"bad hash code", (int)this.bag.hashCode(), (int)bag2.hashCode());
    }

    public void testIsEmpty() {
        HashBagTests.assertFalse((String)"bag is empty", (boolean)this.bag.isEmpty());
        this.bag.clear();
        HashBagTests.assertTrue((String)"bag is not empty", (boolean)this.bag.isEmpty());
        this.bag.add((Object)"foo");
        HashBagTests.assertFalse((String)"bag is empty", (boolean)this.bag.isEmpty());
    }

    public void testEmptyIterator() {
        this.bag.clear();
        Iterator iterator = this.bag.iterator();
        HashBagTests.assertFalse((String)"iterator is not empty", (boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((String)("NoSuchElementException not thrown: " + element), (boolean)exCaught);
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
    }

    public void testIterator() {
        int i = 0;
        Iterator iterator = this.bag.iterator();
        HashBagTests.assertTrue((String)"iterator is empty", (boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        HashBagTests.assertEquals((String)"invalid hasNext() loop", (int)11, (int)i);
        HashBagTests.assertFalse((String)"iterator should be empty now", (boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((String)("NoSuchElementException not thrown: " + element), (boolean)exCaught);
        iterator.remove();
        HashBagTests.assertEquals((String)"iterator did not remove element", (int)10, (int)this.bag.size());
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
        iterator = this.bag.iterator();
        this.bag.add((Object)"five");
        exCaught = false;
        try {
            iterator.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((String)"ConcurrentModificationException not thrown", (boolean)exCaught);
    }

    public void testUniqueIterator() {
        int i = 0;
        Iterator iterator = this.bag.uniqueIterator();
        HashBagTests.assertTrue((String)"iterator is empty", (boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        HashBagTests.assertEquals((String)"invalid hasNext() loop", (int)5, (int)i);
        HashBagTests.assertFalse((String)"iterator should be empty now", (boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((String)("NoSuchElementException not thrown: " + element), (boolean)exCaught);
        iterator = this.bag.uniqueIterator();
        Object next = null;
        while (iterator.hasNext() && !"four".equals(next)) {
            next = iterator.next();
        }
        iterator.remove();
        HashBagTests.assertEquals((String)"iterator did not remove all copies of element", (int)7, (int)this.bag.size());
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
        iterator = this.bag.uniqueIterator();
        this.bag.add((Object)"five");
        exCaught = false;
        try {
            iterator.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((String)"ConcurrentModificationException not thrown", (boolean)exCaught);
    }

    public void testHashingDistribution() throws Exception {
        HashBag bigBag = new HashBag();
        int i = 0;
        while (i < 10000) {
            bigBag.add((Object)("object" + i));
            ++i;
        }
        Field field = bigBag.getClass().getDeclaredField("table");
        field.setAccessible(true);
        Object[] table = (Object[])field.get(bigBag);
        int bucketCount = table.length;
        int filledBucketCount = 0;
        int i2 = 0;
        while (i2 < bucketCount) {
            if (table[i2] != null) {
                ++filledBucketCount;
            }
            ++i2;
        }
        float loadFactor = (float)filledBucketCount / (float)bucketCount;
        HashBagTests.assertTrue((String)("WARNING - poor load factor: " + loadFactor), ((double)loadFactor > 0.2 ? 1 : 0) != 0);
        HashBagTests.assertTrue((String)("WARNING - poor load factor: " + loadFactor), ((double)loadFactor < 0.75 ? 1 : 0) != 0);
    }

    public void testRemove() {
        HashBagTests.assertTrue((String)"incorrect return value", (boolean)this.bag.remove((Object)"one"));
        HashBagTests.assertFalse((String)"element still present", (boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertFalse((String)"incorrect return value", (boolean)this.bag.remove((Object)"one"));
        HashBagTests.assertTrue((String)"incorrect return value", (boolean)this.bag.remove((Object)"two"));
        HashBagTests.assertTrue((String)"incorrect return value", (boolean)this.bag.remove((Object)"two"));
        HashBagTests.assertFalse((String)"element still present", (boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertFalse((String)"incorrect return value", (boolean)this.bag.remove((Object)"one"));
    }

    public void testRemoveAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("one");
        c.add("three");
        HashBagTests.assertTrue((String)"incorrect return value", (boolean)this.bag.removeAll(c));
        HashBagTests.assertFalse((String)"element still present", (boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertFalse((String)"element still present", (boolean)this.bag.contains((Object)"three"));
        HashBagTests.assertFalse((String)"incorrect return value", (boolean)this.bag.remove((Object)"one"));
        HashBagTests.assertFalse((String)"incorrect return value", (boolean)this.bag.remove((Object)"three"));
        HashBagTests.assertFalse((String)"incorrect return value", (boolean)this.bag.removeAll(c));
    }

    public void testRetainAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("one");
        c.add("three");
        HashBagTests.assertTrue((String)"incorrect return value", (boolean)this.bag.retainAll(c));
        HashBagTests.assertTrue((String)"element removed", (boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertTrue((String)"element removed", (boolean)this.bag.contains((Object)"three"));
        HashBagTests.assertFalse((String)"element still present", (boolean)this.bag.contains((Object)"two"));
        HashBagTests.assertFalse((String)"element still present", (boolean)this.bag.contains((Object)"four"));
        HashBagTests.assertFalse((String)"incorrect return value", (boolean)this.bag.remove((Object)"two"));
        HashBagTests.assertFalse((String)"incorrect return value", (boolean)this.bag.remove((Object)"four"));
        HashBagTests.assertFalse((String)"incorrect return value", (boolean)this.bag.retainAll(c));
    }

    public void testSize() {
        HashBagTests.assertTrue((String)"incorrect size", (this.bag.size() == 11 ? 1 : 0) != 0);
        this.bag.add((Object)"five");
        this.bag.add((Object)"five");
        this.bag.add((Object)"five");
        this.bag.add((Object)"five");
        this.bag.add((Object)"five");
        HashBagTests.assertEquals((String)"incorrect size", (int)16, (int)this.bag.size());
    }

    public void testSerialization() throws Exception {
        Bag bag2 = (Bag)TestTools.serialize(this.bag);
        HashBagTests.assertTrue((String)"same object?", (this.bag != bag2 ? 1 : 0) != 0);
        HashBagTests.assertEquals((String)"incorrect size", (int)11, (int)bag2.size());
        HashBagTests.assertEquals((String)"unequal bag", (Object)this.bag, (Object)bag2);
        HashBagTests.assertTrue((String)"missing element", (boolean)bag2.contains(null));
        HashBagTests.assertTrue((String)"missing element", (boolean)bag2.contains((Object)"one"));
        HashBagTests.assertTrue((String)"missing element", (boolean)bag2.contains((Object)"two"));
        HashBagTests.assertTrue((String)"missing element", (boolean)bag2.contains((Object)"three"));
        HashBagTests.assertTrue((String)"missing element", (boolean)bag2.contains((Object)"four"));
        int nullCount = 0;
        int oneCount = 0;
        int twoCount = 0;
        int threeCount = 0;
        int fourCount = 0;
        Iterator stream = bag2.iterator();
        while (stream.hasNext()) {
            String next = (String)stream.next();
            if (next == null) {
                ++nullCount;
                continue;
            }
            if (next.equals("one")) {
                ++oneCount;
                continue;
            }
            if (next.equals("two")) {
                ++twoCount;
                continue;
            }
            if (next.equals("three")) {
                ++threeCount;
                continue;
            }
            if (!next.equals("four")) continue;
            ++fourCount;
        }
        HashBagTests.assertEquals((String)"bad element count", (int)1, (int)nullCount);
        HashBagTests.assertEquals((String)"bad element count", (int)1, (int)oneCount);
        HashBagTests.assertEquals((String)"bad element count", (int)2, (int)twoCount);
        HashBagTests.assertEquals((String)"bad element count", (int)3, (int)threeCount);
        HashBagTests.assertEquals((String)"bad element count", (int)4, (int)fourCount);
    }

    public void testToArray() {
        Object[] a = this.bag.toArray();
        HashBagTests.assertEquals((String)"incorrect length", (int)11, (int)a.length);
        HashBagTests.assertTrue((String)"missing element", (boolean)CollectionTools.contains((Object[])a, null));
        HashBagTests.assertTrue((String)"missing element", (boolean)CollectionTools.contains((Object[])a, (Object)"one"));
        HashBagTests.assertTrue((String)"missing element", (boolean)CollectionTools.contains((Object[])a, (Object)"two"));
        HashBagTests.assertTrue((String)"missing element", (boolean)CollectionTools.contains((Object[])a, (Object)"three"));
        HashBagTests.assertTrue((String)"missing element", (boolean)CollectionTools.contains((Object[])a, (Object)"four"));
    }

    public void testToArrayObjectArray() {
        Object[] a = new String[12];
        a[11] = "not null";
        String[] b = (String[])this.bag.toArray(a);
        HashBagTests.assertEquals((String)"different array", (Object)a, (Object)b);
        HashBagTests.assertEquals((String)"incorrect length", (int)12, (int)a.length);
        HashBagTests.assertTrue((String)"missing element", (boolean)CollectionTools.contains((Object[])a, null));
        HashBagTests.assertTrue((String)"missing element", (boolean)CollectionTools.contains((Object[])a, (Object)"one"));
        HashBagTests.assertTrue((String)"missing element", (boolean)CollectionTools.contains((Object[])a, (Object)"two"));
        HashBagTests.assertTrue((String)"missing element", (boolean)CollectionTools.contains((Object[])a, (Object)"three"));
        HashBagTests.assertTrue((String)"missing element", (boolean)CollectionTools.contains((Object[])a, (Object)"four"));
        HashBagTests.assertTrue((String)"missing null element", (a[11] == null ? 1 : 0) != 0);
    }

    public void testToString() {
        String s = this.bag.toString();
        HashBagTests.assertTrue((String)"invalid string prefix", (boolean)s.startsWith("["));
        HashBagTests.assertTrue((String)"invalid string suffix", (boolean)s.endsWith("]"));
        int commaCount = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == ',') {
                ++commaCount;
            }
            ++i;
        }
        HashBagTests.assertEquals((String)"invalid number of commas", (int)10, (int)commaCount);
        HashBagTests.assertTrue((String)"missing element toString()", (s.indexOf("one") != -1 ? 1 : 0) != 0);
        HashBagTests.assertTrue((String)"missing element toString()", (s.indexOf("two") != -1 ? 1 : 0) != 0);
        HashBagTests.assertTrue((String)"missing element toString()", (s.indexOf("three") != -1 ? 1 : 0) != 0);
        HashBagTests.assertTrue((String)"missing element toString()", (s.indexOf("four") != -1 ? 1 : 0) != 0);
        HashBagTests.assertTrue((String)"missing element toString()", (s.indexOf("null") != -1 ? 1 : 0) != 0);
    }
}

