/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.iterators.TreeIterator;
import org.eclipse.dali.utility.tests.TestTools;

public class TreeIteratorTests
extends TestCase {
    Collection nodes = new ArrayList();
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.TreeIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.TreeIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public TreeIteratorTests(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testHasNext1() {
        this.verifyHasNext(this.buildTreeIterator1());
    }

    public void testHasNext2() {
        this.verifyHasNext(this.buildTreeIterator2());
    }

    private void verifyHasNext(Iterator iterator) {
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        TreeIteratorTests.assertEquals((int)this.nodes.size(), (int)i);
    }

    public void testNext1() {
        this.verifyNext(this.buildTreeIterator1());
    }

    public void testNext2() {
        this.verifyNext(this.buildTreeIterator2());
    }

    private void verifyNext(Iterator iterator) {
        while (iterator.hasNext()) {
            TreeIteratorTests.assertTrue((String)"bogus element", (boolean)this.nodes.contains(iterator.next()));
        }
    }

    public void testNoSuchElementException1() {
        this.verifyNoSuchElementException(this.buildTreeIterator1());
    }

    public void testNoSuchElementException2() {
        this.verifyNoSuchElementException(this.buildTreeIterator2());
    }

    private void verifyNoSuchElementException(Iterator iterator) {
        boolean exCaught = false;
        while (iterator.hasNext()) {
            iterator.next();
        }
        try {
            iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        TreeIteratorTests.assertTrue((String)"NoSuchElementException not thrown", (boolean)exCaught);
    }

    public void testRemove1() {
        this.verifyRemove(this.buildTreeIterator1());
    }

    public void testRemove2() {
        this.verifyRemove(this.buildTreeIterator2());
    }

    private void verifyRemove(Iterator iterator) {
        String parentName = "child 2";
        String childName = "grandchild 2A";
        int startSize = this.childrenSize(parentName);
        while (iterator.hasNext()) {
            TreeNode node = (TreeNode)iterator.next();
            if (!node.getName().equals(childName)) continue;
            iterator.remove();
        }
        int endSize = this.childrenSize(parentName);
        TreeIteratorTests.assertEquals((int)(startSize - 1), (int)endSize);
    }

    private int childrenSize(String nodeName) {
        Iterator stream = this.nodes.iterator();
        while (stream.hasNext()) {
            TreeNode node = (TreeNode)stream.next();
            if (!node.getName().equals(nodeName)) continue;
            return node.childrenSize();
        }
        throw new IllegalArgumentException(nodeName);
    }

    private Iterator buildTreeIterator1() {
        return new TreeIterator(this.buildTree(), this.buildMidwife());
    }

    private TreeIterator.Midwife buildMidwife() {
        return new TreeIterator.Midwife(){

            public Iterator children(Object next) {
                return ((TreeNode)next).children();
            }
        };
    }

    private Iterator buildTreeIterator2() {
        return new TreeIterator(this.buildTree()){

            public Iterator children(Object next) {
                return ((TreeNode)next).children();
            }
        };
    }

    private Object buildTree() {
        TreeNode root = new TreeNode("root");
        TreeNode child1 = new TreeNode(root, "child 1");
        new TreeNode(child1, "grandchild 1A");
        TreeNode child2 = new TreeNode(root, "child 2");
        new TreeNode(child2, "grandchild 2A");
        TreeNode grandchild2B = new TreeNode(child2, "grandchild 2B");
        new TreeNode(grandchild2B, "great-grandchild 2B1");
        new TreeNode(grandchild2B, "great-grandchild 2B2");
        TreeNode grandchild2C = new TreeNode(child2, "grandchild 2C");
        new TreeNode(grandchild2C, "great-grandchild 2C1");
        new TreeNode(root, "child 3");
        return root;
    }

    private class TreeNode {
        private String name;
        private Collection children = new ArrayList();

        public TreeNode(String name) {
            TreeIteratorTests.this.nodes.add(this);
            this.name = name;
        }

        public TreeNode(TreeNode parent, String name) {
            this(name);
            parent.addChild(this);
        }

        public String getName() {
            return this.name;
        }

        private void addChild(TreeNode child) {
            this.children.add(child);
        }

        public Iterator children() {
            return this.children.iterator();
        }

        public int childrenSize() {
            return this.children.size();
        }

        public String toString() {
            return "TreeNode(" + this.name + ")";
        }
    }
}

