"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Standard virtual document provider for styled content.
 *
 * Wraps content in a top level `:root { }` rule to make css language service happy
 * since styled allows properties to be top level elements.
 */
var StyledVirtualDocumentFactory = /** @class */ (function () {
    function StyledVirtualDocumentFactory() {
    }
    StyledVirtualDocumentFactory.prototype.createVirtualDocument = function (context) {
        var _this = this;
        var contents = "" + StyledVirtualDocumentFactory.wrapperPre + context.text + "\n}";
        return {
            uri: 'untitled://embedded.scss',
            languageId: 'scss',
            version: 1,
            getText: function () { return contents; },
            positionAt: function (offset) {
                var pos = context.toPosition(_this.fromVirtualDocOffset(offset));
                return _this.toVirtualDocPosition(pos);
            },
            offsetAt: function (p) {
                var offset = context.toOffset(_this.fromVirtualDocPosition(p));
                return _this.toVirtualDocOffset(offset);
            },
            lineCount: contents.split(/\n/g).length + 1,
        };
    };
    StyledVirtualDocumentFactory.prototype.toVirtualDocPosition = function (position) {
        return {
            line: position.line + 1,
            character: position.character,
        };
    };
    StyledVirtualDocumentFactory.prototype.fromVirtualDocPosition = function (position) {
        return {
            line: position.line - 1,
            character: position.character,
        };
    };
    StyledVirtualDocumentFactory.prototype.toVirtualDocOffset = function (offset) {
        return offset + StyledVirtualDocumentFactory.wrapperPre.length;
    };
    StyledVirtualDocumentFactory.prototype.fromVirtualDocOffset = function (offset) {
        return offset - StyledVirtualDocumentFactory.wrapperPre.length;
    };
    StyledVirtualDocumentFactory.wrapperPre = ':root{\n';
    return StyledVirtualDocumentFactory;
}());
exports.StyledVirtualDocumentFactory = StyledVirtualDocumentFactory;
