/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.draw2d.EventManager;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.draw2d.IPreferredSizeProvider;
import org.eclipse.wb.internal.draw2d.IRootFigure;
import org.eclipse.wb.internal.draw2d.RefreshManager;

public class RootFigure
extends Figure
implements IRootFigure {
    private final FigureCanvas m_figureCanvas;
    private final RefreshManager m_refreshManager;
    private EventManager m_eventManager;
    private Dimension m_preferredSize;
    private Map<String, Layer> m_nameToLayer = new HashMap<String, Layer>();
    private IPreferredSizeProvider m_preferredSizeProvider;

    public RootFigure(FigureCanvas figureCanvas, RefreshManager refreshManager) {
        this.m_figureCanvas = figureCanvas;
        this.m_refreshManager = refreshManager;
        this.setOpaque(true);
    }

    public void setEventManager(EventManager eventManager) {
        this.m_eventManager = eventManager;
    }

    public void setPreferredSizeProvider(IPreferredSizeProvider provider) {
        this.m_preferredSizeProvider = provider;
    }

    @Override
    public FigureCanvas getFigureCanvas() {
        return this.m_figureCanvas;
    }

    public Dimension getPreferredSize() {
        if (this.m_preferredSize == null) {
            Rectangle preferred = new Rectangle();
            for (Layer layer : this.getLayers()) {
                for (Figure figure : layer.getChildren()) {
                    if (!figure.isVisible()) continue;
                    if (figure instanceof IPreferredSizeProvider) {
                        IPreferredSizeProvider provider = (IPreferredSizeProvider)((Object)figure);
                        Dimension figurePreferredSize = provider.getPreferredSize(null);
                        preferred.union(0, 0, figurePreferredSize.width, figurePreferredSize.height);
                        continue;
                    }
                    preferred.union(figure.getBounds());
                }
            }
            this.m_preferredSize = this.m_preferredSizeProvider == null ? preferred.getSize() : this.m_preferredSizeProvider.getPreferredSize(preferred.getSize());
        }
        return this.m_preferredSize;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        Rectangle value = this.getBounds().setBounds(bounds).union(this.getPreferredSize());
        for (Layer layer : this.getLayers()) {
            layer.setBounds(value);
        }
    }

    @Override
    protected void repaint(boolean reset, int x, int y, int width, int height) {
        if (reset) {
            this.m_preferredSize = null;
        }
        this.m_refreshManager.refreshRequest(x, y, width, height);
    }

    @Override
    protected void updateCursor() {
        this.m_eventManager.updateCursor();
    }

    @Override
    public void setCapture(Figure figure) {
        this.m_eventManager.setCapture(figure);
    }

    @Override
    public void addLayer(Layer layer) {
        this.m_nameToLayer.put(layer.getName(), layer);
        this.add(layer, null, -1);
    }

    @Override
    public void addLayer(Layer layer, int index) {
        this.m_nameToLayer.put(layer.getName(), layer);
        this.add(layer, null, index);
    }

    @Override
    public Layer getLayer(String name) {
        return this.m_nameToLayer.get(name);
    }

    @Override
    public List<Layer> getLayers() {
        ArrayList layers = Lists.newArrayList();
        for (Figure childFigure : this.getChildren()) {
            layers.add((Layer)childFigure);
        }
        return layers;
    }

    @Override
    public void removeLayer(String name) {
        this.removeLayer(this.getLayer(name));
    }

    @Override
    public void removeLayer(Layer layer) {
        this.m_nameToLayer.remove(layer.getName());
        this.remove(layer);
    }

    @Override
    public void removeAll() {
        this.m_nameToLayer = new HashMap<String, Layer>();
        super.removeAll();
    }
}

