/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.gef.policy;

import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.border.Border;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Insets;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.xml.gef.part.AbstractComponentEditPart;
import org.eclipse.wb.internal.swt.support.ToolkitSupport;
import org.eclipse.wb.internal.xwt.model.widgets.ShellInfo;
import org.eclipse.wb.internal.xwt.model.widgets.menu.MenuInfo;

public class MenuBarDropLayoutEditPolicy
extends LayoutEditPolicy {
    private final ShellInfo m_shell;
    private final ILayoutRequestValidator m_validator;
    private Figure m_fillFeedback;

    public MenuBarDropLayoutEditPolicy(ShellInfo shell) {
        this.m_shell = shell;
        this.m_validator = new MenuBarDrop_Validator(shell);
    }

    protected ILayoutRequestValidator getRequestValidator() {
        return this.m_validator;
    }

    protected void showLayoutTargetFeedback(Request request) {
        if (this.m_fillFeedback == null) {
            this.m_fillFeedback = new Figure(){

                protected void paintClientArea(Graphics graphics) {
                    Rectangle bounds = this.getBounds();
                    graphics.setForegroundColor(IColorConstants.darkGreen);
                    String menuBarText = "Menu bar would be placed here";
                    Dimension textExtent = graphics.getTextExtent(menuBarText);
                    int x = bounds.width / 2 - textExtent.width / 2;
                    int y = bounds.height / 2 - textExtent.height / 2;
                    graphics.drawString(menuBarText, x, y);
                }
            };
            this.m_fillFeedback.setOpaque(true);
            this.m_fillFeedback.setBackground(IColorConstants.menuBackground);
            Insets clientAreaInsets = this.m_shell.getClientAreaInsets();
            final Rectangle bounds = this.getHostFigure().getBounds().getCopy();
            bounds.width -= clientAreaInsets.getWidth();
            if (EnvironmentUtils.IS_MAC) {
                bounds.x = AbstractComponentEditPart.TOP_LOCATION.x;
                bounds.y = 3;
            } else {
                bounds.x += clientAreaInsets.left;
                bounds.y += clientAreaInsets.top;
            }
            ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    bounds.height = ToolkitSupport.getDefaultMenuBarHeight();
                }
            });
            this.m_fillFeedback.setBounds(bounds);
            this.m_fillFeedback.setBorder((Border)new LineBorder(IColorConstants.menuBackgroundSelected, 1));
            this.addFeedback(this.m_fillFeedback);
        }
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.m_fillFeedback != null) {
            this.removeFeedback(this.m_fillFeedback);
            this.m_fillFeedback = null;
        }
    }

    protected Command getCreateCommand(CreateRequest request) {
        final MenuInfo menu = (MenuInfo)((Object)request.getNewObject());
        return new EditCommand((ObjectInfo)this.m_shell){

            protected void executeEdit() throws Exception {
                menu.commandCreate(MenuBarDropLayoutEditPolicy.this.m_shell);
            }
        };
    }

    public static final class MenuBarDrop_Validator
    extends ILayoutRequestValidator.LayoutRequestValidatorStubFalse {
        private final ShellInfo m_m_shell;

        public MenuBarDrop_Validator(ShellInfo m_shell) {
            this.m_m_shell = m_shell;
        }

        public boolean validateCreateRequest(EditPart host, CreateRequest request) {
            for (MenuInfo menuInfo : this.m_m_shell.getChildren(MenuInfo.class)) {
                if (!menuInfo.isBar()) continue;
                return false;
            }
            Object newObject = request.getNewObject();
            if (newObject instanceof MenuInfo) {
                return ((MenuInfo)((Object)newObject)).isBar();
            }
            return false;
        }
    }
}

