/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.color;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.internal.core.utils.Messages;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorInfo;

public final class ColorPreviewCanvas
extends Canvas {
    private ColorInfo m_color;
    private final boolean m_showShortText;

    public ColorPreviewCanvas(Composite parent, int style, boolean showShortText) {
        super(parent, style);
        this.m_showShortText = showShortText;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ColorPreviewCanvas.this.onPaint(e.gc);
            }
        });
    }

    public ColorPreviewCanvas(Composite parent, int style) {
        this(parent, style, false);
    }

    public void setColor(ColorInfo color) {
        this.m_color = color;
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = wHint;
        int height = 70;
        return new Point(width, height);
    }

    private void onPaint(GC gc) {
        Rectangle r = this.getClientArea();
        if (this.m_color != null) {
            int y = 0;
            String title = this.m_showShortText ? this.m_color.getName() : this.m_color.getTitle();
            int height = gc.stringExtent((String)title).y;
            ColorPreviewCanvas.drawCenteredText(gc, title, 0, 0, r.width, height);
            y += height;
            if (this.m_color.m_description != null) {
                String text = this.m_color.m_description;
                height = gc.stringExtent((String)text).y;
                ColorPreviewCanvas.drawCenteredText(gc, text, 0, y, r.width, height);
                y += height;
            }
            if (this.m_color.m_rgb != null) {
                Color color = new Color((Device)this.getDisplay(), this.m_color.m_rgb);
                try {
                    Color oldBackground = gc.getBackground();
                    gc.setBackground(color);
                    gc.fillRectangle(0, y, r.width / 2, r.height - y);
                    gc.setBackground(oldBackground);
                    Font font = new Font((Device)this.getDisplay(), "Arial", 16, 0);
                    try {
                        gc.setFont(font);
                        gc.setForeground(color);
                        ColorPreviewCanvas.drawCenteredText(gc, Messages.ColorPreviewCanvas_sampleText, r.width / 2, y, r.width / 2, r.height - y);
                    }
                    finally {
                        font.dispose();
                    }
                }
                finally {
                    color.dispose();
                }
            }
        }
    }

    private static void drawCenteredText(GC gc, String text, int x, int y, int w, int h) {
        Point extent = gc.textExtent(text);
        gc.drawText(text, x + (w - extent.x) / 2, y + (h - extent.y) / 2, true);
    }
}

