/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.property;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.xml.model.property.GenericProperty;

public final class GenericPropertyComposite
extends GenericProperty {
    private final GenericProperty[] m_properties;
    private static final Object NO_VALUE = new Object();

    public static GenericPropertyComposite create(Property ... properties) {
        GenericProperty[] genericProperties = new GenericProperty[properties.length];
        int i = 0;
        while (i < properties.length) {
            Property property = properties[i];
            genericProperties[i] = (GenericProperty)property;
            ++i;
        }
        GenericPropertyComposite composite = new GenericPropertyComposite(genericProperties);
        composite.setCategory(genericProperties[0].getCategory());
        return composite;
    }

    public GenericPropertyComposite(GenericProperty[] properties) {
        super(properties[0].getObject(), properties[0].getTitle(), properties[0].getEditor());
        this.m_properties = properties;
    }

    public int hashCode() {
        return this.m_properties.length;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GenericPropertyComposite) {
            GenericPropertyComposite property = (GenericPropertyComposite)((Object)obj);
            return ArrayUtils.isEquals((Object)this.m_properties, (Object)property.m_properties);
        }
        return false;
    }

    public boolean isModified() throws Exception {
        GenericProperty[] genericPropertyArray = this.m_properties;
        int n = this.m_properties.length;
        int n2 = 0;
        while (n2 < n) {
            GenericProperty property = genericPropertyArray[n2];
            if (property.isModified()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Object getValue() throws Exception {
        Object value = NO_VALUE;
        GenericProperty[] genericPropertyArray = this.m_properties;
        int n = this.m_properties.length;
        int n2 = 0;
        while (n2 < n) {
            GenericProperty property = genericPropertyArray[n2];
            Object propertyValue = property.getValue();
            if (value == NO_VALUE) {
                value = propertyValue;
            } else if (!ObjectUtils.equals((Object)value, (Object)propertyValue)) {
                return UNKNOWN_VALUE;
            }
            ++n2;
        }
        return value;
    }

    @Override
    public void setValue(final Object value) throws Exception {
        ExecutionUtils.run((ObjectInfo)this.m_object, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GenericProperty[] genericPropertyArray = GenericPropertyComposite.this.m_properties;
                int n = genericPropertyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GenericProperty property = genericPropertyArray[n2];
                    property.setValue(value);
                    ++n2;
                }
            }
        });
    }

    public Class<?> getType() {
        Class commonType = null;
        GenericProperty[] genericPropertyArray = this.m_properties;
        int n = this.m_properties.length;
        int n2 = 0;
        while (n2 < n) {
            GenericProperty property = genericPropertyArray[n2];
            Class type = property.getType();
            if (commonType == null) {
                commonType = type;
            } else if (type != commonType) {
                return null;
            }
            ++n2;
        }
        return commonType;
    }

    @Override
    public boolean hasTrueTag(String tag) {
        GenericProperty[] genericPropertyArray = this.m_properties;
        int n = this.m_properties.length;
        int n2 = 0;
        while (n2 < n) {
            GenericProperty property = genericPropertyArray[n2];
            if (!property.hasTrueTag(tag)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public String getExpression() {
        String commonExpression = null;
        GenericProperty[] genericPropertyArray = this.m_properties;
        int n = this.m_properties.length;
        int n2 = 0;
        while (n2 < n) {
            GenericProperty property = genericPropertyArray[n2];
            String expression = property.getExpression();
            if (expression == null) {
                return null;
            }
            if (commonExpression == null) {
                commonExpression = expression;
            } else if (!commonExpression.equals(expression)) {
                return null;
            }
            ++n2;
        }
        return commonExpression;
    }

    @Override
    public void setExpression(final String expression, final Object value) throws Exception {
        ExecutionUtils.run((ObjectInfo)this.m_object, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GenericProperty[] genericPropertyArray = GenericPropertyComposite.this.m_properties;
                int n = genericPropertyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GenericProperty property = genericPropertyArray[n2];
                    property.setExpression(expression, value);
                    ++n2;
                }
            }
        });
    }
}

