#
# Copyright (c) 2022 ZettaScale Technology.
#
# This program and the accompanying materials are made available under the
# terms of the Eclipse Public License 2.0 which is available at
# http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
# which is available at https://www.apache.org/licenses/LICENSE-2.0.
#
# SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
#
# Contributors:
#   ZettaScale Zenoh team, <zenoh@zettascale.tech>
#


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was PackageConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# Compute the installation prefix relative to this file.
get_filename_component(_IMPORT_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
get_filename_component(_IMPORT_PREFIX "${_IMPORT_PREFIX}" PATH)
get_filename_component(_IMPORT_PREFIX "${_IMPORT_PREFIX}" PATH)
get_filename_component(_IMPORT_PREFIX "${_IMPORT_PREFIX}" PATH)
if(_IMPORT_PREFIX STREQUAL "/")
  set(_IMPORT_PREFIX "")
endif()

add_library(zenohcxx INTERFACE IMPORTED)
target_include_directories(zenohcxx INTERFACE "${_IMPORT_PREFIX}/include")

# zenohcxx for zenohpico
if(TARGET zenohpico)
	add_library(zenohcxx_zenohpico INTERFACE IMPORTED)
	target_compile_definitions(zenohcxx_zenohpico INTERFACE ZENOHCXX_ZENOHPICO)
    target_include_directories(zenohcxx_zenohpico INTERFACE "${_IMPORT_PREFIX}/include")
	add_dependencies(zenohcxx_zenohpico zenohpico)
	target_link_libraries(zenohcxx_zenohpico INTERFACE zenohpico)
	add_library(zenohcxx::zenohpico ALIAS zenohcxx_zenohpico)
endif()

# zenohcxx for zenohc static/dynamic depending on ZENOHC_LIB_STATIC
if(TARGET zenohc::lib)
	message(STATUS "defined lib target zenohcxx::zenohc::lib for zenohc::lib")
	add_library(zenohcxx_zenohc_lib INTERFACE IMPORTED)
	target_compile_definitions(zenohcxx_zenohc_lib INTERFACE ZENOHCXX_ZENOHC)
    target_include_directories(zenohcxx_zenohc_lib INTERFACE "${_IMPORT_PREFIX}/include")
	add_dependencies(zenohcxx_zenohc_lib zenohc::lib)
	target_link_libraries(zenohcxx_zenohc_lib INTERFACE zenohc::lib)
	add_library(zenohcxx::zenohc::lib ALIAS zenohcxx_zenohc_lib)
endif()

# zenohcxx for zenohc dynamic
if(TARGET zenohc::shared)
	message(STATUS "defined lib target if(TARGET zenohc::shared for zenohc::shared")
	add_library(zenohcxx_zenohc_shared INTERFACE IMPORTED)
	target_compile_definitions(zenohcxx_zenohc_shared INTERFACE ZENOHCXX_ZENOHC)
	target_include_directories(zenohcxx_zenohc_shared INTERFACE "${_IMPORT_PREFIX}/include")
	add_dependencies(zenohcxx_zenohc_shared zenohc::shared)
	target_link_libraries(zenohcxx_zenohc_shared INTERFACE zenohc::shared)
	add_library(zenohcxx::zenohc::shared ALIAS zenohcxx_zenohc_shared)
endif()

# zenohcxx for zenohc static
if(TARGET zenohc::static)
	message(STATUS "defined lib target zenohcxx::zenohc::static for zenohc::static")
	add_library(zenohcxx_zenohc_static INTERFACE IMPORTED)
	target_compile_definitions(zenohcxx_zenohc_static INTERFACE ZENOHCXX_ZENOHC)
    target_include_directories(zenohcxx_zenohc_static INTERFACE "${_IMPORT_PREFIX}/include")
	add_dependencies(zenohcxx_zenohc_static zenohc::static)
	target_link_libraries(zenohcxx_zenohc_static INTERFACE zenohc::static)
	add_library(zenohcxx::zenohc::static ALIAS zenohcxx_zenohc_static)
endif()
