
(when (and os-type--linux-p emacs-dialect--gnuemacs-p)
  (setq backup-inhibited t)
  (setq backup-directory-alist '(("." . "~/.emacs.d")))
  (setq version-control t)
  (setq kept-new-versions 2)
  (setq kept-old-versions 2))

(when (and os-type--mswindows-p emacs-dialect--gnuemacs-p)
  (setq backup-inhibited t)
  ;;(setq version-control t)
  ;;(setq kept-new-versions 2)
  ;;(setq kept-old-versions 2)
  )

(setq completion-ignored-extensions
      (append (list
               ".old5"
               ".old4"
               ".old3"
               ".old2"
               ".old"
               ".out"
               ".exe"
               ".pif"
               ".com"
               ".class"
               ".tmp"
               ".tm4"
               ".num"
               ".dep"
               ".DEP"
               ".ps"
               ".dvi"
               ".aux"
               ".log"
               ".tga"
               ".sys"
               ;; ".ctxt" Eclipse generated file
               )
              completion-ignored-extensions))

'(setq dired-omit-extensions
      (append (list
               ".num")
              dired-omit-extensions))

;;(setq completion-ignored-extensions (delete ".a" completion-ignored-extensions))
;;(setq completion-ignored-extensions (delete ".log" completion-ignored-extensions))

(put 'erase-buffer 'disabled nil)

(setq dired-guess-shell-alist-user
      '(("\\.zip" "unzip")
        ("\\.wav" "playwav")
        ("\\.tga" "view")
        ("\\.pcx" "view")
        ))

;;
;; QUESTION: why does this not affect the status in the modeline?
;;
;; ANSWER: because it only sets in when you call eval-expression
;;
;;(setq eval-expression-debug-on-error nil)
;;(setq eval-expression-debug-on-error t)

;;; see d-start.el for setting debug-on-error
(setq debug-ignored-errors (append
                            (list ;;"Args out of range"
                                  "No dynamic expansion for `.*' found"
                                  "No further dynamic expansion for `.*' found"
                                  "Containing expression ends prematurely"
                                  "Command attempted to use minibuffer while in minibuffer"
                                  "No mark set in this buffer"
                                  "End of history; no default available"
                                  "Can't expand minibuffer to full frame"
                                  "No.* dynamic expansion for `[a-zA-Z0-9_\t\r\n]*' found"
                                  "Attempt to split minibuffer window"
                                  "File .* does not exist"
                                  )
                            debug-ignored-errors))

;;(setq debug-ignored-errors (remove "Containing expression ends prematurely" debug-ignored-errors))
(setq debug-ignored-errors (remove 'end-of-file debug-ignored-errors))
;;(setq debug-ignored-errors

;;; (try-me)
(defun try-me ()
  (let ((a 123))
    (error "Schmu")))



(autoload 'pov-mode "d-povray.el")
;;(check-c-c-binding)

;;(setq-default outline-regexp "[\\-\\+]?\\**")

(setq same-window-buffer-names (cons "*compilation*" same-window-buffer-names))

(setq same-window-regexps
      (append
       (list "\\*compilation\\*" "\\*Backtrace\\*")
       same-window-regexps))

;;(setq same-window-regexps (cdr same-window-regexps))


(setq-default fill-column 70)

(if emacs-dialect--xemacs-p
    (progn
      (line-number-mode 1)
      (paren-set-mode 2)
      (if (string= system-configuration "sparc-sun-solaris2.4")
          (setq visible-bell nil)
       )
      (setq zmacs-regions nil)
      )
  )

(auto-compression-mode 1)
(setq max-mini-window-height 1.0)
;;(blink-cursor-mode -1)
;;(blink-cursor-mode nil)
;;(setq blink-cursor nil)
(setq compilation-scroll-output t)
(setq load-prefer-newer t) ;; prefers latest file out of x.el and x.elc

;;(message "*** done: prefs.el init file")

(provide 'd-prefs)
;;; d-prefs.el ends here
