/* webpage c interfaces
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

/*
 * webpage.funct.c
 * Guy Albertelli II 1999
 */
#include <stdio.h>
#include <tcl.h>
#include <pProj/capaCommon.h>
#include <webpage.h>

int emailcapaid(int argc, char** argv)
{
  char      studentNum[MAX_STUDENT_NUMBER+1];
  int       i,setId,pin;
  T_student student_data;
  time_t    curtime;

  if (argc != 4) {   
    printf("USAGE: webpage -emailcapaid stunum setId\n",argv[0]);
    return 0;
  }

  strncpy(studentNum,argv[2],MAX_STUDENT_NUMBER);
  setId=atoi(argv[3]);
  if ( setId > 99 || setId < 1 ) {
    printf("InvalidSetId");
    return 0;
  }
  pin=capa_PIN(studentNum, setId,0);
  i=capa_get_student(studentNum,&student_data);
  if ( i > 0 ) {
    time(&curtime);
    if( capa_check_date(CHECK_OPEN_DATE,studentNum,
			student_data.s_sec,setId) < 0 ) {
      printf("NotOpen");
    } else {
      printf("%d %s",pin,student_data.s_email);
    }
  } else {
    printf("NotFound");
  }
  return 0;
}

int getid(int argc, char** argv)
{
  char studentNum[MAX_STUDENT_NUMBER+1];
  int i,setId,oldCapaID=-1,oldSetId,found=1,pin;
  T_student student_data;
  time_t    curtime;

  if (argc>5 || argc<4) {   
    printf("USAGE: webpage -getid stunum setId oldCapaID\n");
    return 0;
  }

  strncpy(studentNum,argv[2],MAX_STUDENT_NUMBER);
  setId=atoi(argv[3]);
  if ( setId > 99 || setId < 1 ) {
    printf("InvalidSetId");
    return 0;
  }
  if ( argc == 5 ) {
    found=0;
    oldCapaID=atoi(argv[4]); 
    if ( oldCapaID < 1000 || oldCapaID > 9999 ) {
      printf("InvalidOldCapaID");
      return 0;
    }
    for(i=1;(i<setId)&&(!found);i++)  if (capa_PIN(studentNum,i,oldCapaID)) found=i;
  }
  /* old line printf("%d",capa_PIN(studentNum, setId,0)); else printf("NotFound");*/
  if ( found ) {
    pin=capa_PIN(studentNum, setId,0);
    if ( capa_get_student(studentNum,&student_data) > 0 ) {
      time(&curtime);
      if( capa_check_date(CHECK_OPEN_DATE,studentNum,
			  student_data.s_sec,setId) < 0 ) {
	printf("NotOpen");
      } else {
	printf("%d",pin);
      }
    } else {
      printf("NotFound");
    }
  } else {
    printf("NotFound");
  }
  return 0;
}


