/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.VariableSubstitutor;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.OsConstraint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;

public class ProcessPanelWorker
implements Runnable {
    private static final String SPEC_RESOURCE_NAME = "ProcessPanel.Spec.xml";
    private VariableSubstitutor vs;
    private XMLElement spec;
    private AutomatedInstallData idata;
    protected AbstractUIProcessHandler handler;
    private ArrayList jobs = new ArrayList();
    private Thread processingThread = null;
    static /* synthetic */ Class class$com$izforge$izpack$util$AbstractUIProcessHandler;
    static /* synthetic */ Class array$Ljava$lang$String;

    public ProcessPanelWorker(AutomatedInstallData automatedInstallData, AbstractUIProcessHandler abstractUIProcessHandler) throws IOException {
        this.idata = automatedInstallData;
        this.handler = abstractUIProcessHandler;
        this.vs = new VariableSubstitutor(automatedInstallData.getVariables());
        if (!this.readSpec()) {
            throw new IOException("Error reading processing specification");
        }
    }

    private boolean readSpec() {
        InputStream inputStream;
        try {
            inputStream = ResourceManager.getInstance().getInputStream(SPEC_RESOURCE_NAME);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(new StdXMLBuilder());
        stdXMLParser.setValidator(new NonValidator());
        try {
            stdXMLParser.setReader(new StdXMLReader(inputStream));
            this.spec = (XMLElement)stdXMLParser.parse();
        }
        catch (Exception exception) {
            System.err.println("Error parsing XML specification for processing.");
            System.err.println(exception.toString());
            return false;
        }
        if (!this.spec.hasChildren()) {
            return false;
        }
        Iterator iterator = this.spec.getChildrenNamed("job").iterator();
        while (iterator.hasNext()) {
            String string;
            XMLElement xMLElement;
            Iterator iterator2;
            ArrayList<String> arrayList;
            String string2;
            XMLElement xMLElement2;
            XMLElement xMLElement3 = (XMLElement)iterator.next();
            List list = OsConstraint.getOsList(xMLElement3);
            if (!OsConstraint.oneMatchesCurrentSystem(list)) continue;
            ArrayList<Processable> arrayList2 = new ArrayList<Processable>();
            String string3 = xMLElement3.getAttribute("name", "");
            Iterator iterator3 = xMLElement3.getChildrenNamed("executefile").iterator();
            while (iterator3.hasNext()) {
                xMLElement2 = (XMLElement)iterator3.next();
                string2 = xMLElement2.getAttribute("name");
                if (string2 == null || string2.length() == 0) {
                    System.err.println("missing \"name\" attribute for <executefile>");
                    return false;
                }
                arrayList = new ArrayList<String>();
                iterator2 = xMLElement2.getChildrenNamed("arg").iterator();
                while (iterator2.hasNext()) {
                    xMLElement = (XMLElement)iterator2.next();
                    string = xMLElement.getContent();
                    arrayList.add(string);
                }
                arrayList2.add(new ExecutableFile(string2, arrayList));
            }
            iterator3 = xMLElement3.getChildrenNamed("executeclass").iterator();
            while (iterator3.hasNext()) {
                xMLElement2 = (XMLElement)iterator3.next();
                string2 = xMLElement2.getAttribute("name");
                if (string2 == null || string2.length() == 0) {
                    System.err.println("missing \"name\" attribute for <executeclass>");
                    return false;
                }
                arrayList = new ArrayList();
                iterator2 = xMLElement2.getChildrenNamed("arg").iterator();
                while (iterator2.hasNext()) {
                    xMLElement = (XMLElement)iterator2.next();
                    string = xMLElement.getContent();
                    arrayList.add(string);
                }
                arrayList2.add(new ExecutableClass(string2, arrayList));
            }
            this.jobs.add(new ProcessingJob(string3, arrayList2));
        }
        return true;
    }

    public void run() {
        this.handler.startProcessing(this.jobs.size());
        Iterator iterator = this.jobs.iterator();
        while (iterator.hasNext()) {
            ProcessingJob processingJob = (ProcessingJob)iterator.next();
            this.handler.startProcess(processingJob.name);
            boolean bl = processingJob.run(this.handler, this.vs);
            this.handler.finishProcess();
            if (bl) continue;
        }
        this.handler.finishProcessing();
    }

    public void startThread() {
        this.processingThread = new Thread((Runnable)this, "processing thread");
        this.processingThread.start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ExecutableClass
    implements Processable {
        private final String myClassName;
        private final List myArguments;
        protected AbstractUIProcessHandler myHandler;

        public ExecutableClass(String string, List list) {
            this.myClassName = string;
            this.myArguments = list;
        }

        public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, VariableSubstitutor variableSubstitutor) {
            boolean bl = false;
            this.myHandler = abstractUIProcessHandler;
            String[] stringArray = new String[this.myArguments.size()];
            int n = 0;
            Object object = this.myArguments.iterator();
            while (object.hasNext()) {
                stringArray[n++] = variableSubstitutor.substitute((String)object.next(), "plain");
            }
            try {
                object = this.getClass().getClassLoader();
                Class<?> clazz = ((ClassLoader)object).loadClass(this.myClassName);
                Object obj = clazz.newInstance();
                Method method = clazz.getMethod("run", class$com$izforge$izpack$util$AbstractUIProcessHandler == null ? (class$com$izforge$izpack$util$AbstractUIProcessHandler = ProcessPanelWorker.class$("com.izforge.izpack.util.AbstractUIProcessHandler")) : class$com$izforge$izpack$util$AbstractUIProcessHandler, array$Ljava$lang$String == null ? (array$Ljava$lang$String = ProcessPanelWorker.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                method.invoke(obj, this.myHandler, stringArray);
                bl = true;
            }
            catch (SecurityException securityException) {
                this.myHandler.emitError("Post Processing Error", "Security exception thrown when processing class: " + this.myClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.myHandler.emitError("Post Processing Error", "Cannot find processing class: " + this.myClassName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.myHandler.emitError("Post Processing Error", "Processing class does not have 'run' method: " + this.myClassName);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.myHandler.emitError("Post Processing Error", "Error accessing processing class: " + this.myClassName);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.myHandler.emitError("Post Processing Error", "Invocation Problem calling : " + this.myClassName + ", " + invocationTargetException.getCause().getMessage());
            }
            catch (Exception exception) {
                this.myHandler.emitError("Post Processing Error", "Exception when running processing class: " + this.myClassName + ", " + exception.getMessage());
            }
            catch (Error error) {
                this.myHandler.emitError("Post Processing Error", "Error when running processing class: " + this.myClassName + ", " + error.getMessage());
            }
            catch (Throwable throwable) {
                this.myHandler.emitError("Post Processing Error", "Error when running processing class: " + this.myClassName + ", " + throwable.getMessage());
            }
            return bl;
        }
    }

    class ExecutableFile
    implements Processable {
        private String filename;
        private List arguments;
        protected AbstractUIProcessHandler handler;

        public ExecutableFile(String string, List list) {
            this.filename = string;
            this.arguments = list;
        }

        public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, VariableSubstitutor variableSubstitutor) {
            this.handler = abstractUIProcessHandler;
            String[] stringArray = new String[this.arguments.size() + 1];
            stringArray[0] = variableSubstitutor.substitute(this.filename, "plain");
            int n = 1;
            Object object = this.arguments.iterator();
            while (object.hasNext()) {
                stringArray[n++] = variableSubstitutor.substitute((String)object.next(), "plain");
            }
            try {
                object = Runtime.getRuntime().exec(stringArray);
                OutputMonitor outputMonitor = new OutputMonitor(this.handler, ((Process)object).getInputStream(), false);
                OutputMonitor outputMonitor2 = new OutputMonitor(this.handler, ((Process)object).getErrorStream(), true);
                Thread thread = new Thread(outputMonitor);
                Thread thread2 = new Thread(outputMonitor2);
                thread.setDaemon(true);
                thread2.setDaemon(true);
                thread.start();
                thread2.start();
                try {
                    int n2 = ((Process)object).waitFor();
                    this.stopMonitor(outputMonitor, thread);
                    this.stopMonitor(outputMonitor2, thread2);
                    if (n2 != 0 && this.handler.askQuestion("process execution failed", "Continue anyway?", 37, 47) == 49) {
                        return false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    ((Process)object).destroy();
                    this.handler.emitError("process interrupted", interruptedException.toString());
                    return false;
                }
            }
            catch (IOException iOException) {
                this.handler.emitError("I/O error", iOException.toString());
                return false;
            }
            return true;
        }

        private void stopMonitor(OutputMonitor outputMonitor, Thread thread) {
            outputMonitor.doStop();
            long l = 500L;
            try {
                thread.join(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!thread.isAlive()) {
                return;
            }
            thread.interrupt();
            long l2 = 500L;
            try {
                thread.join(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public class OutputMonitor
        implements Runnable {
            private boolean stderr = false;
            private AbstractUIProcessHandler handler;
            private BufferedReader reader;
            private Boolean stop = new Boolean(false);

            public OutputMonitor(AbstractUIProcessHandler abstractUIProcessHandler, InputStream inputStream, boolean bl) {
                this.stderr = bl;
                this.reader = new BufferedReader(new InputStreamReader(inputStream));
                this.handler = abstractUIProcessHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    String string;
                    while ((string = this.reader.readLine()) != null) {
                        this.handler.logOutput(string, this.stderr);
                        Boolean bl = this.stop;
                        synchronized (bl) {
                            if (this.stop.booleanValue()) {
                                return;
                            }
                        }
                    }
                    return;
                }
                catch (IOException iOException) {
                    this.handler.logOutput(iOException.toString(), true);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doStop() {
                Boolean bl = this.stop;
                synchronized (bl) {
                    this.stop = new Boolean(true);
                }
            }
        }
    }

    class ProcessingJob
    implements Processable {
        public String name;
        private List processables;

        public ProcessingJob(String string, List list) {
            this.name = string;
            this.processables = list;
        }

        public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, VariableSubstitutor variableSubstitutor) {
            Iterator iterator = this.processables.iterator();
            while (iterator.hasNext()) {
                Processable processable = (Processable)iterator.next();
                if (processable.run(abstractUIProcessHandler, variableSubstitutor)) continue;
                return false;
            }
            return true;
        }
    }

    static interface Processable {
        public boolean run(AbstractUIProcessHandler var1, VariableSubstitutor var2);
    }
}

