/*
** Session Saver 0.2d : Pike + rue
*/ 

// enable xpconnect -- anywhere!
netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
netscape.security.PrivilegeManager.enablePrivilege('UniversalPreferencesRead');
const DATASOURCE_CONTRACTID = '@mozilla.org/rdf/datasource;1?name=in-memory-datasource';
const RDFSERVICE_CONTRACTID = '@mozilla.org/rdf/rdf-service;1';
const CONTAINERUTILS_CONTRACTID = '@mozilla.org/rdf/container-utils;1';
const CONTENTPOLICY_CONTRACTID = "@mozilla.org/layout/content-policy;1";

var rdf =  Components.classes[RDFSERVICE_CONTRACTID].getService(Components.interfaces.nsIRDFService);
var utils = Components.classes[CONTAINERUTILS_CONTRACTID].getService(Components.interfaces.nsIRDFContainerUtils);
var policy = Components.classes[CONTENTPOLICY_CONTRACTID].getService(Components.interfaces.nsIContentPolicy);
var datasource, sequence;

const prefix = 'http://sessionsaver.mozilla.org/rdf#';

var SessionSaverSettings = {

	onLoad: function() {
		// enable xpconnect -- anywhere!
		netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
		netscape.security.PrivilegeManager.enablePrivilege('UniversalPreferencesRead');
		// Setup object properties
		this.prefService = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService);
		this.prefBranch = "sessionsaver.";
		this.prefBranchWindows = "windows.";  // the "live" capture of the current session
		this.prefBranchStatic = "static."; // all manually captured sessions
		this.staticBranchDefault = "default."; // the default manual-session
		this.prefBranchSettings = "settings.";
		this.Branch = this.prefService.getBranch(this.prefBranch);
		this.settingsBranch = this.prefService.getBranch(this.prefBranch+this.prefBranchSettings);
		
		this.parentBox = document.getElementById('parentBox');
		this.checkboxAutoLoad = document.getElementById('autoload');
		this.labelAutoLoadFrom = document.getElementById('autoload-from-label');
		this.menuAutoLoadFrom = document.getElementById('autoload-from');
		this.popupAutoLoadFrom = document.getElementById('autoload-from-popup');
		this.checkboxCrashLoad = document.getElementById('crashload');
		this.labelCrashLoadWarning = document.getElementById('crashload-warning');
		this.labelOverwrite = document.getElementById('overwrite');
		this.checkboxOverwriteWindows = document.getElementById('overwritewindows');
		this.checkboxOverwriteTabs = document.getElementById('overwritetabs');
		this.checkboxConcatenate = document.getElementById('concatenate');
		this.checkboxShutdownSave = document.getElementById('shutdownsave');
		this.labelShutdownSaveTo = document.getElementById('shutdownsave-to-label');
		this.menuShutdownSaveTo = document.getElementById('shutdownsave-to');
		this.popupShutdownSaveTo = document.getElementById('shutdownsave-to-popup');
		this.checkboxFileMenu = document.getElementById('filemenu');
		
		this.setSelections();
	},
	
	setSelections: function(autoLoadBranch, shutdownSaveBranch) {
		// enable xpconnect -- anywhere!
		netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
		netscape.security.PrivilegeManager.enablePrivilege('UniversalPreferencesRead');
		// pref-selections
		var autoLoad = !this.settingsBranch.prefHasUserValue('autoload') || this.settingsBranch.getBoolPref('autoload'); // default:true
		var crashLoad = !this.settingsBranch.prefHasUserValue('crashload') || this.settingsBranch.getBoolPref('crashload'); // default:true
		var concatenate = this.settingsBranch.prefHasUserValue("concatenate") && this.settingsBranch.getBoolPref("concatenate"); // default:false
		var overwriteWindows = !this.settingsBranch.prefHasUserValue('overwritewindows') || this.settingsBranch.getBoolPref('overwritewindows'); // default:true
		var overwriteTabs = !this.settingsBranch.prefHasUserValue('overwritetabs') || this.settingsBranch.getBoolPref('overwritetabs'); // default:true
		var shutdownSave = this.settingsBranch.prefHasUserValue('shutdownsave') && this.settingsBranch.getBoolPref('shutdownsave'); // default:false
		var fileMenu = !this.settingsBranch.prefHasUserValue('filemenu') || this.settingsBranch.getBoolPref('filemenu'); // default:true
		var autoLoadBranch = (this.settingsBranch.prefHasUserValue('autoload.branch')) ? this.settingsBranch.getCharPref('autoload.branch') : this.prefBranchWindows; // default:'windows.'
		var shutdownSaveBranch = (this.settingsBranch.prefHasUserValue('shutdownsave.branch')) ? this.settingsBranch.getCharPref('shutdownsave.branch') : this.prefBranchStatic+this.staticBranchDefault; // default:'static.default.'
		this.checkboxAutoLoad.setAttribute("checked", autoLoad); // load every time
		this.checkboxConcatenate.setAttribute("checked", concatenate);
		this.checkboxCrashLoad.setAttribute("checked", crashLoad); //  
		this.checkboxOverwriteWindows.setAttribute("checked", overwriteWindows);
		this.checkboxOverwriteTabs.setAttribute("checked", overwriteTabs);
		this.checkboxShutdownSave.setAttribute("checked", shutdownSave);
		this.checkboxFileMenu.setAttribute("checked", fileMenu);
		
		// disable appropriate selection(s)
		this.checkboxOverwriteTabs.disabled = !overwriteWindows;
		
		// reveal any hidden-prefs that have been set
		//this.labelOverwrite.hidden = !this.settingsBranch.prefHasUserValue('overwritewindows'); // setAttribute("style", "visibility: visible;");
		//this.checkboxOverwriteWindows.hidden = this.labelOverwrite.hidden; // setAttribute("style", "visibility: visible;");
		//this.checkboxOverwriteTabs.hidden = this.checkboxOverwriteWindows.hidden; // setAttribute("style", "visibility: visible;");
		//this.checkboxConcatenate.hidden = !this.settingsBranch.prefHasUserValue('concatenate'); // setAttribute("style", "visibility: visible;");
		var hideAutoLoadFrom = !this.settingsBranch.prefHasUserValue('autoload.branch');
		this.labelAutoLoadFrom.hidden = hideAutoLoadFrom;
		this.menuAutoLoadFrom.hidden = hideAutoLoadFrom;
		this.labelCrashLoadWarning.hidden = hideAutoLoadFrom;
		var hideShutdownSaveTo = !this.settingsBranch.prefHasUserValue('shutdownsave.branch');
		this.labelShutdownSaveTo.hidden = hideShutdownSaveTo;
		this.menuShutdownSaveTo.hidden = hideShutdownSaveTo;
		this.checkboxFileMenu.hidden = !this.settingsBranch.prefHasUserValue('filemenu');
		
		// save original values of hidden-prefs
		this.autoLoadBranch_orig = autoLoadBranch;
		this.shutdownSaveBranch_orig = shutdownSaveBranch;
		this.fileMenu_orig = fileMenu;
		
		// set mouse-move listener for hidden-prefs
		document.getElementById("parentBox").addEventListener("mousemove", this.onMouseMove, true);
		
		this.initPopups(autoLoadBranch, shutdownSaveBranch);
	},
	
	initPopups: function(autoLoadBranch, shutdownSaveBranch) {
		// enable xpconnect -- anywhere!
		netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
		netscape.security.PrivilegeManager.enablePrivilege('UniversalPreferencesRead');
		// popup-menus' datasource
		datasource = Components.classes[DATASOURCE_CONTRACTID].createInstance(Components.interfaces.nsIRDFDataSource);
		//this.parentBox.database.AddDataSource(datasource);
		this.menuAutoLoadFrom.database.AddDataSource(datasource);
		this.menuShutdownSaveTo.database.AddDataSource(datasource);
		
		sequence = utils.MakeSeq(datasource, rdf.GetResource('urn:root:sessions'));
		
		// don't list duplicates (branches have multiple prefs)
		var sessionArray = this.Branch.getChildList(this.prefBranchStatic, {}); // array of pref-names holding custom-sessions
		sessionArray.sort(); // the ordering is initially skewed / random
		sessionArray.unshift(this.prefBranchStatic+this.staticBranchDefault+"zorder"); // always include the default branch
		var sessionString = "";
		while (sessionArray.length > 0) {
			var branch = sessionArray[0].match(/(.*\.)[^\.]+$/)[1];
			if (sessionString.indexOf(branch) == -1) 
				sessionString += (sessionString.length>0 ? " ":"")+branch;
			sessionArray.shift();
		}
		sessionArray = sessionString.split(" ");
		for (var n = 0; n < sessionArray.length; n++) {
			var resource = rdf.GetResource(sessionArray[n]);
			var sessionDescription = sessionArray[n].match(/^[^.]+\.(.*)\.$/)[1].replace(/[_]/g, " ").split(" ");
			for (var x in sessionDescription) sessionDescription[x] = sessionDescription[x].replace(/^./, sessionDescription[x].charAt(0).toUpperCase())
			sessionDescription = sessionDescription.join(" ");
			var sessionLocation = sessionArray[n];
			if (sessionLocation == autoLoadBranch) var autoLoadIndex = n+1; // +1 because we have a hardcoded menuitem, here
			if (sessionLocation == shutdownSaveBranch) var shutdownSaveIndex = n;
			datasource.Assert(resource, rdf.GetResource(prefix + 'label'), rdf.GetLiteral(sessionDescription), true);
			datasource.Assert(resource, rdf.GetResource(prefix + 'value'), rdf.GetLiteral(sessionLocation), true);
			//datasource.Assert(resource, rdf.GetResource(prefix + 'autoloadSelected'), rdf.GetLiteral(autoLoadSelected), true);
			//datasource.Assert(resource, rdf.GetResource(prefix + 'shutdownsaveSelected'), rdf.GetLiteral(shutdownSaveSelected), true);
			sequence.AppendElement(resource);
		}
		this.menuAutoLoadFrom.builder.rebuild();
		this.menuShutdownSaveTo.builder.rebuild();
		
		this.menuAutoLoadFrom.selectedIndex = (autoLoadIndex > 0) ? autoLoadIndex : 0;
		this.menuShutdownSaveTo.selectedIndex = (shutdownSaveIndex > 0) ? shutdownSaveIndex : 0;
	},
	
	// "OK" button was clicked
	onAccept: function() {
		// enable xpconnect -- anywhere!
		netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
		netscape.security.PrivilegeManager.enablePrivilege('UniversalPreferencesWrite');
		this.settingsBranch.setBoolPref("autoload", (this.checkboxAutoLoad.getAttribute("checked") == "true") ? true:false);
		this.settingsBranch.setBoolPref("crashload", (this.checkboxCrashLoad.getAttribute("checked") == "true") ? true:false);
		this.settingsBranch.setBoolPref("concatenate", (this.checkboxConcatenate.getAttribute("checked") == "true") ? true:false);
		this.settingsBranch.setBoolPref("overwritewindows", (this.checkboxOverwriteWindows.getAttribute("checked") == "true") ? true:false);
		this.settingsBranch.setBoolPref("overwritetabs", (this.checkboxOverwriteTabs.getAttribute("checked") == "true") ? true:false);
		this.settingsBranch.setBoolPref("shutdownsave", (this.checkboxShutdownSave.getAttribute("checked") == "true") ? true:false);

		// only save hidden-prefs if they've changed
		if (this.autoLoadBranch_orig != this.menuAutoLoadFrom.value)
			this.settingsBranch.setCharPref("autoload.branch", this.menuAutoLoadFrom.value);
		if (this.shutdownSaveBranch_orig != this.menuShutdownSaveTo.value)
			this.settingsBranch.setCharPref("shutdownsave.branch", this.menuShutdownSaveTo.value);
		if (this.fileMenu_orig != ((this.checkboxFileMenu.getAttribute("checked") == "true") ? true:false))
			this.settingsBranch.setBoolPref("filemenu", !this.fileMenu_orig);
		/*
		if (this.overwriteTabs_orig != ((this.checkboxOverwriteTabs.getAttribute("checked") == "true") ? true:false))
			this.settingsBranch.setBoolPref("overwritetabs", (this.checkboxOverwriteTabs.getAttribute("checked") == "true") ? true:false);
		if (this.concatenate_orig != ((this.checkboxConcatenate.getAttribute("checked") == "true") ? true:false))
			this.settingsBranch.setBoolPref("concatenate", (this.checkboxConcatenate.getAttribute("checked") == "true") ? true:false);
		*/
		
		this.prefService.savePrefFile(null); // save the prefs to disk
	},
	
	// mouse-move detected - handle hidden-prefs
	onMouseMove: function(evt) {
		// enable xpconnect -- anywhere!
		netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
		if(evt.shiftKey) {
			SessionSaverSettings.labelAutoLoadFrom.hidden = false;
			SessionSaverSettings.menuAutoLoadFrom.hidden = false;
			SessionSaverSettings.labelCrashLoadWarning.hidden = false;
			SessionSaverSettings.labelShutdownSaveTo.hidden = false;
			SessionSaverSettings.menuShutdownSaveTo.hidden = false;
			SessionSaverSettings.checkboxFileMenu.hidden = false;
			sizeToContent(); }
	}
};