/*

<!-- ****** BEGIN LICENSE BLOCK *****
Version: MPL 1.1/GPL 2.0/LGPL 2.1

The contents of this file are subject to the Mozilla Public License Version 
1.1 (the "License"); you may not use this file except in compliance with 
the License. You may obtain a copy of the License at 
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is Checky.

The Initial Developer of the Original Code is
Joachim Schreiber (yo@yos.biz).
Portions created by the Initial Developer are Copyright (C) 2002-2003
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

The Checky Plug-in is an simple Interface for Web content and 
resource developers to free and commercial online validation and analysis services. 

We do not provide any support or guarantee. 

Any rights not expressly granted herein are reserved by their owners. 
Please visit the Web Sites of Service owners for more informations 
about terms of usage before using Checky the first time. Hyperlinks are 
located at http://checky.mozdev.org/Services/.

***** END LICENSE BLOCK ***** -->

*/


// Original Code by Henrik Gemal - http://linky.mozdev.org

// product related settings
// you can change these
const myProductName = "Checky";
const myProductRegKey = "checky";
const myProductRegVersion = "1.0";
const myProductRegVersionBuild = "20030419";
const myJarFileName = "checky.jar";
const myJarFileSize = 300; // the filesize in KB of myJarFileName
const myJSFileName = "checky.js"; // the default prefs file. set it to "" if not used
const myJSFileSize = 1; // the filesize in KB of myJSFileName

// global settings
// dont change these
const sysChromeGlobal = getFolder("Chrome");
const sysChromeGlobalJar = getFolder("Chrome", myJarFileName);
const sysChromeUser = getFolder("Current User","chrome");
const sysChromeUserJar = getFolder("Current User", "chrome/" + myJarFileName);
const errPage = "http://devedge.netscape.com/library/manuals/2001/xpinstall/1.0/err.html";

// verify disk space in kilobytes
function verifyDiskSpace(dirPath, spaceRequired) {
	var spaceAvailable = fileGetDiskSpaceAvailable(dirPath);
	if (parseInt(spaceAvailable/1024) < spaceRequired) {
		logComment("Insufficient disk space: " + dirPath + "\n\trequired : " + spaceRequired + " K\n\tavailable: " + spaceAvailable + " K");
		return(false);
	} else {
		return(true);
	}
}

var inst = 1;
// inst is the installation method:
//		0 means that the installation was cancelled.
//		1 is in the global chrome folder. This *has* to be the default!
//		2 in in the personal profile folder. This is only supported for newer builds.

// Can we install in the personal profile folder?
if (buildID >= 2003030700) {
	alert("You can install " + myProductName + " " + myProductRegVersion + " in two ways:\n\n1) in the global chrome folder. This will make " + myProductName + " available in all profiles.\n\n2) in the personal profile folder. This will make " + myProductName + " available only in the current profile.\n\nYou will now be prompted to select a way...");
	var ans = confirm("Click OK to install in the global chrome folder:\n" + sysChromeGlobal + "\nThis is the recommended install option!");
	if (!ans) {
		ans = confirm("Click OK to install in your personal profile folder:\n" + sysChromeUser);
		if (!ans) {
			alert("You didn't choose any of the supported installation options!\nPlease restart the installation!");
			inst = 0;
		} else {
			inst = 2;
		}
	} else {
		inst = 1;
	}
} else {
	ans = confirm("Click OK to install " + myProductName + " " + myProductRegVersion + " in the global chrome folder:\n" + sysChromeGlobal);
	if (!ans) {
		alert("You didn't choose any of the supported installation options!\nPlease restart the installation!");
		inst = 0;
	}
}

// did the user cancel?
if (inst) {
	var err;
	var err_tmp;

	logComment(myProductName + " version " + myProductRegVersion + " being installed on " + buildID);
	logComment("Installation method is " + inst);

	// init the installation
	err_tmp = initInstall(myProductName, myProductRegKey, myProductRegVersion + "." + myProductRegVersionBuild);
	if (err_tmp) {
		err = err_tmp;
	}

	// check if there's disk space for myJSFileSize
	if (!err && !verifyDiskSpace(sysChromeGlobal,myJSFileSize)) {
		err = INSUFFICIENT_DISK_SPACE;
	}

	// check if there's disk space for myJarFileSize
	if (!err && !verifyDiskSpace((inst == 1 ? sysChromeGlobal : sysChromeUser), myJarFileSize)) {
		err = INSUFFICIENT_DISK_SPACE;
	}

	// add the default prefs, but only if we have to install into global chrome
	//if (!err && inst == 1 && myJSFileName) {
		err_tmp = addFile(myProductName, myJSFileName, getFolder("Program","defaults/pref"), myJSFileName);
		if (err_tmp) {
			logComment("Problem adding the pref defaults to: " + getFolder("Program", "defaults/pref") + "\n\tError code: " + err_tmp);
			err = err_tmp;
		}
	//}
	
	// add the jar file
	if (!err) {
		if (inst == 2) {
			err_tmp = addFile(myProductName, myJarFileName, sysChromeUser, "");
		} else {
			err_tmp = addFile(myProductName, myJarFileName, sysChromeGlobal, "");
		}
		if (err_tmp) {
			logComment("Problem adding jar file. Error code: " + err_tmp);
			err = err_tmp;
		}
	}
		
	// register the content
	if (!err) {
		if (inst == 2) {
			err_tmp = registerChrome(CONTENT | PROFILE_CHROME, sysChromeUserJar, "content/" + myProductRegKey + "/");
		} else {
			err_tmp = registerChrome(CONTENT | DELAYED_CHROME, sysChromeGlobalJar, "content/" + myProductRegKey + "/");
		}
		if (err_tmp) {
			logComment("Problem registering the content chrome. Error code: " + err_tmp);
			err = err_tmp;
		}
	}
	
	// register the locale
	if (!err) {
		if (inst == 2) {
			err_tmp = registerChrome(LOCALE | PROFILE_CHROME, sysChromeUserJar, "locale/en-US/" + myProductRegKey + "/");
			err_tmp = registerChrome(LOCALE | PROFILE_CHROME, sysChromeUserJar, "locale/en/" + myProductRegKey + "/");
			err_tmp = registerChrome(LOCALE | PROFILE_CHROME, sysChromeUserJar, "locale/de/" + myProductRegKey + "/");
			err_tmp = registerChrome(LOCALE | PROFILE_CHROME, sysChromeUserJar, "locale/de-AT/" + myProductRegKey + "/");
			err_tmp = registerChrome(LOCALE | PROFILE_CHROME, sysChromeUserJar, "locale/de-DE/" + myProductRegKey + "/");
		} else {
			err_tmp = registerChrome(LOCALE | DELAYED_CHROME, sysChromeGlobalJar, "locale/en-US/" + myProductRegKey + "/");
			err_tmp = registerChrome(LOCALE | DELAYED_CHROME, sysChromeGlobalJar, "locale/en/" + myProductRegKey + "/");
			err_tmp = registerChrome(LOCALE | DELAYED_CHROME, sysChromeGlobalJar, "locale/de/" + myProductRegKey + "/");
			err_tmp = registerChrome(LOCALE | DELAYED_CHROME, sysChromeGlobalJar, "locale/de-AT/" + myProductRegKey + "/");
			err_tmp = registerChrome(LOCALE | DELAYED_CHROME, sysChromeGlobalJar, "locale/de-DE/" + myProductRegKey + "/");
		}
		if (err_tmp) {
			logComment("Problem registering the locale chrome. Error code: " + err_tmp);
			err = err_tmp;
		}
	}
	
	// do the install
	if (!err) {
		err_tmp = performInstall();
		if (err_tmp < 0) {
			logComment("Problem performing install. Error code: " + err_tmp);
			err = err_tmp;
		} else {
			alert(myProductName + " " + myProductRegVersion + " has been successfully installed!\nWhen you right-click on a webpage your will now have a new context menuitem called " + myProductName + "!\n\nYou must restart your browser to complete installation!");
		}
	}
		
	// did it work?
	if (err) {
		logComment("Problem installing. Error code: " + err + ". Error codes can been seen at: " + errPage);
		alert(myProductName + " " + myProductRegVersion + " was not installed!\nError code: " + err + "\n\nError codes can been seen at:\n" + errPage)
		cancelInstall(err);
	}
} else {
	cancelInstall();
}
