/* ***** BEGIN LICENSE BLOCK *****
* Version: MPL 1.1/GPL 2.0/LGPL 2.1
*
* The contents of this file are subject to the Mozilla Public License Version
* 1.1 (the "License"); you may not use this file except in compliance with
* the License. You may obtain a copy of the License at
* http://www.mozilla.org/MPL/
*
* Software distributed under the License is distributed on an "AS IS" basis,
* WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
* for the specific language governing rights and limitations under the
* License.
*
* The Original Code is:
* Ident - a Chatzilla plugin that manages your Nickserv passwords.
*
* The Initial Developers of the Original Code are:
* Glen Mailer <glenjamin@gmail.com>
*
* Portions created by Glen Mailer are Copyright (C) 2004
* Glen Mailer. All Rights Reserved.
*
*
* Alternatively, the contents of this file may be used under the terms of
* either the GNU General Public License Version 2 or later (the "GPL"), or
* the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
* in which case the provisions of the GPL or the LGPL are applicable instead
* of those above. If you wish to allow use of your version of this file only
* under the terms of either the GPL or the LGPL, and not to allow others to
* use your version of this file under the terms of the MPL, indicate your
* decision by deleting the provisions above and replace them with the notice
* and other provisions required by the LGPL or the GPL. If you do not delete
* the provisions above, a recipient may use your version of this file under
* the terms of any one of the MPL, the GPL or the LGPL.
*

****** END LICENSE BLOCK ***** */

/*
 * Plugin Created by ReadMe <glenjamin[at]gmail.com>
 * Can usually be found in irc://irc.moznet.org/chatzilla
 *
 *
 */

plugin.id = "AutoIdent";

var myprefs = [
["passwords", "", ""],
];
var passwords;

plugin.init =
function init(glob)
{
    /* This function will be called when chatzilla first loads the plugin.
     * We initialize some of the plugin object's properties, define a new
     * command and some new prefs, and print out a message.
     */
    plugin.major = 1;
    plugin.minor = 0;
    plugin.version = plugin.major + "." + plugin.minor;
    plugin.description = "Stores your nickserv passwords and identifies you"
    plugin.prefary = plugin.prefary.concat(myprefs);

}

plugin.disable =
function disable()
{

    uncmdary = [
        {name: 'ident'},
        {name: 'ident-list'},
        {name: 'ident-clear'},
        {name: 'ident-show'},
        {name: 'ident-send'},
        {name: 'ident-del'},
    ]

    client.commandManager.removeCommands(uncmdary);
    client.eventPump.removeHookByName('my-nick-hook');

    display(plugin.id+' plugin disabled');

    return true;
}

plugin.enable =
function enable()
{

    patterns = [
        {set:"network", type:"nick"},
        {set:"network", type:"001"},
    ];
    client.eventPump.addHook(patterns, sendIdent, "my-nick-hook");


    var cmdary =
    [/* comand name     function               flags            usage*/
     ["ident",          setIdentPass,          null,            "<password>"],
     ["ident-clear",    clearIdents,           null,            ""],
     ["ident-list",     listIdents,            null,            ""],
     ["ident-show",     showIdent,             null,            "[<named-network>]"],
     ["ident-send",     sendIdent,             null,            ""],
     ["ident-del",      delIdent,              null,            "[<named-network>]"],
    ]

    client.commandManager.defineCommands(cmdary);

    if(plugin.prefs['passwords']!="") {
        passwords = eval(plugin.prefs['passwords']);
    } else {
        passwords = {};
    }

    display(plugin.id+' plugin enabled');
    listIdents();


    return true;
}

function saveIdents() {

    plugin.prefs['passwords'] = uneval(passwords);
    display('Passwords pref updated');

}

function sendIdent(e) {
try {
    if(!e.networkName) {
        if (e.destObject.TYPE == 'IRCNetwork') {
            e.networkName = e.destObject.viewName;
        } else {
            client.display('Failed to send ident - network not found','ERROR');
            return;
        }
    }

     if(e.networkName in passwords) {

        var nickserv = new CIRCUser(e.server,'nickserv');

        if(nickserv.TYPE == 'IRCUser') {
            nickserv.say('identify '+passwords[e.networkName]);
            display("Sent password \x02"+passwords[e.networkName]+"\x02 to NickServ on \x02"+e.networkName);
        }

    }
} catch(ex) {

	client.display('Error in hook: '+ex,'ERROR');

}
}

function listIdents() {

    for (var network in passwords) {

        var shown = true;
        dispatch("ident-show", {namedNetwork: network});

    }
    if (!shown) display('No Nickserv passwords Found');
}

function showIdent(e) {

    if(!e.namedNetwork) e.namedNetwork = e.networkName;

    if(e.namedNetwork in passwords)
        display("Nickserv identify password for \x02"+e.namedNetwork+"\x02 is \x02"+passwords[e.namedNetwork]);
    else
        display("No Nickserv password found for \x02"+e.namedNetwork);
}

function delIdent(e) {

    if(!e.namedNetwork) e.namedNetwork = e.networkName;

    if(e.namedNetwork in passwords) {
        delete passwords[e.namedNetwork];
        display("Nickserv password for \x02"+e.namedNetwork+"\x02 has been deleted");
        saveIdents();
     } else
        display("No Nickserv password found for \x02"+e.namedNetwork);
}

function clearIdents() {

    passwords = {};
    display('All passwords cleared');
    saveIdents();

}

function setIdentPass(e) {

    passwords[e.networkName] = e.password;

    display("Nickserv password for \x02"+e.networkName+"\x02 set to \x02"+e.password);

    dispatch("ident-send");

    saveIdents();

}
