/*$Id: fkHttpChannel.cpp,v 1.10 2006/08/20 16:39:54 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#include "nsCOMPtr.h"
#include "nsXPCOM.h"
#include "nsISupportsImpl.h"
#include "nsIURI.h"
#include "nsEmbedString.h"

#include "fkRule.h"
#include "fkHttpChannel.h"
#include "fkStreamListener.h"
#include "Firekeeper.h"

fkHttpChannel::fkHttpChannel(nsIChannel *origChannel, fkISentence *sentence, 
			     ActiveRuleSet *connRules)
{
	TRACE("constructor %08x", this);
	nsresult rv;
	
	this->origChannel = origChannel;
	this->sentence = sentence;
	this->connRules = connRules;
	
	origRequest = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsIRequest");
	
	origHttpChannel = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsIHttpChannel");

	origRequestObserver = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsIRequestObserver");

	origStreamListener = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsIStreamListener");

	origCachingChannel = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsICachingChannel");

	origUploadChannel = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsIUploadChannel");

	origCacheListener = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsICacheListener");

	origEncodedChannel = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsIEncodedChannel");

	origHttpChannelInternal = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsIHttpChannelInternal");

	origTransportEventSink = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsITransportEventSink");

	origResumableChannel = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsIResumableChannel");

	origSupportsPriority = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsISupportsPriority");

	origProtocolProxyCallback = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsIProtocolProxyCallback");

	origPropertyBag = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsIPropertyBag");

	origPropertyBag2 = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsIPropertyBag2");

	origWritablePropertyBag = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsIWritablePropertyBag");

	origWritablePropertyBag2 = do_QueryInterface(origChannel, &rv); 
	checkResult(rv, "nsIWritablePropertyBag2");	

	
}

fkHttpChannel::~fkHttpChannel()
{
	TRACE("destructor %08x", this);
}

NS_IMPL_ADDREF(fkHttpChannel)
NS_IMPL_RELEASE(fkHttpChannel)


NS_INTERFACE_MAP_BEGIN(fkHttpChannel)
    NS_INTERFACE_MAP_ENTRY(nsIRequest)
    NS_INTERFACE_MAP_ENTRY(nsIChannel)
    NS_INTERFACE_MAP_ENTRY(nsIRequestObserver)
    NS_INTERFACE_MAP_ENTRY(nsIStreamListener)
    NS_INTERFACE_MAP_ENTRY(nsIHttpChannel)
    NS_INTERFACE_MAP_ENTRY(nsICachingChannel)
    NS_INTERFACE_MAP_ENTRY(nsIUploadChannel)
    NS_INTERFACE_MAP_ENTRY(nsICacheListener)
    NS_INTERFACE_MAP_ENTRY(nsIEncodedChannel)
    NS_INTERFACE_MAP_ENTRY(nsIHttpChannelInternal)
    NS_INTERFACE_MAP_ENTRY(nsIResumableChannel)
    NS_INTERFACE_MAP_ENTRY(nsITransportEventSink)
    NS_INTERFACE_MAP_ENTRY(nsISupportsPriority)
    NS_INTERFACE_MAP_ENTRY(nsIProtocolProxyCallback)
	
    NS_INTERFACE_MAP_ENTRY(nsIWritablePropertyBag)
    NS_INTERFACE_MAP_ENTRY_AMBIGUOUS(nsIPropertyBag, nsIWritablePropertyBag)
    NS_INTERFACE_MAP_ENTRY_AMBIGUOUS(nsISupports, nsIWritablePropertyBag)
    NS_INTERFACE_MAP_ENTRY(nsIPropertyBag2)
    NS_INTERFACE_MAP_ENTRY(nsIWritablePropertyBag2)
NS_INTERFACE_MAP_END


//-----------------------------------------------------------------------------
// fkHttpChannel::nsIRequest
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpChannel::GetName(nsACString &aName)
{
	return origRequest->GetName(aName);
}

NS_IMETHODIMP
fkHttpChannel::IsPending(PRBool *value)
{
	return origRequest->IsPending(value);
}

NS_IMETHODIMP
fkHttpChannel::GetStatus(nsresult *aStatus)
{	
	TRACE("");
	return origRequest->GetStatus(aStatus);
}

NS_IMETHODIMP
fkHttpChannel::Cancel(nsresult status)
{
	return origRequest->Cancel(status);
}

NS_IMETHODIMP
fkHttpChannel::Suspend()
{
	return origRequest->Suspend();
}

NS_IMETHODIMP
fkHttpChannel::Resume()
{
	return origRequest->Resume();
}

NS_IMETHODIMP
fkHttpChannel::GetLoadGroup(nsILoadGroup **aLoadGroup)
{
	return origRequest->GetLoadGroup(aLoadGroup);
}

NS_IMETHODIMP
fkHttpChannel::SetLoadGroup(nsILoadGroup *aLoadGroup)
{
	return origRequest->SetLoadGroup(aLoadGroup);
}

NS_IMETHODIMP
fkHttpChannel::GetLoadFlags(nsLoadFlags *aLoadFlags)
{
	return origRequest->GetLoadFlags(aLoadFlags);
}

NS_IMETHODIMP
fkHttpChannel::SetLoadFlags(nsLoadFlags aLoadFlags)
{
	return origRequest->SetLoadFlags(aLoadFlags);
}

//-----------------------------------------------------------------------------
// fkHttpChannel::nsIChannel
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpChannel::GetOriginalURI(nsIURI **originalURI)
{
	return origChannel->GetOriginalURI(originalURI);
}

NS_IMETHODIMP
fkHttpChannel::SetOriginalURI(nsIURI *originalURI)
{
	return origChannel->SetOriginalURI(originalURI);
}

NS_IMETHODIMP
fkHttpChannel::GetURI(nsIURI **URI)
{
	return origChannel->GetURI(URI);
}

NS_IMETHODIMP
fkHttpChannel::GetOwner(nsISupports **owner)
{
	return origChannel->GetOwner(owner);
}

NS_IMETHODIMP
fkHttpChannel::SetOwner(nsISupports *owner)
{
	return origChannel->SetOwner(owner);
}

NS_IMETHODIMP
fkHttpChannel::GetNotificationCallbacks(nsIInterfaceRequestor **callbacks)
{
	return origChannel->GetNotificationCallbacks(callbacks);
}

NS_IMETHODIMP
fkHttpChannel::SetNotificationCallbacks(nsIInterfaceRequestor *callbacks)
{
	return origChannel->SetNotificationCallbacks(callbacks);
}

NS_IMETHODIMP
fkHttpChannel::GetSecurityInfo(nsISupports **securityInfo)
{
	return origChannel->GetSecurityInfo(securityInfo);
}

NS_IMETHODIMP
fkHttpChannel::GetContentType(nsACString &value)
{

	int action;
	sentence->GetAction(&action);
	TRACE("action = %d", action);
	return origChannel->GetContentType(value);
#if 0	
	if (0 || action == sentence->CANCEL){
		value = nsEmbedCString("text/html");
		return NS_OK;
	}
	else{
		nsEmbedCString s;
		origChannel->GetContentType(s);
		TRACE("%s", s.get());
		value = s;
		return NS_OK;
	}
#endif
}

NS_IMETHODIMP
fkHttpChannel::SetContentType(const nsACString &value)
{
	TRACE("");
	return origChannel->SetContentType(value);
}

NS_IMETHODIMP
fkHttpChannel::GetContentCharset(nsACString &value)
{
	TRACE("");
	return origChannel->GetContentCharset(value);
}

NS_IMETHODIMP
fkHttpChannel::SetContentCharset(const nsACString &value)
{
	TRACE("");
	return origChannel->SetContentCharset(value);
}

NS_IMETHODIMP
fkHttpChannel::GetContentLength(PRInt32 *value)
{
	return origChannel->GetContentLength(value);
}

NS_IMETHODIMP
fkHttpChannel::SetContentLength(PRInt32 value)
{
	return origChannel->SetContentLength(value);
}

NS_IMETHODIMP
fkHttpChannel::Open(nsIInputStream **_retval)
{
	TRACE("Not tracing Open calls");
	return origChannel->Open(_retval);
}

NS_IMETHODIMP
fkHttpChannel::AsyncOpen(nsIStreamListener *listener, nsISupports *context)
{	
	TRACE("");
	
	int action;
	sentence->GetAction(&action);
	if (action == sentence->BLOCK)
		return NS_ERROR_ABORT;
	if (action == sentence->DONT_AUDIT)		
		return origChannel->AsyncOpen(listener, context);

	fkStreamListener *fklistener_raw = 
		new fkStreamListener(listener, this, sentence, connRules);
	
	if (!fklistener_raw)
		return NS_ERROR_OUT_OF_MEMORY;

	nsCOMPtr<nsIStreamListener> fklistener;
	nsresult rv = fklistener_raw->QueryInterface(NS_GET_IID(nsIStreamListener), 
						     getter_AddRefs(fklistener));
	if (NS_FAILED(rv))
		return rv;
	
	return origChannel->AsyncOpen(fklistener, context);
}

//-----------------------------------------------------------------------------
// fkHttpChannel::nsIHttpChannel
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpChannel::GetRequestMethod(nsACString &method)
{
	return origHttpChannel->GetRequestMethod(method);
}

NS_IMETHODIMP
fkHttpChannel::SetRequestMethod(const nsACString &method)
{
	return origHttpChannel->SetRequestMethod(method);
}

NS_IMETHODIMP
fkHttpChannel::GetReferrer(nsIURI **referrer)
{
	return origHttpChannel->GetReferrer(referrer);
}

NS_IMETHODIMP
fkHttpChannel::SetReferrer(nsIURI *referrer)
{
	return origHttpChannel->SetReferrer(referrer);
}

NS_IMETHODIMP
fkHttpChannel::GetRequestHeader(const nsACString &header, nsACString &value)
{
	TRACE("");
	return origHttpChannel->GetRequestHeader(header, value);
}

NS_IMETHODIMP
fkHttpChannel::SetRequestHeader(const nsACString &header,
                                const nsACString &value,
                                PRBool merge)
{
	return origHttpChannel->SetRequestHeader(header, value, merge);
}

NS_IMETHODIMP
fkHttpChannel::VisitRequestHeaders(nsIHttpHeaderVisitor *visitor)
{
	TRACE("");
	return origHttpChannel->VisitRequestHeaders(visitor);
}


NS_IMETHODIMP
fkHttpChannel::GetResponseStatus(PRUint32 *value)
{
	return origHttpChannel->GetResponseStatus(value);
}

NS_IMETHODIMP
fkHttpChannel::GetResponseStatusText(nsACString &value)
{
	return origHttpChannel->GetResponseStatusText(value);
}

NS_IMETHODIMP
fkHttpChannel::GetRequestSucceeded(PRBool *value)
{
	return origHttpChannel->GetRequestSucceeded(value);
}

NS_IMETHODIMP
fkHttpChannel::GetResponseHeader(const nsACString &header, nsACString &value)
{
	TRACE("");
	return origHttpChannel->GetResponseHeader(header, value);
}

NS_IMETHODIMP
fkHttpChannel::SetResponseHeader(const nsACString &header,
                                 const nsACString &value,
                                 PRBool merge)
{
	TRACE("");
	return origHttpChannel->SetResponseHeader(header, value, merge);
}

NS_IMETHODIMP
fkHttpChannel::VisitResponseHeaders(nsIHttpHeaderVisitor *visitor)
{
	return origHttpChannel->VisitResponseHeaders(visitor);
}

NS_IMETHODIMP
fkHttpChannel::IsNoStoreResponse(PRBool *value)
{
	return origHttpChannel->IsNoStoreResponse(value);
}

NS_IMETHODIMP
fkHttpChannel::IsNoCacheResponse(PRBool *value)
{
	return origHttpChannel->IsNoCacheResponse(value);
}

NS_IMETHODIMP
fkHttpChannel::GetAllowPipelining(PRBool *value)
{
	return origHttpChannel->GetAllowPipelining(value);
}

NS_IMETHODIMP
fkHttpChannel::SetAllowPipelining(PRBool value)
{
	return origHttpChannel->SetAllowPipelining(value);
}

NS_IMETHODIMP
fkHttpChannel::GetRedirectionLimit(PRUint32 *value)
{
	return origHttpChannel->GetRedirectionLimit(value);
}

NS_IMETHODIMP
fkHttpChannel::SetRedirectionLimit(PRUint32 value)
{
	return origHttpChannel->SetRedirectionLimit(value);
}

//-----------------------------------------------------------------------------
// fkHttpChannel::nsIEncodedChannel
//-----------------------------------------------------------------------------
NS_IMETHODIMP
fkHttpChannel::GetContentEncodings(nsIUTF8StringEnumerator** aEncodings)
{
	TRACE("");
	return origEncodedChannel->GetContentEncodings(aEncodings);
}

NS_IMETHODIMP
fkHttpChannel::GetApplyConversion(PRBool *value)
{
	return origEncodedChannel->GetApplyConversion(value);
}


NS_IMETHODIMP
fkHttpChannel::SetApplyConversion(PRBool value)
{
	return origEncodedChannel->SetApplyConversion(value);
}

//-----------------------------------------------------------------------------
// fkHttpChannel::nsIUploadChannel
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpChannel::GetUploadStream(nsIInputStream **stream)
{
	return origUploadChannel->GetUploadStream(stream);
}



NS_IMETHODIMP
fkHttpChannel::SetUploadStream(nsIInputStream *stream, 
			       const nsACString &contentType, PRInt32 contentLength)
{
	return origUploadChannel->SetUploadStream(stream, contentType, contentLength);
}

//-----------------------------------------------------------------------------
// fkHttpChannel::nsIHttpChannelInternal
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpChannel::GetDocumentURI(nsIURI **aDocumentURI)
{
	return origHttpChannelInternal->GetDocumentURI(aDocumentURI);
}

NS_IMETHODIMP
fkHttpChannel::SetDocumentURI(nsIURI *aDocumentURI)
{
	return origHttpChannelInternal->SetDocumentURI(aDocumentURI);
}

NS_IMETHODIMP
fkHttpChannel::GetRequestVersion(PRUint32 *major, PRUint32 *minor)
{
	return origHttpChannelInternal->GetRequestVersion(major, minor);
}

NS_IMETHODIMP
fkHttpChannel::GetResponseVersion(PRUint32 *major, PRUint32 *minor)
{
	return origHttpChannelInternal->GetResponseVersion(major, minor);
}

NS_IMETHODIMP
fkHttpChannel::SetCookie(const char *aCookieHeader)
{
	return origHttpChannelInternal->SetCookie(aCookieHeader);
}

NS_IMETHODIMP
fkHttpChannel::GetProxyInfo(nsIProxyInfo **result)
{
	return origHttpChannelInternal->GetProxyInfo(result);
}

//-----------------------------------------------------------------------------
// fkHttpChannel::nsISupportsPriority
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpChannel::GetPriority(PRInt32 *value)
{
	return origSupportsPriority->GetPriority(value);
}

NS_IMETHODIMP
fkHttpChannel::SetPriority(PRInt32 value)
{
	return origSupportsPriority->SetPriority(value);
}

NS_IMETHODIMP
fkHttpChannel::AdjustPriority(PRInt32 delta)
{
	return origSupportsPriority->AdjustPriority(delta);
}

//-----------------------------------------------------------------------------
// fkHttpChannel::nsIProtocolProxyCallback
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpChannel::OnProxyAvailable(nsICancelable *request, nsIURI *uri,
                                nsIProxyInfo *pi, nsresult status)
{
	return origProtocolProxyCallback->OnProxyAvailable(request, uri,
							   pi, status);
}

//-----------------------------------------------------------------------------
// fkHttpChannel::nsIRequestObserver
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpChannel::OnStartRequest(nsIRequest *request, nsISupports *ctxt)
{
	TRACE("");
	return origRequestObserver->OnStartRequest(request, ctxt);
}

NS_IMETHODIMP
fkHttpChannel::OnStopRequest(nsIRequest *request, nsISupports *ctxt, nsresult status)
{
	TRACE("");
	return origRequestObserver->OnStopRequest(request, ctxt, status);
}

//-----------------------------------------------------------------------------
// fkHttpChannel::nsIStreamListener
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpChannel::OnDataAvailable(nsIRequest *request, nsISupports *ctxt,
                               nsIInputStream *input,
                               PRUint32 offset, PRUint32 count)
{
	TRACE("");
	return origStreamListener->OnDataAvailable(request, ctxt, input,
						   offset, count);
}

//-----------------------------------------------------------------------------
// fkHttpChannel::nsITransportEventSink
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpChannel::OnTransportStatus(nsITransport *trans, nsresult status,
                                 PRUint64 progress, PRUint64 progressMax)
{
	return origTransportEventSink->OnTransportStatus(trans, status, progress,
							 progressMax);
} 

//-----------------------------------------------------------------------------
// fkHttpChannel::nsICachingChannel
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpChannel::GetCacheToken(nsISupports **token)
{
	return origCachingChannel->GetCacheToken(token);
}

NS_IMETHODIMP
fkHttpChannel::SetCacheToken(nsISupports *token)
{
	return origCachingChannel->SetCacheToken(token);
}

NS_IMETHODIMP
fkHttpChannel::GetCacheKey(nsISupports **key)
{
	return origCachingChannel->GetCacheKey(key);
}

NS_IMETHODIMP
fkHttpChannel::SetCacheKey(nsISupports *key)
{
	return origCachingChannel->SetCacheKey(key);
}

NS_IMETHODIMP
fkHttpChannel::GetCacheAsFile(PRBool *value)
{
	return origCachingChannel->GetCacheAsFile(value);
}

NS_IMETHODIMP
fkHttpChannel::SetCacheAsFile(PRBool value)
{
	return origCachingChannel->SetCacheAsFile(value);
}

NS_IMETHODIMP
fkHttpChannel::GetCacheFile(nsIFile **cacheFile)
{
	return origCachingChannel->GetCacheFile(cacheFile);
}

NS_IMETHODIMP
fkHttpChannel::IsFromCache(PRBool *value)
{
	return origCachingChannel->IsFromCache(value);
}

//-----------------------------------------------------------------------------
// fkHttpChannel::nsIResumableChannel
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpChannel::ResumeAt(PRUint64 aStartPos,
                        const nsACString& aEntityID)
{
	return origResumableChannel->ResumeAt(aStartPos,aEntityID);
}

NS_IMETHODIMP
fkHttpChannel::GetEntityID(nsACString& aEntityID)
{
	return origResumableChannel->GetEntityID(aEntityID);
}

//-----------------------------------------------------------------------------
// fkHttpChannel::nsICacheListener
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpChannel::OnCacheEntryAvailable(nsICacheEntryDescriptor *entry,
                                     nsCacheAccessMode access,
                                     nsresult status)
{
	return origCacheListener->OnCacheEntryAvailable(entry, access, status);
}

/*
void
fkHttpChannel::ClearPasswordManagerEntry(const char      *scheme,
                                         const char      *host,
                                         PRInt32          port,
                                         const char      *realm,
                                         const PRUnichar *user)
{
	return origCacheListener->ClearPasswordManagerEntry(scheme, host, port,
							    realm, user);
}

nsresult
fkHttpChannel::DoAuthRetry(nsAHttpConnection *conn)
{
	return origCacheListener->DoAuthRetry(conn);
}
*/



//-----------------------------------------------------------------------------
// fkHttpChannel::nsIPropertyBag
//-----------------------------------------------------------------------------

NS_IMETHODIMP
fkHttpChannel::GetProperty(const nsAString& name, nsIVariant* *_retval)
{
    return origPropertyBag->GetProperty(name, _retval);
}

NS_IMETHODIMP
fkHttpChannel::GetEnumerator(nsISimpleEnumerator* *_retval)
{
	return origPropertyBag->GetEnumerator(_retval);
}

//-----------------------------------------------------------------------------
// fkHttpChannel::nsIWritablePropertyBag
//-----------------------------------------------------------------------------
NS_IMETHODIMP
fkHttpChannel::SetProperty(const nsAString& name, nsIVariant *value)
{
	return origWritablePropertyBag->SetProperty(name, value);
}

NS_IMETHODIMP
fkHttpChannel::DeleteProperty(const nsAString& name)
{
	return origWritablePropertyBag->DeleteProperty(name);
}

//-----------------------------------------------------------------------------
// fkHttpChannel::nsIPropertyBag2 && fkHttpChannel::nsIWritablePropertyBag2
//-----------------------------------------------------------------------------
#define IMPL_GETSETPROPERTY_AS(Name, Type) \
NS_IMETHODIMP \
fkHttpChannel::GetPropertyAs ## Name (const nsAString & prop, Type *_retval) \
{ \
    return origPropertyBag2->GetPropertyAs ## Name(prop, _retval); \
} \
\
NS_IMETHODIMP \
fkHttpChannel::SetPropertyAs ## Name (const nsAString & prop, Type value) \
{ \
    return origWritablePropertyBag2->SetPropertyAs ## Name(prop, value); \
}

IMPL_GETSETPROPERTY_AS(Bool, PRBool)
IMPL_GETSETPROPERTY_AS(Double, double)
IMPL_GETSETPROPERTY_AS(Int32, PRInt32)
IMPL_GETSETPROPERTY_AS(Int64, PRInt64)
IMPL_GETSETPROPERTY_AS(Uint32, PRUint32)
IMPL_GETSETPROPERTY_AS(Uint64, PRUint64)

NS_IMETHODIMP
fkHttpChannel::GetPropertyAsAString(const nsAString & prop, nsAString &_retval)
{
	return origPropertyBag2->GetPropertyAsAString(prop, _retval);
}

NS_IMETHODIMP
fkHttpChannel::GetPropertyAsACString(const nsAString & prop, nsACString &_retval)
{
	return origPropertyBag2->GetPropertyAsACString(prop, _retval);
}

NS_IMETHODIMP
fkHttpChannel::GetPropertyAsAUTF8String(const nsAString & prop, nsACString &_retval)
{
	return origPropertyBag2->GetPropertyAsAUTF8String(prop, _retval);
}

NS_IMETHODIMP
fkHttpChannel::GetPropertyAsInterface(const nsAString & prop,
                                          const nsIID & aIID,
                                          void** _retval)
{
	return origPropertyBag2->GetPropertyAsInterface(prop, aIID, _retval);
}


NS_IMETHODIMP
fkHttpChannel::SetPropertyAsAString(const nsAString & prop, const nsAString & value)
{
	return origWritablePropertyBag2->SetPropertyAsAString(prop, value);
}

NS_IMETHODIMP
fkHttpChannel::SetPropertyAsACString(const nsAString & prop, const nsACString & value)
{
	return origWritablePropertyBag2->SetPropertyAsACString(prop, value);
}

NS_IMETHODIMP
fkHttpChannel::SetPropertyAsAUTF8String(const nsAString & prop, const nsACString & value)
{
	return origWritablePropertyBag2->SetPropertyAsAUTF8String(prop, value);
}

NS_IMETHODIMP
fkHttpChannel::SetPropertyAsInterface(const nsAString & prop, nsISupports* value)
{
	return origWritablePropertyBag2->SetPropertyAsInterface(prop, value);
}

