/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.classes;

import javax.swing.*;
import java.awt.event.*;
import javax.swing.filechooser.FileFilter;
import java.io.File;

import org.mozdev.firebirdhelp.HelpViewer.*;

import org.mozdev.MacroTracker.ui.frmAbout;
import org.mozdev.MacroTracker.toolkit.MenuItem;

import com.trfenv.rlk.Debug;

/**
 *This is MacroTracker's utility classes that generates components that should
 *be standardized, such as the Help Menu and the FileFilter.
 *
 *<p>None of the components returned by these methods should be modified in any
 *way after being returned.</p>
 *
 *@author R.J. Keller <rlk@trfenv.com>
 */
public final class StandardComponents
{
	/**
	 *Returns the MacroTracker help menu with all menu items added and ready
	 *to be used.
	 */
	public static JMenu generateHelpMenu()
	{
		JMenu mnuHelp = new JMenu("Help");
		
		MenuItem mnuHelpContents = new MenuItem("Contents...", "/images/ContextualHelp16.gif");
		MenuItem mnuHelpAbout = new MenuItem("About MacroTracker...");
		
		mnuHelpContents.setMnemonic('C');
		mnuHelpAbout.setMnemonic('A');
		
		mnuHelpContents.addActionListener(
			new ActionListener()
			{
				public void actionPerformed(ActionEvent e)
				{
					//help topics available.
					iHelpTopic product = new HelpTree("Products", "/help/product.htm");
					iHelpTopic databaseCreation = new HelpTree("Database Creation", "/help/database-creation.hm");

					//Make the help TOC.
					iHelpTopic helpTOC = new HelpTree("MacroTracker Help", "/help/index.htm");
					helpTOC.addSubTopic(databaseCreation);
					helpTOC.addSubTopic(product);
					
					//Make the help index
					iHelpTopic helpIndex = new HelpTree("Index (coming soon)", "");
					
					//Make the help glossary
					iHelpTopic helpGlossary = new HelpTree("Glossary", "/help/glossary.xhtml");
					
					try
					{
						//merge them all together and open the help viewer.
						HelpViewer help = new HelpViewer(new HelpContent("MacroTracker Help", helpTOC, helpIndex, helpGlossary));
					}
					catch (Exception ex)
					{
						Debug.printException(ex);
					}
				}
			}
			);
		
		mnuHelpAbout.addActionListener(
		  new ActionListener()
		  {
		    public void actionPerformed(ActionEvent event)
		    {
		      frmAbout aboutForm = new frmAbout();
		      aboutForm.setVisible( true );
		    }
		  });
		
		mnuHelp.add(mnuHelpContents);
		mnuHelp.addSeparator();
		mnuHelp.add(mnuHelpAbout);

		return mnuHelp;
	}
	
	/**
	 *Creates a FileFilter that will contain all supported Database formats by
	 *MacroTracker to be used in a JFileChooser dialog.
	 */
	public static FileFilter generateFileFilter()
	{
		return new MacroTrackerFileFilter();
	}
}

class MacroTrackerFileFilter extends FileFilter
{
	public boolean accept(File f)
	{
		return f.isDirectory() || f.getName().toLowerCase().endsWith(".mtd");
	}
	
	public String getDescription()
	{
		return "MacroTracker Database Files (*.mtd)";
	}
}
