!define NAME "PortableThunderbird"
!define APP "Thunderbird"
!define VER "1.0.9"
!define WEBSITE "portablethunderbird.mozdev.org"
!define DEFAULTEXE "thunderbird.exe"

;=== Program Details
Name "${NAME}"
OutFile "${NAME}.exe"
Caption "${NAME} - You CAN Take It With You"
VIProductVersion "${VER}.0"
VIAddVersionKey FileDescription "${NAME} Launcher runs ${APP} from a removable drive"
VIAddVersionKey LegalCopyright "GPL"
VIAddVersionKey Comments "This launcher allows ${APP} to be run from a removable drive.  For additional details, visit ${WEBSITE}"
VIAddVersionKey CompanyName "by John T. Haller et al"
VIAddVersionKey OriginalFilename "${NAME}.exe"
VIAddVersionKey FileVersion "${VER}"

;=== Runtime switches
CRCCheck On
WindowIcon Off
SilentInstall Silent
AutoCloseWindow True

;=== Program Icon
Icon "${APP}.ico"

;=== Path variables
Var PROGRAMDIRECTORY
Var PROFILEDIRECTORY
Var PLUGINSDIRECTORY
Var ADDITIONALPARAMETERS
Var ALLOWMULTIPLEINSTANCES
Var SKIPCHROMEFIX
Var SKIPCOMPREGFIX
Var EXECSTRING
Var WAITFORPROGRAM
Var PROGRAMEXECUTABLE
Var INIPATH


Section "Main"
	;=== Get the path information from the INI file
	IfFileExists "$EXEDIR\${NAME}.ini" FoundStandardINI CheckSubINI

	FoundStandardINI:
		StrCpy "$INIPATH" "$EXEDIR\"
		Goto ReadINI

	CheckSubINI:
		IfFileExists "$EXEDIR\${NAME}\${NAME}.ini" FoundSubINI CheckSubSubINI

	FoundSubINI:
		StrCpy "$INIPATH" "$EXEDIR\${NAME}\"
		Goto ReadINI

	CheckSubSubINI:
		IfFileExists "$EXEDIR\PortableApps\${NAME}\${NAME}.ini" FoundSubSubINI NoINI

	FoundSubSubINI:
		StrCpy "$INIPATH" "$EXEDIR\PortableApps\${NAME}\"
		Goto ReadINI

	ReadINI:
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "${APP}Directory"
		StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\$0"
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "ProfileDirectory"
		StrCpy "$PROFILEDIRECTORY" "$EXEDIR\$0"
		;=== check if a required INI parameter is missing
		IfErrors NoINI

		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "PluginsDirectory"
		StrCpy "$PLUGINSDIRECTORY" "$EXEDIR\$0"
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "AdditionalParameters"
		StrCpy "$ADDITIONALPARAMETERS" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "AllowMultipleInstances"
		StrCpy "$ALLOWMULTIPLEINSTANCES" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "SkipChromeFix"
		StrCpy "$SKIPCHROMEFIX" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "SkipCompregFix"
		StrCpy "$SKIPCOMPREGFIX" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "WaitFor${APP}"
		StrCpy "$WAITFORPROGRAM" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "${APP}Executable"
		StrCpy "$PROGRAMEXECUTABLE" $0

		;=== Any missing unrequired INI entries will be an empty string, ignore associated errors
		ClearErrors

		;=== Correct PROGRAMEXECUTABLE if blank
		StrCmp $PROGRAMEXECUTABLE "" NoProgramExecutable GoodProgramExecutable

			NoProgramExecutable:
				StrCpy "$PROGRAMEXECUTABLE" "${DEFAULTEXE}"

			GoodProgramExecutable:
		Goto EndINI

	NoINI:
		;=== No INI file, so we'll use the defaults

		;=== defaults common to all file locations
		StrCpy "$ADDITIONALPARAMETERS" ""
		StrCpy "$ALLOWMULTIPLEINSTANCES" "false"
		StrCpy "$SKIPCHROMEFIX" "false"
		StrCpy "$SKIPCOMPREGFIX" "false"
		StrCpy "$WAITFORPROGRAM" "false"
		StrCpy "$PROGRAMEXECUTABLE" "${DEFAULTEXE}"

		IfFileExists "$EXEDIR\${APP}\${DEFAULTEXE}" FoundProgramDIR CheckPortableProgramDIR

		FoundProgramDIR:
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\${APP}"
			StrCpy "$PROFILEDIRECTORY" "$EXEDIR\profile"
			StrCpy "$PLUGINSDIRECTORY" "$EXEDIR\plugins"
			GoTo EndINI

		CheckPortableProgramDIR:
			IfFileExists "$EXEDIR\${NAME}\${APP}\${DEFAULTEXE}" FoundPortableProgramDIR CheckPortableAppsDIR

		FoundPortableProgramDIR:
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\${NAME}\${APP}"
			StrCpy "$PROFILEDIRECTORY" "$EXEDIR\${NAME}\profile"
			StrCpy "$PLUGINSDIRECTORY" "$EXEDIR\${NAME}\plugins"
			GoTo EndINI

		CheckPortableAppsDIR:
			IfFileExists "$EXEDIR\PortableApps\${NAME}\${APP}\${DEFAULTEXE}" FoundPortableAppsDIR NoProgramEXE

		FoundPortableAppsDIR:
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\PortableApps\${NAME}\${APP}"
			StrCpy "$PROFILEDIRECTORY" "$EXEDIR\PortableApps\${NAME}\profile"
			StrCpy "$PLUGINSDIRECTORY" "$EXEDIR\PortableApps\${NAME}\plugins"
			GoTo EndINI

	EndINI:
		IfFileExists "$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" FoundProgramEXE

	NoProgramEXE:
		;=== exe was not found
		MessageBox MB_OK|MB_ICONEXCLAMATION `$PROGRAMEXECUTABLE was not found.  Please check your configuration`
		Abort
		
	FoundProgramEXE:

	;=== Check for an existing profile
	IfFileExists "$PROFILEDIRECTORY\prefs.js" ProfileFound
	
	;=== No profile was found
	MessageBox MB_YESNO|MB_ICONQUESTION `No profile was found. Would you like to create a new profile here? $\n$PROFILEDIRECTORY\` IDYES CreateProfile
	MessageBox MB_OK|MB_ICONINFORMATION `${NAME} can not run without a profile directory.  Please check your configuration.`
	Abort
	
	CreateProfile:
		IfFileExists "$PROFILEDIRECTORY\*.*" ProfileFound LaunchProgram
		;=== create a new profile directory
		;CreateDirectory "$PROFILEDIRECTORY\"

	ProfileFound:
		IfFileExists "$PROFILEDIRECTORY\chrome\chrome.rdf" ChromeFound RunProgram
	
	ChromeFound:
		StrCmp $SKIPCHROMEFIX "true" RunProgram
		FileOpen $0 "$PROFILEDIRECTORY\chrome\chrome.rdf" r
		FileOpen $R0 "$PROFILEDIRECTORY\chrome\chrome.rdf.new" w
		ClearErrors ; if there's an error, we're done with the file
	
	NextLine:
		FileWrite $R0 $4
		FileRead $0 $4
		IfErrors NoMoreLines ;== we've reached the end of the file
		StrCpy $5 $4 34
		StrCmp $5 `                   c:baseURL="jar:` "" NextLine
		StrCpy $R4 40
	
	NotYet:
		IntOp $R4 $R4 + 1
		StrCpy $7 $4 10 $R4 ; looking for the point to strip the extension path
		StrCmp $7 "extensions" PathFound NotYet
	
	PathFound:
		StrCpy $5 $4 "" $R4
		StrCpy $4 `                   c:baseURL="jar:file:///$PROFILEDIRECTORY/$5` ; the path made ABSOLUTE
		GoTo NextLine

	NoMoreLines:
		FileClose $0
		FileClose $R0
		;=== Backup the chrome.rdf just in case
		CopyFiles "$PROFILEDIRECTORY\chrome\chrome.rdf" "$PROFILEDIRECTORY\chrome\chrome.rdf.old" 		;=== Save the new chrome.rdf
		CopyFiles "$PROFILEDIRECTORY\chrome\chrome.rdf.new" "$PROFILEDIRECTORY\chrome\chrome.rdf" 

	RunProgram:
		StrCmp $SKIPCOMPREGFIX "true" GetPassedParameters

		;=== Delete component registry to ensure compatibility with all extensions
		Delete $PROFILEDIRECTORY\compreg.dat

	GetPassedParameters:
		;=== Get any passed parameters
		Call GetParameters
		Pop $0
		StrCmp "'$0'" "''" LaunchProgram LaunchProgramParameters

	LaunchProgram:
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" -profile "$PROFILEDIRECTORY"`
		Goto CheckMultipleInstances

	LaunchProgramParameters:	
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" -profile "$PROFILEDIRECTORY" $0`

	CheckMultipleInstances:
		StrCmp $ALLOWMULTIPLEINSTANCES "true" MultipleInstances NoMultiple

	MultipleInstances:
		System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("MOZ_NO_REMOTE", "1").r0'

	NoMultiple:
		StrCmp $ADDITIONALPARAMETERS "" NoParameters AdditionalParameters

	AdditionalParameters:
		StrCpy $EXECSTRING `$EXECSTRING $ADDITIONALPARAMETERS`

	NoParameters:
		;=== Set the plugins directory if we have a path
		StrCmp $PLUGINSDIRECTORY "" LaunchNow
		System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("MOZ_PLUGIN_PATH", "$PLUGINSDIRECTORY").r0'

	LaunchNow:
		StrCmp $WAITFORPROGRAM "true" LaunchAndWait LaunchAndClose

	LaunchAndWait:
		ExecWait $EXECSTRING
		GoTo TheEnd

	LaunchAndClose:
		Exec $EXECSTRING

	TheEnd:

SectionEnd

Function "GetParameters"
  Push $R0
  Push $R1
  Push $R2
  StrCpy $R0 $CMDLINE 1
  StrCpy $R1 '"'
  StrCpy $R2 1
  StrCmp $R0 '"' loop
    StrCpy $R1 ' ' ; we're scanning for a space instead of a quote
  loop:
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 $R1 loop2
    StrCmp $R0 "\" "" "nofile"
      IntOp $2 $R2 + 1
    nofile:
    ;MessageBox MB_OK "r0: $R0"
    StrCmp $R0 "" loop2
    IntOp $R2 $R2 + 1
    Goto loop
  loop2:
    IntOp $R0 $R2 - $2
    IntOp $R0 $R0 - 4
    ;MessageBox MB_OK "$R2 - $2 = $R0"
    StrCpy $R7 $CMDLINE $R0 $2 ; we save the filename
    ;MessageBox MB_OK "$2"
  loop2b:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    ;MessageBox MB_OK "rr0: $R0"
    StrCmp $R0 " " loop2b
  StrCpy $R0 $CMDLINE "" $R2
  Pop $R2
  Pop $R1
  Exch $R0
FunctionEnd