#!/usr/bin/python
'''
Script to split large file while reserve the continuation of the 1st field.
'''
import sys
import math
import os.path

def main(delim=(), field=0):
    lines = file(sys.argv[1]).readlines()
    fname = sys.argv[2]
    lcount = float(sys.argv[3])

    digit = int(math.log10(len(lines)/lcount))+1
    fbase, fext = os.path.splitext(fname)
    ofilepat = '%s%%0%ii%s' % (fbase, digit, fext)

    old_head = 0
    n = lcount
    extcount = 0

    pool = []
    for i in range(len(lines)):
        line = lines[i]
        if i < n:
            pool.append(line)
        else:
            my_head = line.split(*delim)[field]
            if not old_head:
                old_head = my_head
                pool.append(line)
            elif old_head == my_head:
                pool.append(line)
            else:
                ofd = file(ofilepat % extcount, 'w').write(''.join(pool))
                pool = [line]
                extcount += 1
                n += lcount
                old_head = 0
    if pool:
        ofd = file(ofilepat % extcount, 'w').write(''.join(pool))


if __name__ == '__main__':
    main()
# vim:ts=8:sw=4:expandtab

