/***********************************************************************
*                           AttributeInspector
*                        (AttributeInspector.js)
***********************************************************************/
/*
* Description:
* ===========
* This file contains both the AttributeInspector object.
*
* Contributors:
* ============
*	Franklin de Graaf
*
***********************************************************************/
if(TRACE_LOADING){ alert("Start loading: xmAttributesInspector.js"); }

//======================================================================
// AttributeInspector
//======================================================================
// The attributes inspector. This displays the attributes for the active
// elemenent. In addition, it allows for adding, changing and deleting
// attributes for the active element.

//----------------------------------------------------------------------
// AttributeInspector::AttributeInspector() (Constructor)
//----------------------------------------------------------------------

function AttributeInspector(theDesignDocument) {
const METHOD_NAME = "AttributeInspector::AttributeInspector";
trace(METHOD_NAME, "BEGIN" );

	this.theDesignDocument = theDesignDocument;
trace(METHOD_NAME, "MSG", "Active Node: " + this.theDesignDocument.getActiveNode().id);

	// set up default attrs data
	// Creates a set of available attributes for each design element (widget)
	//this.element= new Array();
	this.defaultAttrs = new Array();
  	this.curAttr = null;
	this.makeAttributeData();
	this.update(); // build the attributes from the currently active node

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// AttributeInspector::makeAttributeDataObject()
//----------------------------------------------------------------------
AttributeInspector.prototype.makeAttributeDataObject = function(name, inherits) {
const METHOD_NAME = "AttributeInspector::makeAttributeDataObject";
trace(METHOD_NAME, "BEGIN" );

	var obj = new Object();
	obj.name = name;
	obj.inherits = inherits;
	obj.values = new Array();
	obj.defaults = new Array();
	obj.events = new Array();

trace(METHOD_NAME, "END" );
	return obj;
}

//----------------------------------------------------------------------
// AttributeInspector::makeAttributeData()
//----------------------------------------------------------------------
AttributeInspector.prototype.makeAttributeData = function() {
const METHOD_NAME = "AttributeInspector::makeAttributeData";
trace(METHOD_NAME, "BEGIN" );

	var defaultAttrs = this.defaultAttrs;


	// default
	defaultAttrs[0] = this.makeAttributeDataObject("default", null);
	defaultAttrs[0].values.push("class");
	defaultAttrs[0].defaults.push("");
	defaultAttrs[0].values.push("style");
	defaultAttrs[0].defaults.push("");
	defaultAttrs[0].values.push("persist");
	defaultAttrs[0].defaults.push("");
	defaultAttrs[0].values.push("popup");
	defaultAttrs[0].defaults.push("");
	defaultAttrs[0].values.push("popupanchor");
	defaultAttrs[0].defaults.push("");
	defaultAttrs[0].values.push("popupalign");
	defaultAttrs[0].defaults.push("");
	defaultAttrs[0].defaults.push("");
	defaultAttrs[0].events.push("ondragdrop");
	defaultAttrs[0].events.push("ondragover");
	defaultAttrs[0].events.push("ondragexit");

	// Window
	defaultAttrs[1] = this.makeAttributeDataObject("window", "default");
	defaultAttrs[1].values.push("xmlns:html");
	defaultAttrs[1].defaults.push("http://www.w3.org/1999/xhtml");
	defaultAttrs[1].values.push("xmlns:rdf");
	defaultAttrs[1].defaults.push("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
	defaultAttrs[1].values.push("title");
	defaultAttrs[1].defaults.push("");
	defaultAttrs[1].values.push("align");
	defaultAttrs[1].defaults.push("center");
	defaultAttrs[1].values.push("autostretch");
	defaultAttrs[1].defaults.push("never");
	defaultAttrs[1].events.push("onload");
	defaultAttrs[1].events.push("onunload");

	// Box
	defaultAttrs[2] = this.makeAttributeDataObject("box", "default");
	defaultAttrs[2].values.push("flex");
	defaultAttrs[2].defaults.push("1");
	defaultAttrs[2].values.push("align");
	defaultAttrs[2].defaults.push("center");
	defaultAttrs[2].values.push("valign");
	defaultAttrs[2].defaults.push("center");
	defaultAttrs[2].values.push("width");
	defaultAttrs[2].defaults.push("");
	defaultAttrs[2].values.push("height");
	defaultAttrs[2].defaults.push("");
	defaultAttrs[2].values.push("autostretch");
	defaultAttrs[2].defaults.push("never");
 
	// VBox
	defaultAttrs[3] = this.makeAttributeDataObject("vbox", "box");

	// HBox
	defaultAttrs[4] = this.makeAttributeDataObject("hbox", "box");

	// Button
	defaultAttrs[5] = this.makeAttributeDataObject("button", "box");
	defaultAttrs[5].values.push("default");
	defaultAttrs[5].defaults.push("true");
	defaultAttrs[5].values.push("disabled");
	defaultAttrs[5].defaults.push("true");
	defaultAttrs[5].values.push("toggled");
	defaultAttrs[5].defaults.push("true");
	defaultAttrs[5].values.push("label");
	defaultAttrs[5].defaults.push("Button");
	defaultAttrs[5].events.push("onclick");
	defaultAttrs[5].events.push("oncommand");

	// Label
	defaultAttrs[6] = this.makeAttributeDataObject("label", "default");
	defaultAttrs[6].values.push("value");
	defaultAttrs[6].defaults.push("LABEL");
  
	// Textbox
	defaultAttrs[7] = this.makeAttributeDataObject("textbox", "box");
	defaultAttrs[7].values.push("value");
	defaultAttrs[7].defaults.push("TEXT");
	defaultAttrs[7].values.push("multiline");
	defaultAttrs[7].defaults.push("true");
  
	// Image
	defaultAttrs[8] = this.makeAttributeDataObject("image", "default");

	// GroupBox
	defaultAttrs[9] = this.makeAttributeDataObject("groupbox", "box");

	// Spacer (formerly Spring)
	defaultAttrs[10] = this.makeAttributeDataObject("spacer", "default");
	defaultAttrs[10].values.push("flex");
	defaultAttrs[10].defaults.push("1");

  
	// Grid
	defaultAttrs[11] = this.makeAttributeDataObject("grid", "box");

	// Rows
	defaultAttrs[12] = this.makeAttributeDataObject("rows", "box");

	// Row
	defaultAttrs[13] = this.makeAttributeDataObject("row", "box");

	// Tabbox
	defaultAttrs[14] = this.makeAttributeDataObject("tabbox", "box");

	// Tabs
	defaultAttrs[15] = this.makeAttributeDataObject("tabs", "default");

	// Tab
	defaultAttrs[16] = this.makeAttributeDataObject("tab", "default");

	// Tabpanels
	defaultAttrs[17] = this.makeAttributeDataObject("tabpanels", "default");

	// Tabpanel
	defaultAttrs[18] = this.makeAttributeDataObject("tabpanel", "default");

	// Toolbox
	defaultAttrs[19] = this.makeAttributeDataObject("toolbox", "default");

	// Menubar
	defaultAttrs[20] = this.makeAttributeDataObject("menubar", "default");

	// Menu
	defaultAttrs[21] = this.makeAttributeDataObject("menu", "default");

	// MenuPopup
	defaultAttrs[22] = this.makeAttributeDataObject("menupopup", "default");

	// Menuitem
	defaultAttrs[23] = this.makeAttributeDataObject("menuitem", "default");

	// Toolbar
	defaultAttrs[24] = this.makeAttributeDataObject("toolbar", "default");

	// Toolbarbutton
	defaultAttrs[25] = this.makeAttributeDataObject("toolbarbutton", "default");


trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// AttributeInspector::onAttrChanged()
//----------------------------------------------------------------------

AttributeInspector.prototype.onAttrChanged = function(event) {
  this.setAttr(event.attrName,this.getAttrEdit.getAttribute("value"));
}

//----------------------------------------------------------------------
// AttributeInspector::addAttribute()
//----------------------------------------------------------------------

AttributeInspector.prototype.addAttribute = function(attr,def) {
const METHOD_NAME = "AttributeInspector::addAttribute";
trace(METHOD_NAME, "BEGIN" );
trace(METHOD_NAME, "INFO", "attr=" + attr + ", def=" + def );

	this.theDesignDocument.activeNode.setAttribute(attr,def);
	// check the attribute
	XULattribute = document.getElementById(NAMESPACE + "availattrlist-"+attr);
	if (XULattribute) { XULattribute.setAttribute("checked","true") };
	this.update(false);

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// AttributeInspector::deleteAttribute()
//----------------------------------------------------------------------

AttributeInspector.prototype.deleteAttribute = function() {
const METHOD_NAME = "AttributeInspector::deleteAttribute";
trace(METHOD_NAME, "BEGIN" );

	var attribute = document.popupNode.getAttribute("value")
trace(METHOD_NAME, "INFO", "attribute=" + attribute );
	this.theDesignDocument.activeNode.removeAttribute(attribute);
	a = document.getElementById(NAMESPACE + "availattrlist-"+attribute);
	if (a) { a.setAttribute("checked","false") };
	this.update(false);

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// AttributeInspector::addCustomAttr()
//----------------------------------------------------------------------

AttributeInspector.prototype.addCustomAttr = function() {
	s = prompt("Please enter the name of the attribute:");
	this.addAttribute(s,"");
}

//----------------------------------------------------------------------
// AttributeInspector::getAttrEdit()
//----------------------------------------------------------------------

AttributeInspector.prototype.getAttrEdit = function(name) {
	// gets the textfield for the specified attribute name
	return document.getElementById(NAMESPACE + "attrlist-edit-"+name);
}

//----------------------------------------------------------------------
// AttributeInspector::setAttr()
//----------------------------------------------------------------------

AttributeInspector.prototype.setAttr = function(attr,checkIds) {
	if (this.getAttrEdit(attr).value != this.theDesignDocument.activeNode.getAttribute("id")) {
		if (attr == "id" && checkIds == true) {
			// verify that the ID is unique
			var newvalue = this.getAttrEdit(attr).value;
			if (isIDUnique(newvalue) == true) { this.theDesignDocument.activeNode.setAttribute(attr,newvalue); } else { alert("Sorry, but the ID must be unique :("); this.getAttrEdit(attr).value = this.theDesignDocument.activeNode.getAttribute("id") }
			this.theDesignDocument.updateIDList(document);
		} else if (attr != "id") {
			// sets the attribute to the value on the current node
			// called by textfield event handlers
			var newvalue = this.getAttrEdit(attr).value;
			this.theDesignDocument.activeNode.setAttribute(attr,newvalue);
		}
	}
}

//----------------------------------------------------------------------
// AttributeInspector::update()
//----------------------------------------------------------------------
// updates the attribute inspector

AttributeInspector.prototype.update = function(updateAttrs) {
const METHOD_NAME = "AttributeInspector::update";
trace(METHOD_NAME, "BEGIN" );

	var activeNode = this.theDesignDocument.getActiveNode();
trace(METHOD_NAME, "MSG", "activeNode: " + activeNode.id);

	// remove the current attributes list
	var rows = document.getElementById(NAMESPACE + "attrlist").childNodes.item(1);
	while (rows.hasChildNodes() == true) { rows.removeChild(rows.firstChild) }

	// Build the attributes list for the active element.
	// We walk through the attributes of the active element in the design document
	// creating a <row> in the Attribute Inspector for each attribute.
	// Each <row> contains the attribute name as a <label> element and the
      // attribute value as a <textbox> element which will be initialized with
      // the default attribute value
trace(METHOD_NAME, "MSG", "element: " + activeNode.tagName + " has " + activeNode.attributes.length + " attributes.");
	for (i=0; i < activeNode.attributes.length; i++) {
		// get data
		var name = activeNode.attributes.item(i).name;
		var data = activeNode.getAttribute(name);
		if (name != ACTIVE_ATTRNAME) {
			// Exclude attributes in the XULMaker namespace ("xm:"), e.g. "xm:active" 
			// (These attributes are not part of the deliverable design document
trace(METHOD_NAME, "MSG", "attribute(" + i + "): " + name );

			// create a row element containing a text element and a textbox element
			row = document.createElement("row");
			row.setAttribute("valign","center");
			row.setAttribute("autostretch","never");
			
			// create a <label> element to contain the attribute name
			text = document.createElement("label");
			text.setAttribute("value",name);
			text.setAttribute("class","inspector-attr");
			text.setAttribute("popup",NAMESPACE + "attrlist-popup");
			row.appendChild(text);

			// can we remove this attribute?
			if (name == "id") {
				document.getElementById(NAMESPACE + "attrlist-popup-remove").setAttribute("disabled","true")
			} else {
				document.getElementById(NAMESPACE + "attrlist-popup-remove").setAttribute("disabled","false")
			}

			// create a <textbox> element to contain the attribute value
			textfield = document.createElement("textbox");
			textfield.setAttribute("value",data);
			textfield.setAttribute("id",NAMESPACE + "attrlist-edit-"+name);
			// @@ don't like this, but can't use event listeners until mututation events are in
			textfield.setAttribute("onkeypress","xm.theAttributeInspector.setAttr('"+name+"',false)");
			textfield.setAttribute("onblur","xm.theAttributeInspector.setAttr('"+name+"',true)");

			row.appendChild(textfield);
			rows.appendChild(row);
		}
	}

	// now update the available attributes menu
trace(METHOD_NAME, "MSG", "updateAttrs = " + updateAttrs );
	if (updateAttrs == undefined) { updateAttrs = true } // This is false when called from addAttribute() and deleteAttribute()
	if (updateAttrs == true) {

		menu = document.getElementById(NAMESPACE + "availattrlist");
		// clear it
		while (menu.hasChildNodes() == true) {
			menu.removeChild(menu.firstChild)
		}

		this.createAttributesList(menu, this.theDesignDocument.activeNode.tagName);

		// add custom item
		menu.appendChild(document.createElement("menuseparator"));
		addcustom = document.createElement("menuitem");
		addcustom.setAttribute("value","Custom...");
		addcustom.setAttribute("onclick","xm.theAttributeInspector.addCustomAttr()");
		menu.appendChild(addcustom);
	}

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// AttributeInspector::createAttributesList()
//----------------------------------------------------------------------

AttributeInspector.prototype.createAttributesList = function(menu,tagName) {
const METHOD_NAME = "AttributeInspector::createAttributesList";
trace(METHOD_NAME, "BEGIN" );
trace(METHOD_NAME, "MSG", "Creating attributes for element: " + tagName);

	// get the defaulted attribute data
	var attr = null;
	for (i=0; i < this.defaultAttrs.length; i++) {
		if (this.defaultAttrs[i].name == tagName) {
			attr = this.defaultAttrs[i];
			if (attr.inherits != null) {
				this.createAttributesList(menu, attr.inherits); 
				menu.appendChild(document.createElement("menuseparator"));
			}
			break;
		}
	}
	if (attr != null) {
      	trace( "AttributeInspector::createAttributesList", "MSG", "adding " + attr.values.length + " for element: " + attr.name);
		for (i=0; i < attr.values.length;i++) {
			value = attr.values[i];
			def = attr.defaults[i];
			item = document.createElement("menuitem");
			item.setAttribute("label", value);
			item.setAttribute("id",NAMESPACE + "availattrlist-"+value);
			if (this.theDesignDocument.activeNode.hasAttribute(attr.values[i]) == true) {
				item.setAttribute("checked","true");
			}
			item.setAttribute("oncommand","xm.theAttributeInspector.addAttribute('"+value+"','"+def+"')");
			menu.appendChild(item);
		}
		// now for events
		if (attr.events.length > 0) {
			menu.appendChild(document.createElement("menuseparator"));
			for (i=0;i < attr.events.length; i++) {
				item = document.createElement("menuitem");
				item.setAttribute("label",attr.events[i]);
				item.setAttribute("id",NAMESPACE + "availattrlist-"+value);
				item.setAttribute("oncommand","xm.theAttributeInspector.addAttribute('"+attr.events[i]+"','')");
				menu.appendChild(item);
			}
		}
		menu.parentNode.setAttribute("value","Choose an attribute");
	}

trace(METHOD_NAME, "END" );
}


//----------------------------------------------------------------------
// AttributeInspector::onChangeElementSelection(event)
//----------------------------------------------------------------------

AttributeInspector.prototype.onChangeElementSelection = function(event) {
const METHOD_NAME = "AttributeInspector::onChangeElementSelection";
trace(METHOD_NAME, "BEGIN" );

	// get the id of the new selection
	// (There should be an easier way of getting this.)
	var broadcaster = document.getElementById(event.target.getAttribute("element"));
	id = broadcaster.getAttribute("selection");
	trace("AttributeInspector::onChangeElementSelection", "MSG", "selection: " + id );
	//this.selectElement(id);
	this.update();

trace(METHOD_NAME, "END" );
}
/***********************************************************************
if(TRACE_LOADING){ alert("Continuing loading: xmAttributesInspector.js"); }
***********************************************************************/
if(TRACE_LOADING){ alert("Finish loading: xmAttributesInspector.js"); }

