/*
 * cdspeed.c -- Sets ATAPI cdrom spindle if the cdspeed patch is applied
 * to the kernel.
 *
 * (c) 1998  Toni Giorgino      (toni@pcape2.pi.infn.it)
 *
 */


#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/ucdrom.h>


void usage()
{
	fprintf(stderr, "Usage:     cdspeed { -h | abs_speed | rel_speed X}\n"
		"Example:   cdspeed 300       or        cdspeed 2x\n");
}


main(int argc, char **argv)
{
	int fd, a, d;


	a = 0;

	if (argc > 2) {
		usage();
		exit(5);
	}
	if (argc == 2) {
		if (strcmp("-h", argv[1]) == 0) {
			usage();
			exit(0);
		}
		/* Read speed */
		a = 0xffff & atoi(argv[1]);
		/* * 150 if relative */
		if (argv[1][strlen(argv[1] - 2)] == 'x' ||
		    argv[1][strlen(argv[1] - 2)] == 'X')
			a *= 150;
	}
	fd = open("/dev/cdrom", O_RDONLY);

	d = ioctl(fd, CDROM_SELECT_SPEED, a);

	if (d)
		fprintf(stderr,
			"ioctl(\"/dev/cdrom\", CDROM_SELECT_SPEED, %d)"
			" failed with returncode %d.\n", a,d);

}
