.\"----------------------------------------------------------------------------
.\" --- bt.man ---  Copyright (C) 1994 by T. Weidenfeller
.\"
.\" File ID:
.\"	$Id: bt.man,v 1.3 1994/10/26 18:23:46 root Exp $
.\"
.\" Purpose:
.\" 	Man page for the BiTronics device driver
.\"
.\" Copyright:
.\"	You are free to copy, modify and distribute this material as you see
.\"	fit, and to use it for any purpose, provided this copyright notice and
.\"	the warranty disclaimer are included without any modification in all
.\"	copies and modifications. You have to mark all modifications clearly and
.\"	you are also commited to give propper acknowledgment of the original
.\"	source if you include this material or parts of it in another software.
.\"
.\" Warranty:
.\"	The BiTronics device driver and the accompaning material is a free
.\"	sample of no commercial value. It comes without any warranty:
.\"	
.\"	THERE IS NO WARRANTY OF ANY KIND WITH REGARDS TO THIS MATERIAL,
.\"	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MECHANTABILITY
.\"	AND FITNESS FOR A PARTICULAR PURPOSE. The author shall not be liable for
.\"	errors contained in the material or for incidental or consequental
.\"	damage in connection with the furnishing, performance, or use of this
.\"	material.
.\"	
.\" Revisions: $Log: bt.man,v $
.\"	Revision 1.3  1994/10/26  18:23:46  root
.\"	General harmonisation (prep 1. ALPHA release).
.\"
.\"	Revision 1.2  1994/10/16  19:12:14  root
.\"	First usefull version
.\"
.\"	Revision 1.1  1994/10/16  18:17:04  root
.\"	Initial revision
.\"
.\"
.\"----------------------------------------------------------------------------
.\"
.TH BT 4  "Sun Oct 16 1994" "" "Device Driver"
.\"
.SH NAME
bt \- BiTronics parallel device driver
.\"
.SH SYNOPSIS
.nf
.BI mknod " -m 660 " /dev/bt0 " c 29 0 "
.BI mknod " -m 660 " /dev/bt1 " c 29 1 "
.BI mknod " -m 660 " /dev/bt2 " c 29 2 "
.BI chown " root.lp " /dev/bt?
.fi
.\"
.SH DESCRIPTION
The
.I bt
device driver is a replacement for the standard parallel printer driver
.IR lp .
It enables the use of the status readback feature from printers
equiped with a so called
.I BiTronics
.RI ( bi "-directional Cen" tronics \(rg)
interface.
The BiTronics device driver
.I bt
for Linux implements the necessary communication protocol on the host
side. 

Most - if not any - of Hewlett-Packard's LaserJet\(rg 4 series printers
are equipt with such a
.I BiTronics
interface.  In the direction
.I host to printer
the interface is compatible with a normal Centronics interface. In addition,
the interface can be switched to a
.I printer to host
mode. In this mode the host is now able to read back printer status
information etc.
.\"
.SH I/O CONTROL
None (currently).
.\"
.SH FILES
/dev/bt*
.\"
.SH EXAMPLE
Assuming your LaserJet 4x is connectet to the second printer port /dev/bt1, then
.PP
.RS
.nf
echo -e "\\033%-12345X@PJL" >/dev/bt1
echo "@PJL INFO VARIABLES" >/dev/bt1
sleep 2
cat /dev/bt1 | more
.fi
.RE
.PP
will deliver a list of the current values of the printers' variables.
.\"
.SH SEE ALSO
.IR chown (1),
.IR mknod (1),
.IR lp (4)

.SH COPYRIGHT
Copyright (C) 1994 by T. Weidenfeller

You are free to copy, modify and distribute this material as you see
fit, and to use it for any purpose, provided this copyright notice and
the warranty disclaimer are included without any modification in all
copies and modifications. You have to mark all modifications clearly and
you are also commited to give propper acknowledgment of the original
source if you include this material or parts of it in another software.

.SH WARRANTY
The BiTronics device driver and the accompaning material is a free
sample of no commercial value. It comes without any warranty:

THERE IS NO WARRANTY OF ANY KIND WITH REGARDS TO THIS MATERIAL,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MECHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE. The author shall not be liable for
errors contained in the material or for incidental or consequental
damage in connection with the furnishing, performance, or use of this
material.

