/* 
 * Device major number and name
 */
#define HPSJ_MAJOR 26
#define HPSJ_NAME "hpscan"

/*
 *	ioctl's for driver
 */
#define	HPSJIOC		('J'<<8)
#define	HPSJRESET	(HPSJIOC|1)	/* ioctl(fd, ..., 0) */
#define	HPSJERRSTAT	(HPSJIOC|2)	/* ioctl(fd, ..., (int *) &status) */
#define	HPSJBUFSIZE	(HPSJIOC|3)	/* ioctl(fd, ..., (int *) &size) */
#define	HPSJDEBUG	(HPSJIOC|4)	/* ioctl(fd, ..., (bool) onoff) */

/*
 * Hardware bits: status register
 */
#define nFAULT		0x08  /* 0 = Error */
#define ONLINE		0x10  /* 1 = On Line (aka SELECT) */
#define ERROR		0x20  /* 1 = Printer out of paper */
#define nACK		0x40  /* 0 = lp ready for next char */
#define nBUSY		0x80  /* 0 = Printer is busy (active low) */

/*
 * Hardware bits: ctrl register
 */
#define STROBE		0x01    /* lp character strobe (1 active) */
#define RDnWR		0x02    /* reading=1, writing=0 */
#define nRESET		0x04    /* reset (0 active) */
#define SLCT		0x08    /* enable data xfer (1 active) */
#define INT_EN		0x10    /* enable interrupts on NACKLDG transition */
#define BUSY_CTL	0x20    /* 1=host ctls busy (data source is scanner) */
				/* 0=scanner ctls busy (data source is host) */
#define				HOST_SRC	0
#define				SCAN_SRC	BUSY_CTL

/* 
 * Hardware bits: swing register 
 */
#define	SWG_EN		0x01	/* Enable swing buffers */
#define	SWG_HND		0x02	/* Swing handshake */
#define	CNT_HL		0x04	/* 1=high, 0=low counter */
#define	CNT_WEN		0x08	/* Enable write to counter */
#define	SWG_SW(x)	((x&0x70)>>4)

#define	SWG_SIZE	16384	/* Size of swing buffer */
