/*

Parameters used to format a MFM or RLL disk that is on the other
end of an Adaptec acb-40XX SCSI <--> MFM/RLL bridge board.

Insert your drive parameters here, and recompile, using:

gcc -s -N format.c -o format

The acb-4070 is SCSI --> RLL, using 2,7 RLL and 26 sectors per track.
The acb-4000 is SCSI --> MFM, using 18 (not 17!) sectors per track.

Note that in this case, the format command will hold the SCSI bus
until it is done (which may exceed 15 minutes!) -- Linux will not
like to see one device hog the SCSI bus for more than a few seconds
and will try to reset the device, and then as a more drastic measure,
it will try to reset the bus. This will of course abort the format,
which is not good. There is a quick hack included in this package
that will stop Linux from doing that. See the README for more details.

Values > 255 are in high byte/low byte format.
Values > 1023 are in high, mid, low byte format.

This is a safety check to avoid people compiling blindly without
putting in their drive geometry. Delete the #error line.
*/

#error You must put drive parameters in the file "geometry.h"

/* Block size -- Linux wants 512. You shouldn't change this. */

#define BLK_HI		0x00
#define BLK_MID		0x02
#define BLK_LO		0x00

/* disk type is 0x01 for fixed/soft sectored drives and 0x02 for hard
sectored and removable drives. Most will be 0x01. */

#define DISK_TYPE	0x01

/* The number of cylinders that your drive has. 1166 in this case. */

#define CYLS_HI		0x04
#define CYLS_LO		0x8E

/* The number of physical heads in your drive. */

#define HEADS		0x07

/*
RWC and precomp not really needed for RLL acb-4070 -- best just to set them
to the last cylinder value anyways. 
*/

/* Reduced Write Current */

#define RWC_HI		0x04
#define RWC_LO		0x8E

/*
Write Precompensation -- ignored by the 4070 -- the 4000A also ignores
this value, and uses the jumpers R --> T to set WPC behaviour.
*/

#define WPC_HI		0x04
#define WPC_LO		0x8E

/*
The land zone used with the STOP UNIT command. The MSB indicates the
direction, with a 1 meaning the LZ is outside cylinder zero. The other
7 bits give the cylinder offset. A value of 0x0 will mean LZ is beyond
the last cylinder, with an offset of zero cylinders (usual setting.)
*/

#define LZ_OFFSET	0x00

/*
The step code can take on 3 values: 0x0 implies a non-buffered seek
at 3ms rate (ST506), 0x01 is for a buffered seek with a 28us rate (ST412)
and 0x02 is a buffered seek with a 12us rate. If you are not sure, use 2.
*/

#define STEP_CODE	0x02

/* The end. */
