/*

	This is a quick hack to format MFM/RLL drives that are being
	used with Adaptec's acb-40XX bridge boards. These are bridge
	boards that convert SCSI --> RLL/MFM. The acb-4070 is the RLL
	version, and the acb-4000 is the MFM version. Note that the 
	RLL version uses 26 sectors/track and the MFM version uses
	18 (not 17!) sectors/track.

	Note that the acb-40XX holds the SCSI bus for the entire
	duration of the format command (> 15 minutes for big drive!)
	and Linux will not like this. Linux will try and rest the
	device, and then the SCSI bus, which will kill the format.
	We have to disable this in the kernel for the format to work.
	See the README for more details.

	This code is a hack derived from Eric Youngdale's code
	in "scsiinfo.c" -- all credit goes to him, and all flames
	to me  :-(

	You will *have* to edit "geometry.h" to tell the program
	what your drive parameters are. It is set up to fail the
	compile stage if you don't.

	Good luck with it.
	Paul.
*/

#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include "geometry.h"

int do_park(void);
void dump( void *buffer, unsigned int length );

FILE *infile;
unsigned char buffer[10*1024];
unsigned char buffer1[10*1024];

#define STOP		0x1b

void dump( void *buffer, unsigned int length )
{
  unsigned int i;

  for (i=0; i<length; i++)
  {
      printf( "%02x ", (unsigned int) ((unsigned char *) buffer)[i] );
    if (i%16 == 15) { printf( "\n" ); }
  }
  printf( "\n" );

}


int do_park()
{
  int status, i;
  unsigned char *cmd;

  for (i=0; i<10*1024; i++) buffer[i] = 0;
  
  *( (int *)  buffer )		= 0;	/* length of input data */
  *( ((int *) buffer) + 1 )	= 1024;	/* length of output buffer */

  cmd = (char *) ( ((int *) buffer) + 2 );
  
  cmd[0] = STOP;
  cmd[1] = 0x00;			/* upper 3 bits = lun = 0 */
  cmd[2] = 0x00;			/* (reserved) */
  cmd[3] = 0x00;			/* (reserved) */
  cmd[4] = 0x01;			/* Shutdown (park drive) */
  cmd[5] = 0x00;			/* (reserved) */

  status = ioctl( fileno(infile), 1 /* SCSI_IOCTL_SEND_COMMAND */, buffer );
  if(status) printf( "ioctl(SCSI_REZERO) status\t= %d\n", status );

  return status;

}


int main( int argc, char *argv[])
{
  int i;

  if (argc!=2) {
	fprintf(stderr,"Usage: \"park /dev/sdn\" where n={a,b,c,d...}\n");
	exit(1);
  }

  infile = fopen( argv[1], "r" );
  if(!infile) {
  	perror(argv[1]);
  	exit(1);
  }

  printf("parking unit.\n");
 i=do_park();
/*  if (i) {
	fprintf(stderr,"Error trying to re-zero unit.\n");
	exit(i);
  }
*/
  return 0;
}


