/*
    FILE:	iomega_pc2.h
    PURPOSE:	Defines function prototypes and Scsi_Host structure for 
    		the PC2/PC2B adapter boards.  
    AUTHOR:	Brian Hughes
    EMAIL:	bwh8918@rit.edu
    DATE:	May 5, 1994
    COPYRIGHT:	IOMEGA PC2/2B driver for Linux
                Copyright (C) 1994, Brian W. Hughes

        This driver is free software; you can distribute it and/or
        modify it under the terms of the GNU General Public License as
        published by the Free Software Foundation; either version 2 of
        the License or (at your option) any later version.

        This driver is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public
        License along with this driver; if not, write to the Free
        Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
        USA.
*/

#ifndef IOMEGA_PC2_H
#define IOMEGA_PC2_H

int         iomega_pc2_detect(struct SHT *) ;
const char *iomega_pc2_info(void) ;
int	    iomega_pc2_command(Scsi_Cmnd *) ;
int	    iomega_pc2_queuecommand(Scsi_Cmnd *, void(*)(Scsi_Cmnd *)) ;
int	    iomega_pc2_abort(Scsi_Cmnd *) ;
int	    iomega_pc2_reset(Scsi_Cmnd *) ;
int	    iomega_pc2_bios_param(Disk *, int, int [] ) ;

#ifndef IOMEGA_PC2_C
    extern char iomega_pc2_info_string [75] ;
#endif

#define IOMEGA_PC2 {  NULL,						\
		      iomega_pc2_info_string,				\
		      iomega_pc2_detect,  			      	\
		      NULL,						\
		      iomega_pc2_info,					\
		      iomega_pc2_command, 			      	\
		      iomega_pc2_queuecommand,                      	\
		      iomega_pc2_abort,					\
		      iomega_pc2_reset,					\
		      NULL,						\
		      iomega_pc2_bios_param,				\
		      1,    						\
		      -1,	/* Host has no SCSI ID */		\
		      SG_NONE,	/* No scatter-gathering */		\
		      1,	/* No linked commands */		\
		      0,	/* Not detected yet */			\
		      1, 	/* Unchecked DMA */			\
		      DISABLE_CLUSTERING				\
}

#endif
