#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>

#include "scsi/scsi.h"
#include "scsi/scsi_ioctl.h"

#define DEFAULT_DEVICE	"/dev/sda"

typedef struct scsi_ioctl_command {
        unsigned int inlen;
        unsigned int outlen;
        unsigned char data[0];
} Scsi_Ioctl_Command;


void
main(int argc, char *argv[])
{
    int  fd;
    char *prog, device[256], request[256], *h;
    Scsi_Ioctl_Command *sic = (Scsi_Ioctl_Command*)request;

    h = strchr(argv[0],'/');
    prog = h ? h+1 : argv[0];

    if (argc > 1) {
	strcpy(device,argv[1]);
    } else {
	strcpy(device,DEFAULT_DEVICE);
    }

    if (-1 == (fd = open(device, O_RDONLY))) {
	fprintf(stderr,"%s: can't open %s: %s\n",prog,device,
		sys_errlist[errno]);
	exit(1);
    }

    if (-1 == ioctl(fd,SCSI_IOCTL_DOORUNLOCK,sic)) {
	perror("ioctl (unlock)");
	exit(1);
    }

    memset(request,0,256);
    sic->inlen  = 0;
    sic->outlen = 0;
    sic->data[0] = START_STOP;
    sic->data[1] = 0;
    sic->data[2] = 0;
    sic->data[3] = 0;
    sic->data[4] = (0 == strcmp(prog,"unload")) ? 2 : 3;
    sic->data[5] = 0;

    if (-1 == ioctl(fd,SCSI_IOCTL_SEND_COMMAND,sic)) {
	perror("ioctl (eject)");
	exit(1);
    }

    close(fd);
    exit(0);
}
