/*
 *	pop3d		- IP/TCP/POP3 server for UNIX 4.3BSD
 *			  Post Office Protocol - Version 3 (RFC1225)
 *
 *      (C) Copyright 1991 Regents of the University of California
 *
 *      Permission to use, copy, modify, and distribute this program
 *      for any purpose and without fee is hereby granted, provided
 *      that this copyright and permission notice appear on all copies
 *      and supporting documentation, the name of University of California
 *      not be used in advertising or publicity pertaining to distribution
 *      of the program without specific prior permission, and notice be
 *      given in supporting documentation that copying and distribution is
 *      by permission of the University of California.
 *      The University of California makes no representations about
 *      the suitability of this software for any purpose.  It is provided
 *      "as is" without express or implied warranty.
 *
 *	Katie Stevens
 *	dkstevens@ucdavis.edu
 * 	Information Technology -- Campus Access Point
 *	University of California, Davis
 *
 **************************************
 *
 *	util.c
 *
 *	REVISIONS:
 *		02-27-90 [ks]	original implementation
 *	1.000	03-04-90 [ks]
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <pwd.h>
#ifdef SHADOWPWD
#include "shadow.h"
#include "pwauth.h"
#endif
#include "pop3.h"

char flash_buf[SVR_BUFSIZ];

#ifdef DEBUG
extern FILE *logfp;
#endif

/**************************************************************************/

/* Verify a usercode/password */
int
verify_user(user,pass)
char *user;
char *pass;
{
	struct passwd *pwd;
#ifdef SHADOWPWD
	struct spwd *spwd;
#endif
	char *cp;

	pwd = getpwnam(user);
	if (pwd == NULL) return -1;
#ifdef SHADOWPWD
	if (!(spwd = getspnam(user)))
		return -1;
	else
		pwd->pw_passwd = spwd->sp_pwdp;
	if (pwd->pw_name && pwd->pw_passwd[0] == '@') {
		if (pw_auth(pwd->pw_passwd+1, user, PW_LOGIN))
			return -1;
		return(setuid(pwd->pw_uid));
	}
	if (!valid(pass, spwd))
		return -1;
	return(setuid(pwd->pw_uid));
#else
	cp = crypt(pass,pwd->pw_passwd);
	if (strcmp(cp,pwd->pw_passwd) == 0) {
		return(setuid(pwd->pw_uid));
	} else {
		return(-1);
	}
#endif
}

/**************************************************************************/

/* Read a line of text from a stream. If more than n-1  */
/* characters are read without a line terminator (LF),  */
/* discard characters until line terminator is located. */
char *
fgetl(buf,n,fp)
char *buf;	/* Buffer for text */
int n;		/* Size of buffer */
FILE *fp;	/* Stream to read from */
{
	if (fgets(buf,n,fp) == NULL)
		return(NULL);
	if ((strlen(buf) == (n-1))&&(buf[n-1] != LF_CHAR)) {
		buf[n-1] = LF_CHAR;
		while (fgets(flash_buf,SVR_BUFSIZ,fp) != NULL) {
			if (strlen(flash_buf) != (SVR_BUFSIZ-1))
				break;
			if (flash_buf[SVR_BUFSIZ-1] == LF_CHAR)
				break;
		}
	}
	return(buf);
}

/* Prepare client command for server */
void
cmd_prepare(buf)
char *buf;
{
	char *cp;

	if (buf == NULL)
		return;
	/* Convert command verb to lowercase */
	while (*buf != NULL_CHAR) {
		if (isupper(*buf))
			*buf = tolower(*buf);
		else if (isspace(*buf))
			break;
		++buf;
	}
	/* Strip trailing whitespace from client command */
	if ((cp = strchr(buf,CR_CHAR)) != NULL) {
		while ((cp != buf)&&(isspace(*cp))) --cp;
		if (!isspace(*cp)) ++cp;
		*cp = NULL_CHAR;
	}
	if ((cp = strchr(buf,LF_CHAR)) != NULL) {
		while ((cp != buf)&&(isspace(*cp))) --cp;
		if (!isspace(*cp)) ++cp;
		*cp = NULL_CHAR;
	}
}

/**************************************************************************/

/* Send an error message and exit POP3 server */
void
fail(err)
int err;
{
	char *cp;

	switch(err) {
	case FAIL_FILE_ERROR:			/* File I/O error */
		cp = "File I/O error";
		break;
	case FAIL_HANGUP:			/* Client hung up on us */
		cp = "Lost connectino to client";
		break;
	case FAIL_LOST_CLIENT:			/* Timeout waiting for client */
		cp = "Timeout waiting for command from client";
		break;
	case FAIL_OUT_OF_MEMORY:		/* Failed malloc() */
		cp = "Out of memory!";
		break;
	case FAIL_PROGERR:			/* Fatal program error */
		cp = "Fatal program error!";
		break;
	case FAIL_CONFUSION:			/* Shouldnt happen */
	default:
		cp = "Complete confusion!";
		break;
	}
	fprintf(stdout,"-ERR POP3 Server Abnormal Shutdown: %s\r\n",cp);
	fflush(stdout);
#ifdef DEBUG
	fprintf(logfp,"-ERR POP3 Server Abnormal Shutdown: %s\r\n",cp);
	fclose(logfp);
#endif
	exit(err);				/* Exit with error */
}
