/*	pppdead.cpp
*
*	Is called by kppp when ppp connection goes down.
*	Creates /tmp/pppisdead which kppp_logger searches for 
*	to verify that the pppconnection really is lost.
*	
*/



#include "general.h"

int DoSomeAction (bool FromError);
CheckForFile e;

bool CheckForFile::filex (int fname, bool FromDellog)
{
  if (fname == 2)
    {
		  ifstream CheckFname ("/tmp/pppisdead", ios::binary);
		  if (!CheckFname)
				return false;
		  else {
			  CheckFname.close ();
			  return true;
			}
    }
  return false;
}

int
main (int argc, char *argv[])
{
 
  if (argc != 1)
    leave (error, "warn", no_files_open);

  else
    {
      if (e.filex (pppisdead, false) == FILE_EXISTS)
	{
	  sound ();
	  cerr << "Something is wrong here. pppisdead allready exists. Removing stale file..." << endl;
	  remove ("/tmp/pppisdead");
	  DoSomeAction (true);	
	 /* True here tells DoSomeAction to use a different lmsg latter on in leave() */
				   
	}
      
	DoSomeAction (false);
    }
  /* To be a good citizen you must return an integer from your main */
  return (clean);
}

void
leave (int excode, char lmsg[], bool ofile)
{
  if (ofile == files_open)
		// Sorry once again, non GNU users :/
    fcloseall ();
  if (ofile == no_files_open && strcmp (lmsg, "warn") == 0)
    {
      sound ();
      cout << "This program is a part of kppp_logger-" << version <<
	" and ought to be left alone." << endl;
    }
  else
    cout << lmsg << endl;
  exit (excode);
}
/*
  Writes the file /tmp/pppisdead which
  indicates that the ppp connection has
  gone down. This is the file that kppp_logger
  searches for to get aware of a broken connection.
 */
int
DoSomeAction (bool FromError)
{
  struct tm *tblock;
  time_t timer;
  timer = time (NULL);
  tblock = localtime (&timer);
  ofstream
  CreatePppIsDead ("/tmp/pppisdead", ios::app);
  if (!CreatePppIsDead)
    errorhandler ("Could not create /tmp/pppisdead. Reason unknown.");
  CreatePppIsDead << asctime (tblock);
  if (FromError != true)
    leave (clean, "Halting kppp_logger...", files_open);
  else
    leave (error, "warn", no_files_open);
  return (clean);
}

int
errorhandler (char *reason) // Sort of redundant.. but still.
{
  sound ();
  fcloseall ();
  cin.clear ();
  cout << reason << endl;
  exit (1);
  return (0);
}

void
sound ()
{
  /* Advanced sound programming, huh? :^) 
	 * Nah, I like keeping it ANSI and STL.*/
  cout << "\a\a";
}
