#include "general.h"
#include "kppp_logger.h"

void savelog (bool ow)
{
  char *wdir= getenv("HOME");
	string workingDir = wdir, online = workingDir + "/.kppp_logger/online.log", onlineSave = workingDir + "/.kppp_logger/online.log.save" ;
	if (e.filex (online_log, false) == FILE_MISSING)
    {
		 /* 
			This is a whimpy error msg.. msgs like; "online.log does not exist" might
			get users to reinstall and stuff, which would lead 
			to data loss.
       */
      sound ();
      leave (error, "Your log is currently empty.", no_files_open);
    }
  else if (e.filex (online_save, false) == FILE_EXISTS && ow == keep)
    {
      sound ();
      cerr << online << ".save allready exists." <<
	endl;
      cout <<
	"use kppp_logger -ss if you want to overwrite your current online.log.save."
	<< endl;
      leave (error, "void", files_open);
    }

  if (ow == overwrite)
    {
			const char *olSa = onlineSave.c_str();
      remove (olSa);
    }

  char posts;
  ofstream  WriteTo (onlineSave.c_str(), ios::app);
  ifstream  ReadFrom (online.c_str(), ios::binary);
  while (ReadFrom.read ((char *) &posts, sizeof (char)))
    WriteTo << posts;
  WriteTo << endl;		/* Nice with a blank row at the end */
  cout <<  "Your file has been saved as " << workingDir << "/.kppp_logger/online.log.save'" << endl;
	leave (clean, "void",	 files_open);

}				/* savelog */