/* program to send home e-mail over term */
/* Original author: mykes */
/* Updates by: Byron A. Jeff (byron@cc.gatech.edu) */

/* This program is a daemon that intercepts incoming mail and transports
   it to a remote host via term. In combination with the tmail program
   mail to your internet connected host will be delivered to the spool
   directory of the remote machine. 

   New features:

   - True daemon. mailerd forks off a console disconnected child process
     that continues to run even after logging off. 
   - Multiple daemon check. mailerd checks for a currently executing
     mailerd daemon before forking off a new one. Can also be used
     as a login program because of the gurantee of only one daemon.
   - TERM existance check. Before attempting mail delivery mailerd check
     to make sure a term server is running. This ensures that mail is
     only delivered if the remote machine is connected via term. This
     feature allows the daemon to run all the time and the user to get
     mail from the local machine if the TERM server is not available.
   - Log file. By defining the LOG define the log file .mailerd.log is
     enabled. The log will print the status of the term server each
     time the local mailbox is checked. Not for normal Usage.

   BAJ 3/5/94
*/
 

/* Also this program expects tmail, the linux side of the mailer program
   to be in /local/bin. Edit if necessary */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>

#include <sys/ioccom.h>
#include <sys/ttycom.h>

/* Edit the MAILFILE variable to reflect your mailfile name! -BAJ */

#ifndef MAILFILE
#define MAILFILE "/usr/spool/mail/yourname"
#endif

void CheckMail(void) {
	struct stat s;
	if (!stat(MAILFILE, &s) && s.st_size) {
		int infd, outfd, size;
		char buf[128];

		infd = open(MAILFILE, O_RDONLY);
		if (infd < 0) return;
		outfd = open("newmail", O_WRONLY|O_TRUNC|O_CREAT, 0600);
		if (outfd < 0) { close(infd); return; }
		while (size = read(infd, buf, 128))
			write(outfd, buf, size);
		close(outfd); close(infd);
		outfd = open(MAILFILE, O_WRONLY|O_TRUNC|O_CREAT, 0600);
		close(outfd);
		system("tupload -q newmail /usr/tmp");
		system("trsh -s /local/bin/tmail >/dev/null");
		unlink("newmail");
	}
}

unsigned sleepTime = 30;

int main(int ac, char *av[]) {
	int rc;
	FILE *fp,*log;
	char *home,fn[128],termon[12];

	if (ac == 2) {
		sleepTime = atoi(av[1]);
	}
	else if (ac > 1) {
		printf("Usage: %s { sleeptime }\n", av[0]);
		return 1;
	}

	home = getenv("HOME");
	sprintf(fn,"%s/.mailerd.pid",home);
	if (access(fn,R_OK) == 0) {
		fp = fopen(fn,"r");
		fscanf(fp,"%d",&rc);
                fclose(fp);
                printf("Checking existing process %d\n",rc);
                if (kill(rc,0) == 0) {
                   printf("Process is alive. exiting. \n\n");
                   exit(1);
                }
	}
 
	printf("%s activated, checking for mail every %d seconds\n",
		av[0], sleepTime);
	fflush(stdout);

	if ((rc = fork()) > 0) {
		fp = fopen(fn,"w");
		fprintf(fp,"%d\n",rc);
		fclose(fp);
		exit(0);
	}
	if (rc < 0)
		exit(-1);


	rc = open("/dev/tty",O_RDWR);
	ioctl(rc,TIOCNOTTY,0);
 
#ifdef LOG
	sprintf(fn,"%s/.mailerd.log",home);
	log = fopen(fn,"w");
#endif
	
	sprintf(termon,"%s/.mailerd.termon",home);
	while (1) {
		/* Make sure term is available */
		rc = (system("tupload -q .empty 2>/dev/null") >> 8) & 255;
		if (rc != 1) {
#ifdef LOG
			fprintf(log,"Term is available.\n");
			fflush(log);
#endif
			CheckMail();
		}
#ifdef LOG
		else {
			fprintf(log,"Term is NOT available.\n");
			fflush(log);
		}
#endif
		sleep(sleepTime);
	}
}

