/*
 * devname.c
 *
 */

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/sysmacros.h>
#include "ps.h"

char *
dev_to_name(int dev)
{
    char *d;
    static char name[8];

    if (dev == -1)
	return "?";
    d = find_dev(dev);
    if (d)
	return d;
    sprintf(name, "%d,%d", major(dev), minor(dev));
    return name;
}

int
name_to_dev(char *name)
{
    struct stat statbuf;
    char path[PATH_MAX];

    if (*name == '\0') {		/* empty string: controlling terminal */
	if ((fstat(0, &statbuf) >= 0 && (S_ISCHR(statbuf.st_mode) || S_ISBLK(statbuf.st_mode)))
	    || (fstat(1, &statbuf) >= 0 && (S_ISCHR(statbuf.st_mode) || S_ISBLK(statbuf.st_mode)))
	    || (fstat(2, &statbuf) >= 0 && (S_ISCHR(statbuf.st_mode) || S_ISBLK(statbuf.st_mode))))
	    return statbuf.st_rdev;
	else
	    return -1;
    }
    if (strcmp(name, "?") == 0)
	return -1;
    if (strcmp(name, "co") == 0)
	name = "console";
    if (stat(name, &statbuf) >= 0 && (S_ISCHR(statbuf.st_mode) || S_ISBLK(statbuf.st_mode)))
	return statbuf.st_rdev;
    sprintf(path, "/dev/%s", name);
    if (stat(path, &statbuf) >= 0 && (S_ISCHR(statbuf.st_mode) || S_ISBLK(statbuf.st_mode)))
	return statbuf.st_rdev;
    sprintf(path, "/dev/tty%s", name);
    if (stat(path, &statbuf) >= 0 && (S_ISCHR(statbuf.st_mode) || S_ISBLK(statbuf.st_mode)))
	return statbuf.st_rdev;
    fprintf(stderr, "the name `%s' is not a known device\n", name);
    exit(1);
}
